/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.axis2.core.utils;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jst.ws.axis2.core.utils.Axis2CoreUtils;
import org.eclipse.jst.ws.axis2.core.utils.FileUtils;
import org.eclipse.jst.ws.internal.common.J2EEUtils;

public class FacetContainerUtils {
    public static String pathToWebProjectContainer(String project) {
        String workspaceDirectory = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        String projectString = FacetContainerUtils.replaceEscapecharactors(project.toString());
        String currentDynamicWebProjectDir = J2EEUtils.getWebContentPath((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(FacetContainerUtils.getProjectNameFromFramewokNameString(projectString))).toOSString();
        String webContainerDirString = Axis2CoreUtils.addAnotherNodeToPath(workspaceDirectory, currentDynamicWebProjectDir);
        return webContainerDirString;
    }

    public static String pathToWebProjectContainerLib(String project) {
        String workspaceDirectory = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        String webContainerWEBINF = J2EEUtils.getWebInfPath((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(FacetContainerUtils.getProjectNameFromFramewokNameString(project))).toOSString();
        String webContainerWEBINFString = Axis2CoreUtils.addAnotherNodeToPath(workspaceDirectory, webContainerWEBINF);
        return Axis2CoreUtils.addAnotherNodeToPath(webContainerWEBINFString, "lib");
    }

    private static String replaceEscapecharactors(String vulnarableString) {
        if (vulnarableString.indexOf("/") != -1) {
            vulnarableString = vulnarableString.replace('/', File.separator.charAt(0));
        }
        return vulnarableString;
    }

    private static String getProjectNameFromFramewokNameString(String frameworkProjectString) {
        if (frameworkProjectString.indexOf(FacetContainerUtils.getSplitCharactor()) == -1) {
            return frameworkProjectString;
        }
        return frameworkProjectString.split(FacetContainerUtils.getSplitCharactors())[1];
    }

    private static String getSplitCharactor() {
        if (File.separatorChar == '\\') {
            return "\\";
        }
        return File.separator;
    }

    private static String getSplitCharactors() {
        if (File.separatorChar == '\\') {
            return "\\" + File.separator;
        }
        return File.separator;
    }

    public static String getDeployedWSDLURL(String projectName, String serviceName) {
        String[] deployedWSDLURLParts = new String[]{projectName.split("Client")[0], "services", serviceName};
        return String.valueOf(FileUtils.addNodesToURL("http://localhost:8080", deployedWSDLURLParts)) + "?wsdl";
    }
}

