/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.action;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ValidateAction
extends Action
implements ISelectionChangedListener {
    protected ISelectionProvider selectionProvider;
    protected List<Object> selectedObjects;
    protected EditingDomain domain;
    protected EclipseResourcesUtil eclipseResourcesUtil = EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE ? new EclipseResourcesUtil() : null;

    public ValidateAction() {
        super(EMFEditUIPlugin.INSTANCE.getString("_UI_Validate_menu_item"));
        this.setDescription(EMFEditUIPlugin.INSTANCE.getString("_UI_Validate_simple_description"));
    }

    public void run() {
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(final IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    final Diagnostic diagnostic = ValidateAction.this.validate(progressMonitor);
                    shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (progressMonitor.isCanceled()) {
                                ValidateAction.this.handleDiagnostic(Diagnostic.CANCEL_INSTANCE);
                            } else {
                                ValidateAction.this.handleDiagnostic(diagnostic);
                            }
                        }
                    });
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        if (this.eclipseResourcesUtil != null) {
            runnableWithProgress = this.eclipseResourcesUtil.getWorkspaceModifyOperation(runnableWithProgress);
        }
        try {
            new ProgressMonitorDialog(shell).run(true, true, runnableWithProgress);
        }
        catch (Exception exception) {
            EMFEditUIPlugin.INSTANCE.log(exception);
        }
    }

    protected Diagnostic validate(final IProgressMonitor progressMonitor) {
        EObject eObject = (EObject)this.selectedObjects.iterator().next();
        int count = 0;
        TreeIterator i = eObject.eAllContents();
        while (i.hasNext()) {
            ++count;
            i.next();
        }
        progressMonitor.beginTask("", count);
        final AdapterFactory adapterFactory = this.domain instanceof AdapterFactoryEditingDomain ? ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory() : null;
        Diagnostician diagnostician = new Diagnostician(){

            public String getObjectLabel(EObject eObject) {
                IItemLabelProvider itemLabelProvider;
                if (adapterFactory != null && !eObject.eIsProxy() && (itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class)) != null) {
                    return itemLabelProvider.getText((Object)eObject);
                }
                return super.getObjectLabel(eObject);
            }

            public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                progressMonitor.worked(1);
                return super.validate(eClass, eObject, diagnostics, context);
            }
        };
        progressMonitor.setTaskName(EMFEditUIPlugin.INSTANCE.getString("_UI_Validating_message", new Object[]{diagnostician.getObjectLabel(eObject)}));
        return diagnostician.validate(eObject);
    }

    protected void handleDiagnostic(Diagnostic diagnostic) {
        int severity = diagnostic.getSeverity();
        String title = null;
        String message = null;
        if (severity == 4 || severity == 2) {
            title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_title");
            message = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_message");
        } else {
            title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationResults_title");
            message = EMFEditUIPlugin.INSTANCE.getString(severity == 0 ? "_UI_ValidationOK_message" : "_UI_ValidationResults_message");
        }
        int result = 0;
        if (diagnostic.getSeverity() == 0) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
            result = 1;
        } else {
            result = DiagnosticDialog.openProblem((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message, (Diagnostic)diagnostic);
        }
        if (this.eclipseResourcesUtil != null) {
            Resource resource = (Resource)this.domain.getResourceSet().getResources().get(0);
            if (resource != null) {
                this.eclipseResourcesUtil.deleteMarkers(resource);
            }
            if (result == 0) {
                List data;
                if (!diagnostic.getChildren().isEmpty() && !(data = ((Diagnostic)diagnostic.getChildren().get(0)).getData()).isEmpty() && data.get(0) instanceof EObject) {
                    Viewer viewer;
                    IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                    if (part instanceof ISetSelectionTarget) {
                        ((ISetSelectionTarget)part).selectReveal((ISelection)new StructuredSelection(data.get(0)));
                    } else if (part instanceof IViewerProvider && (viewer = ((IViewerProvider)part).getViewer()) != null) {
                        viewer.setSelection((ISelection)new StructuredSelection(data.get(0)), true);
                    }
                }
                if (resource != null) {
                    for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                        this.eclipseResourcesUtil.createMarkers(resource, childDiagnostic);
                    }
                }
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionProvider = event.getSelectionProvider();
        if (event.getSelection() instanceof IStructuredSelection) {
            this.setEnabled(this.updateSelection((IStructuredSelection)event.getSelection()));
        } else {
            this.setEnabled(false);
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        this.selectedObjects = new ArrayList<Object>();
        Iterator objects = selection.iterator();
        while (objects.hasNext()) {
            this.selectedObjects.add(AdapterFactoryEditingDomain.unwrap(objects.next()));
        }
        return this.selectedObjects.size() == 1 && this.selectedObjects.get(0) instanceof EObject;
    }

    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)workbenchPart).getEditingDomain();
        }
    }

    public static class EclipseResourcesUtil
    extends EditUIMarkerHelper {
        public IRunnableWithProgress getWorkspaceModifyOperation(IRunnableWithProgress runnableWithProgress) {
            return new WorkspaceModifyDelegatingOperation(runnableWithProgress);
        }

        protected String getMarkerID() {
            return "org.eclipse.emf.ecore.diagnostic";
        }

        public void createMarkers(Resource resource, Diagnostic diagnostic) {
            try {
                this.createMarkers((IResource)this.getFile(resource), diagnostic, null);
            }
            catch (CoreException e) {
                EMFEditUIPlugin.INSTANCE.log((Object)e);
            }
        }

        protected String composeMessage(Diagnostic diagnostic, Diagnostic parentDiagnostic) {
            String parentMessage;
            String message = diagnostic.getMessage();
            if (parentDiagnostic != null && (parentMessage = parentDiagnostic.getMessage()) != null) {
                message = message != null ? String.valueOf(parentMessage) + ". " + message : parentMessage;
            }
            return message;
        }

        protected void adjustMarker(IMarker marker, Diagnostic diagnostic, Diagnostic parentDiagnostic) throws CoreException {
            List data = diagnostic.getData();
            StringBuilder relatedURIs = new StringBuilder();
            boolean first = true;
            for (Object object : data) {
                if (!(object instanceof EObject)) continue;
                EObject eObject = (EObject)object;
                if (first) {
                    first = false;
                    marker.setAttribute("uri", (Object)EcoreUtil.getURI((EObject)eObject).toString());
                    continue;
                }
                if (relatedURIs.length() != 0) {
                    relatedURIs.append(' ');
                }
                relatedURIs.append(URI.encodeFragment((String)EcoreUtil.getURI((EObject)eObject).toString(), (boolean)false));
            }
            if (relatedURIs.length() > 0) {
                marker.setAttribute("relatedURIs", (Object)relatedURIs.toString());
            }
            super.adjustMarker(marker, diagnostic, parentDiagnostic);
        }
    }
}

