/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.gen.internal;

import org.eclipse.jpt.db.internal.ForeignKey;
import org.eclipse.jpt.gen.internal.GenTable;

class ManyToManyRelation {
    private final GenTable joinTable;
    private final ForeignKey owningForeignKey;
    private final GenTable owningTable;
    private final ForeignKey nonOwningForeignKey;
    private final GenTable nonOwningTable;
    private String mappedBy;

    ManyToManyRelation(GenTable joinTable, ForeignKey owningForeignKey, GenTable owningTable, ForeignKey nonOwningForeignKey, GenTable nonOwningTable) {
        this.joinTable = joinTable;
        this.owningForeignKey = owningForeignKey;
        this.owningTable = owningTable;
        owningTable.addOwnedManyToManyRelation(this);
        this.nonOwningForeignKey = nonOwningForeignKey;
        this.nonOwningTable = nonOwningTable;
        nonOwningTable.addNonOwnedManyToManyRelation(this);
    }

    GenTable getJoinTable() {
        return this.joinTable;
    }

    ForeignKey getOwningForeignKey() {
        return this.owningForeignKey;
    }

    GenTable getOwningTable() {
        return this.owningTable;
    }

    ForeignKey getNonOwningForeignKey() {
        return this.nonOwningForeignKey;
    }

    GenTable getNonOwningTable() {
        return this.nonOwningTable;
    }

    private GenTable otherTable(GenTable table) {
        return table == this.owningTable ? this.nonOwningTable : this.owningTable;
    }

    String javaFieldNameFor(GenTable table) {
        return String.valueOf(this.otherTable(table).javaFieldName()) + "_collection";
    }

    void clear() {
        this.owningTable.removeOwnedManyToManyRelation(this);
        this.nonOwningTable.removeNonOwnedManyToManyRelation(this);
    }

    String getMappedBy() {
        return this.mappedBy;
    }

    void setMappedBy(String mappedBy) {
        this.mappedBy = mappedBy;
    }

    String owningEntityName() {
        return this.owningTable.getEntityName();
    }

    String nonOwningEntityName() {
        return this.nonOwningTable.getEntityName();
    }

    boolean joinTableNameIsDefault() {
        return this.joinTable.name().equals(String.valueOf(this.getOwningTable().name()) + "_" + this.getNonOwningTable().name());
    }

    boolean joinColumnsIsDefaultFor(String javaFieldName) {
        return this.owningForeignKey.isDefaultFor(javaFieldName);
    }

    boolean inverseJoinColumnsIsDefaultFor(String javaFieldName) {
        return this.nonOwningForeignKey.isDefaultFor(javaFieldName);
    }
}

