/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor;

import java.sql.Connection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.modelbase.dbdefinition.DatabaseVendorDefinition;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import org.eclipse.osgi.util.NLS;

public class SQLEditorConnectionInfo
implements ISQLEditorConnectionInfo {
    public static ISQLEditorConnectionInfo DEFAULT_SQLEDITOR_CONNECTION_INFO = new SQLEditorConnectionInfo(SQLToolsFacade.getNonSpecificDatabaseVendorDefinitionId());
    private DatabaseVendorDefinitionId _dbVendorId = null;
    private DatabaseVendorDefinition _dbVendor = null;
    private String _profileName = null;
    private String _databaseName = null;
    private Database _database = null;
    private String _defaultSchemaName = null;
    private Connection _sharedConn = null;
    private int _profileStatus = 0;

    public SQLEditorConnectionInfo(DatabaseVendorDefinitionId dbVendorId) {
        this._dbVendorId = dbVendorId;
    }

    public SQLEditorConnectionInfo(DatabaseVendorDefinitionId dbVendorId, String profileName, String dbName) {
        this(dbVendorId, profileName, dbName, null);
    }

    public SQLEditorConnectionInfo(DatabaseVendorDefinitionId dbVendorId, String profileName, String dbName, String schemaName) {
        this._profileName = profileName;
        this._dbVendorId = dbVendorId == null ? (this._profileName == null ? SQLToolsFacade.getNonSpecificDatabaseVendorDefinitionId() : ProfileUtil.getDatabaseVendorDefinitionId((String)profileName)) : dbVendorId;
        this._databaseName = dbName;
        this._defaultSchemaName = schemaName;
    }

    public DatabaseVendorDefinitionId getDatabaseVendorDefinitionId() {
        return this._dbVendorId;
    }

    public DatabaseVendorDefinition getDatabaseVendorDefinition() {
        return this._dbVendor;
    }

    public IConnectionProfile getConnectionProfile() {
        return ProfileManager.getInstance().getProfileByName(this._profileName);
    }

    public String getConnectionProfileName() {
        return this._profileName;
    }

    public Database getDatabase() {
        if (this._database == null && this._profileName != null) {
            this._database = ProfileUtil.getDatabase((DatabaseIdentifier)new DatabaseIdentifier(this._profileName, this._databaseName));
        }
        return this._database;
    }

    public String getDatabaseName() {
        return this._databaseName;
    }

    public String getDefaultSchemaName() {
        return this._defaultSchemaName;
    }

    public void setConnectionProfileName(String profileName) {
        this._profileName = profileName;
    }

    public void setDatabase(Database database) {
        this._database = database;
    }

    public void setDefaultSchemaName(String schemaName) {
        this._defaultSchemaName = schemaName;
    }

    public void setDatabaseVendorDefinitionId(DatabaseVendorDefinitionId dbVendorDefId) {
        this._dbVendorId = dbVendorDefId;
    }

    public String encode() {
        StringBuffer code = new StringBuffer("");
        code.append(this._dbVendorId == null ? "" : this._dbVendorId.toString()).append(":");
        code.append(this._profileName == null ? "" : this._profileName).append(":");
        code.append(this._databaseName == null ? "" : this._databaseName.toString()).append(":");
        code.append(this._defaultSchemaName == null ? "" : this._defaultSchemaName.toString());
        return code.toString();
    }

    public static ISQLEditorConnectionInfo decode(String code) {
        if (code == null || !code.matches(".*:.*:.*:.*")) {
            SQLEditorPlugin.getDefault().log(NLS.bind((String)SQLEditorResources.SQLEditorConnectionInfo_decode_error, (Object[])new String[]{code}));
            return DEFAULT_SQLEDITOR_CONNECTION_INFO;
        }
        int i = 0;
        int j = code.indexOf(58);
        String dbVendorId = code.substring(i, j);
        i = j + 1;
        j = code.indexOf(58, i);
        String profileName = code.substring(i, j);
        i = j + 1;
        j = code.indexOf(58, i);
        String dbName = code.substring(i, j);
        i = j + 1;
        j = code.length();
        String schemaName = code.substring(i, j);
        if (profileName.equals("")) {
            if (dbVendorId.equals("")) {
                return DEFAULT_SQLEDITOR_CONNECTION_INFO;
            }
            return new SQLEditorConnectionInfo(new DatabaseVendorDefinitionId(dbVendorId));
        }
        return new SQLEditorConnectionInfo(null, profileName, dbName, schemaName);
    }

    public String getName() {
        StringBuffer code = new StringBuffer("");
        code.append(NLS.bind((String)SQLEditorResources.SQLEditor_status_dbType, (Object)this._dbVendorId.toString()));
        code.append(this._profileName == null ? "" : NLS.bind((String)SQLEditorResources.SQLEditor_status_profile, (Object)this._profileName));
        code.append(this._profileName == null || this._databaseName == null ? "" : NLS.bind((String)SQLEditorResources.SQLEditor_status_database, (Object)this._databaseName));
        if (this.isConnected()) {
            code.append(SQLEditorResources.SQLEditor_status_profile_connected);
        } else {
            code.append(SQLEditorResources.SQLEditor_status_profile_notconnected);
        }
        return code.toString();
    }

    public Connection getSharedConnection() {
        if (this._sharedConn == null && this.getConnectionProfile() != null && this.getConnectionProfile().isConnected()) {
            try {
                this._sharedConn = ProfileUtil.getReusableConnection((DatabaseIdentifier)new DatabaseIdentifier(this._profileName, this._databaseName));
            }
            catch (Exception e) {
                SQLEditorPlugin.getDefault().log(e);
            }
        }
        return this._sharedConn;
    }

    public int getProfileStatus() {
        return this._profileStatus;
    }

    public void setProfileStatus(int status) {
        this._profileStatus = status;
    }

    public boolean isConnected() {
        return this.getSharedConnection() != null && this._profileStatus != 2 && this._profileStatus != 1;
    }
}

