/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.sql;

import org.eclipse.datatools.modelbase.sql.routines.Function;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;

public class SQLDBProposal {
    public static final int SCHEMA_OBJTYPE = 1;
    public static final int TABLE_OBJTYPE = 2;
    public static final int TABLECOLUMN_OBJTYPE = 3;
    public static final int CATALOG_OBJTYPE = 4;
    public static final int FUNCTION_OBJTYPE = 5;
    public static final int STORED_PROCEDURE_OBJTYPE = 6;
    public static final int TRIGGER_OBJTYPE = 7;
    public static final int EVENT_OBJTYPE = 8;
    public static final int TABLEALIAS_OBJTYPE = 9;
    public static final int UNKNOWN_OBJTYPE = -1;
    private EObject fDBObject;
    private Image fImage = null;
    private String fName = null;
    private String fParentAlias = null;
    private String fParentName = null;
    private String fGrandParentName = null;
    private String fGrandGrandParentName = null;
    private EObject fParentObject;
    private int fType = -1;

    public SQLDBProposal(EObject dbObject, String alias) {
        this(dbObject);
        this.fParentAlias = alias;
    }

    public SQLDBProposal(String alias) {
        this.fType = 9;
        this.fName = alias;
        this.fParentName = null;
        this.fGrandParentName = null;
        this.fParentObject = null;
        this.setImage(SQLEditorResources.getImage("table_alias"));
    }

    public SQLDBProposal(EObject dbObject) {
        this.fDBObject = dbObject;
        if (dbObject instanceof Schema) {
            this.fType = 1;
            this.fName = ((Schema)dbObject).getName();
            this.fParentName = ((Schema)dbObject).getDatabase().getName();
            this.fParentObject = ((Schema)dbObject).getDatabase();
            this.fGrandParentName = null;
            this.fGrandGrandParentName = null;
            this.setImage(SQLEditorResources.getImage("schema"));
        } else if (dbObject instanceof Table) {
            this.fType = 2;
            this.fName = ((Table)dbObject).getName();
            this.fParentName = ((Table)dbObject).getSchema().getName();
            this.fParentObject = ((Table)dbObject).getSchema();
            this.fGrandParentName = ModelUtil.getDatabaseName((EObject)((Schema)this.fParentObject));
            this.fGrandGrandParentName = null;
            if (dbObject instanceof ViewTable) {
                this.setImage(SQLEditorResources.getImage("view"));
            } else {
                this.setImage(SQLEditorResources.getImage("table"));
            }
        } else if (dbObject instanceof Column) {
            this.fType = 3;
            this.fName = ((Column)dbObject).getName();
            this.fParentName = ((Column)dbObject).getTable().getSchema().getName() + "." + ((Column)dbObject).getTable().getName();
            this.fParentObject = ((Column)dbObject).getTable();
            this.fGrandParentName = ((Table)this.fParentObject).getSchema().getName();
            this.fGrandGrandParentName = ModelUtil.getDatabaseName((EObject)((Table)this.fParentObject).getSchema());
            this.setImage(SQLEditorResources.getImage("column"));
        } else if (dbObject instanceof Function) {
            this.fType = 5;
            this.fName = ((Function)dbObject).getName();
            this.fParentName = ((Function)dbObject).getSchema().getName();
            this.fParentObject = ((Function)dbObject).getSchema();
            this.fGrandParentName = ModelUtil.getDatabaseName((EObject)((Schema)this.fParentObject));
            this.fGrandGrandParentName = null;
            this.setImage(SQLEditorResources.getImage("function"));
        } else if (dbObject instanceof Procedure) {
            this.fType = 6;
            this.fName = ((Procedure)dbObject).getName();
            this.fParentName = ((Procedure)dbObject).getSchema().getName();
            this.fParentObject = ((Procedure)dbObject).getSchema();
            this.fGrandParentName = ModelUtil.getDatabaseName((EObject)((Schema)this.fParentObject));
            this.fGrandGrandParentName = null;
            this.setImage(SQLEditorResources.getImage("procedure"));
        } else if (dbObject instanceof Event) {
            this.fType = 8;
            this.fName = ((Event)dbObject).getName();
            this.fParentName = ((Event)dbObject).getDatabase().getName();
            this.fParentObject = ((Event)dbObject).getDatabase();
            this.fGrandParentName = null;
            this.fGrandGrandParentName = null;
            this.setImage(SQLEditorResources.getImage("event"));
        } else if (dbObject instanceof Trigger) {
            this.fType = 5;
            this.fName = ((Trigger)dbObject).getName();
            this.fParentName = ((Trigger)dbObject).getSubjectTable().getSchema().getName() + "." + ((Trigger)dbObject).getSubjectTable().getName();
            this.fParentObject = ((Trigger)dbObject).getSubjectTable();
            this.fGrandParentName = ((Table)this.fParentObject).getSchema().getName();
            this.fGrandGrandParentName = ModelUtil.getDatabaseName((EObject)((Table)this.fParentObject).getSchema());
            this.setImage(SQLEditorResources.getImage("trigger"));
        } else if (dbObject instanceof Catalog) {
            this.fType = 4;
            this.fName = ((Catalog)dbObject).getName();
            this.fParentObject = ((Catalog)dbObject).getDatabase();
            this.setImage(SQLEditorResources.getImage("database"));
        }
    }

    public EObject getDBObject() {
        return this.fDBObject;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getName() {
        return this.fName;
    }

    public String getParentAlias() {
        if (this.fParentAlias != null) {
            return this.fParentAlias;
        }
        return this.fParentName;
    }

    public String getParentName() {
        return this.fParentName;
    }

    public String getGrandParentName() {
        return this.fGrandParentName;
    }

    public String getGrandGrandParentName() {
        return this.fGrandGrandParentName;
    }

    public EObject getParentObject() {
        return this.fParentObject;
    }

    public int getType() {
        return this.fType;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public void setParentName(String parentName) {
        this.fParentName = parentName;
    }

    public String toString() {
        return this.fName;
    }
}

