/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.utils;

import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.ISQLEditorInput;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.utils.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorUtil {
    public static void setEditorsProfileStatus(String profileName, int status) {
        IEditorReference[] ht = SQLEditorPlugin.getActiveWorkbenchPage().getEditorReferences();
        if (ht == null || ht.length == 0) {
            return;
        }
        for (int i = 0; i < ht.length; ++i) {
            IEditorReference ref = ht[i];
            IEditorInput input = null;
            try {
                input = ref.getEditorInput();
            }
            catch (PartInitException e) {
                SQLEditorPlugin.getDefault().log(e);
            }
            if (!(input instanceof ISQLEditorInput)) continue;
            ISQLEditorInput sqlEditorInput = (ISQLEditorInput)input;
            ISQLEditorConnectionInfo info = sqlEditorInput.getConnectionInfo();
            info.setProfileStatus(status);
            info.setDatabase(null);
            if (status == 1) {
                info.setConnectionProfileName(null);
            } else {
                info.setConnectionProfileName(profileName);
            }
            SQLEditor editor = (SQLEditor)ref.getEditor(false);
            if (editor == null) continue;
            editor.setConnectionInfo(info);
        }
    }

    public static boolean okToCloseEditors(String profileName) {
        IEditorReference[] ht = SQLEditorPlugin.getActiveWorkbenchPage().getEditorReferences();
        if (ht == null || ht.length == 0) {
            return true;
        }
        for (int i = 0; i < ht.length; ++i) {
            ISQLEditorInput sqlEditorInput;
            ISQLEditorConnectionInfo info;
            final IEditorReference ref = ht[i];
            IEditorInput input = null;
            try {
                input = ref.getEditorInput();
            }
            catch (PartInitException e) {
                SQLEditorPlugin.getDefault().log(e);
            }
            if (!(input instanceof ISQLEditorInput) || !((ISQLEditorInput)input).isConnectionRequired() || !profileName.equals((info = (sqlEditorInput = (ISQLEditorInput)input).getConnectionInfo()).getConnectionProfileName())) continue;
            final boolean[] ok = new boolean[]{true};
            SQLEditorPlugin.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (ref.isDirty()) {
                        MessageDialog.openError(null, (String)Messages.Disconnect_error, (String)Messages.Cannot_disconnect_before_save);
                        ok[0] = false;
                    }
                }
            });
            if (ok[0]) continue;
            return false;
        }
        return true;
    }

    public static boolean closeAllEditors(String profileName) {
        IEditorReference[] ht = SQLEditorPlugin.getActiveWorkbenchPage().getEditorReferences();
        if (ht == null || ht.length == 0) {
            return true;
        }
        boolean success = true;
        for (int i = 0; i < ht.length; ++i) {
            ITextEditor editor;
            ISQLEditorInput sqlEditorInput;
            ISQLEditorConnectionInfo info;
            IEditorReference ref = ht[i];
            IEditorInput input = null;
            try {
                input = ref.getEditorInput();
            }
            catch (PartInitException e) {
                SQLEditorPlugin.getDefault().log(e);
            }
            if (!(input instanceof ISQLEditorInput) || !((ISQLEditorInput)input).isConnectionRequired() || !profileName.equals((info = (sqlEditorInput = (ISQLEditorInput)input).getConnectionInfo()).getConnectionProfileName()) || (editor = (ITextEditor)ref.getEditor(false)) == null) continue;
            editor.close(true);
        }
        return success;
    }

    public static void renameEditorsProfileName(String oldName, String newName) {
        IEditorReference[] ht = SQLEditorPlugin.getActiveWorkbenchPage().getEditorReferences();
        if (ht == null || ht.length == 0) {
            return;
        }
        for (int i = 0; i < ht.length; ++i) {
            ISQLEditorInput sqlEditorInput;
            ISQLEditorConnectionInfo info;
            IEditorReference ref = ht[i];
            IEditorInput input = null;
            try {
                input = ref.getEditorInput();
            }
            catch (PartInitException e) {
                SQLEditorPlugin.getDefault().log(e);
            }
            if (!(input instanceof ISQLEditorInput) || !oldName.equals((info = (sqlEditorInput = (ISQLEditorInput)input).getConnectionInfo()).getConnectionProfileName())) continue;
            info.setConnectionProfileName(newName);
            SQLEditor editor = (SQLEditor)ref.getEditor(false);
            if (editor == null) continue;
            editor.setConnectionInfo(info);
        }
    }
}

