/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.archive.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.ArchiveOptions;
import org.eclipse.jst.jee.archive.ArchiveSaveFailureException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveFactory;
import org.eclipse.jst.jee.archive.IArchiveSaveAdapter;
import org.eclipse.jst.jee.archive.internal.ArchiveImpl;
import org.eclipse.jst.jee.archive.internal.ArchiveUtil;
import org.eclipse.jst.jee.archive.internal.ZipFileArchiveLoadAdapterImpl;
import org.eclipse.jst.jee.archive.internal.ZipStreamArchiveSaveAdapterImpl;

public class ArchiveFactoryImpl
implements IArchiveFactory {
    public IArchive openArchive(IPath archivePath) throws ArchiveOpenFailureException {
        ZipFile zipFile;
        File file = new File(archivePath.toOSString());
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException e) {
            ArchiveOpenFailureException openFailureException = new ArchiveOpenFailureException(e);
            throw openFailureException;
        }
        catch (IOException e) {
            ArchiveOpenFailureException openFailureException = new ArchiveOpenFailureException(e);
            throw openFailureException;
        }
        ZipFileArchiveLoadAdapterImpl loadAdapter = new ZipFileArchiveLoadAdapterImpl(zipFile);
        ArchiveOptions archiveOptions = new ArchiveOptions();
        archiveOptions.setOption("LOAD_ADAPTER", loadAdapter);
        return this.openArchive(archiveOptions);
    }

    public IArchive openArchive(ArchiveOptions archiveOptions) throws ArchiveOpenFailureException {
        ArchiveImpl archive = new ArchiveImpl(archiveOptions);
        return archive;
    }

    public void closeArchive(IArchive archive) {
        ((ArchiveImpl)archive).close();
    }

    public void saveArchive(IArchive archive, IPath outputPath) throws ArchiveSaveFailureException {
        String aUri = outputPath.toOSString();
        File aFile = new File(aUri);
        ArchiveUtil.checkWriteable(aFile);
        boolean fileExisted = aFile.exists();
        IArchiveSaveAdapter aSaveAdapter = null;
        try {
            try {
                File destinationFile = fileExisted ? ArchiveUtil.createTempFile(aUri, aFile.getCanonicalFile().getParentFile()) : aFile;
                aSaveAdapter = this.createSaveAdapterForJar(destinationFile);
                aSaveAdapter.setArchive(archive);
                this.save(aSaveAdapter);
                aSaveAdapter.close();
                this.closeArchive(archive);
                if (fileExisted) {
                    ArchiveUtil.cleanupAfterTempSave(aUri, aFile, destinationFile);
                }
            }
            catch (IOException iOException) {}
        }
        catch (ArchiveSaveFailureException failure) {
            try {
                if (aSaveAdapter != null) {
                    aSaveAdapter.close();
                }
            }
            catch (IOException iOException) {}
            if (!fileExisted) {
                aFile.delete();
            }
            throw failure;
        }
    }

    protected IArchiveSaveAdapter createSaveAdapterForJar(File aFile) throws IOException {
        File parent;
        if (aFile.exists()) {
            aFile.isDirectory();
        }
        if ((parent = aFile.getParentFile()) != null) {
            parent.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(aFile);
        return new ZipStreamArchiveSaveAdapterImpl(out);
    }

    public void save(IArchiveSaveAdapter anAdapter) throws ArchiveSaveFailureException {
        try {
            anAdapter.save();
        }
        finally {
            try {
                anAdapter.close();
            }
            catch (IOException e) {
                throw new ArchiveSaveFailureException(e);
            }
        }
    }

    public void saveArchive(IArchive archive, ArchiveOptions archiveOptions) throws ArchiveSaveFailureException {
        IArchiveSaveAdapter aSaveAdapter = (IArchiveSaveAdapter)archiveOptions.getOption("SAVE_ADAPTER");
        try {
            aSaveAdapter.setArchive(archive);
            this.save(aSaveAdapter);
            aSaveAdapter.close();
            this.closeArchive(archive);
        }
        catch (ArchiveSaveFailureException failure) {
            try {
                if (aSaveAdapter != null) {
                    aSaveAdapter.close();
                }
            }
            catch (IOException iOException) {}
            throw failure;
        }
        catch (IOException iOException) {}
    }
}

