/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.CustomAndExpression;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.ExtensionPriorityComparator;
import org.eclipse.ui.internal.navigator.extensions.INavigatorContentExtPtConstants;
import org.eclipse.ui.internal.navigator.extensions.OverridePolicy;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.Priority;

public final class NavigatorContentDescriptor
implements INavigatorContentDescriptor,
INavigatorContentExtPtConstants {
    private static final int HASH_CODE_NOT_COMPUTED = -1;
    private String id;
    private String name;
    private IConfigurationElement configElement;
    private int priority = 3;
    private Expression enablement;
    private Expression possibleChildren;
    private String icon;
    private boolean activeByDefault;
    private IPluginContribution contribution;
    private Set overridingExtensions;
    private OverridePolicy overridePolicy;
    private String suppressedExtensionId;
    private INavigatorContentDescriptor overriddenDescriptor;
    private int hashCode = -1;
    private boolean providesSaveables;

    NavigatorContentDescriptor(IConfigurationElement configElement) throws WorkbenchException {
        this.configElement = configElement;
        this.init();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    private void init() throws WorkbenchException {
        this.id = this.configElement.getAttribute("id");
        this.name = this.configElement.getAttribute("name");
        String priorityString = this.configElement.getAttribute("priority");
        this.icon = this.configElement.getAttribute("icon");
        String activeByDefaultString = this.configElement.getAttribute("activeByDefault");
        this.activeByDefault = activeByDefaultString != null && activeByDefaultString.length() > 0 ? Boolean.valueOf(this.configElement.getAttribute("activeByDefault")) : true;
        String providesSaveablesString = this.configElement.getAttribute("providesSaveables");
        boolean bl = this.providesSaveables = providesSaveablesString != null && providesSaveablesString.length() > 0 ? Boolean.valueOf(providesSaveablesString) : false;
        if (priorityString != null) {
            try {
                Priority p = Priority.get(priorityString);
                this.priority = p != null ? p.getValue() : 3;
            }
            catch (NumberFormatException numberFormatException) {
                this.priority = 3;
            }
        }
        if (this.id == null) {
            throw new WorkbenchException(NLS.bind((String)CommonNavigatorMessages.Attribute_Missing_Warning, (Object[])new Object[]{"id", this.id, this.configElement.getDeclaringExtension().getNamespaceIdentifier()}));
        }
        IConfigurationElement[] children = this.configElement.getChildren("enablement");
        if (children.length == 0) {
            children = this.configElement.getChildren("triggerPoints");
            if (children.length != 1) {
                throw new WorkbenchException(NLS.bind((String)CommonNavigatorMessages.Attribute_Missing_Warning, (Object[])new Object[]{"triggerPoints", this.id, this.configElement.getDeclaringExtension().getNamespaceIdentifier()}));
            }
            this.enablement = new CustomAndExpression(children[0]);
            children = this.configElement.getChildren("possibleChildren");
            if (children.length == 1) {
                this.possibleChildren = new CustomAndExpression(children[0]);
            } else if (children.length > 1) {
                throw new WorkbenchException(NLS.bind((String)CommonNavigatorMessages.Attribute_Missing_Warning, (Object[])new Object[]{"possibleChildren", this.id, this.configElement.getDeclaringExtension().getNamespaceIdentifier()}));
            }
        } else if (children.length == 1) {
            try {
                this.enablement = ElementHandler.getDefault().create(ExpressionConverter.getDefault(), children[0]);
            }
            catch (CoreException e) {
                NavigatorPlugin.log(4, 0, e.getMessage(), e);
            }
        } else if (children.length > 1) {
            throw new WorkbenchException(NLS.bind((String)CommonNavigatorMessages.Attribute_Missing_Warning, (Object[])new Object[]{"enablement", this.id, this.configElement.getDeclaringExtension().getNamespaceIdentifier()}));
        }
        this.contribution = new IPluginContribution(){

            public String getLocalId() {
                return NavigatorContentDescriptor.this.getId();
            }

            public String getPluginId() {
                return NavigatorContentDescriptor.this.configElement.getDeclaringExtension().getNamespaceIdentifier();
            }
        };
        children = this.configElement.getChildren("override");
        if (children.length == 1) {
            this.suppressedExtensionId = children[0].getAttribute("suppressedExtensionId");
            this.overridePolicy = OverridePolicy.get(children[0].getAttribute("policy"));
        }
    }

    public String getIcon() {
        return this.icon;
    }

    public String getSuppressedExtensionId() {
        return this.suppressedExtensionId;
    }

    public OverridePolicy getOverridePolicy() {
        return this.overridePolicy;
    }

    public IPluginContribution getContribution() {
        return this.contribution;
    }

    public ITreeContentProvider createContentProvider() throws CoreException {
        return (ITreeContentProvider)this.configElement.createExecutableExtension("contentProvider");
    }

    public ILabelProvider createLabelProvider() throws CoreException {
        return (ILabelProvider)this.configElement.createExecutableExtension("labelProvider");
    }

    public boolean isActiveByDefault() {
        return this.activeByDefault;
    }

    public boolean isTriggerPoint(Object anElement) {
        if (this.enablement == null || anElement == null) {
            return false;
        }
        try {
            EvaluationContext context = new EvaluationContext(null, anElement);
            context.setAllowPluginActivation(true);
            return this.enablement.evaluate((IEvaluationContext)context) == EvaluationResult.TRUE;
        }
        catch (CoreException e) {
            NavigatorPlugin.logError(0, e.getMessage(), e);
            return false;
        }
    }

    public boolean isPossibleChild(Object anElement) {
        if (this.enablement == null && this.possibleChildren == null || anElement == null) {
            return false;
        }
        if (anElement instanceof IStructuredSelection) {
            return this.arePossibleChildren((IStructuredSelection)anElement);
        }
        try {
            EvaluationContext context = new EvaluationContext(null, anElement);
            context.setAllowPluginActivation(true);
            if (this.possibleChildren != null) {
                return this.possibleChildren.evaluate((IEvaluationContext)context) == EvaluationResult.TRUE;
            }
            if (this.enablement != null) {
                return this.enablement.evaluate((IEvaluationContext)context) == EvaluationResult.TRUE;
            }
        }
        catch (CoreException e) {
            NavigatorPlugin.logError(0, e.getMessage(), e);
        }
        return false;
    }

    public boolean arePossibleChildren(IStructuredSelection aSelection) {
        if (aSelection.isEmpty()) {
            return false;
        }
        Iterator iter = aSelection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (this.isPossibleChild(element)) continue;
            return false;
        }
        return true;
    }

    public boolean hasOverridingExtensions() {
        return this.overridingExtensions != null && this.overridingExtensions.size() > 0;
    }

    public Set getOverriddingExtensions() {
        if (this.overridingExtensions == null) {
            this.overridingExtensions = new TreeSet(ExtensionPriorityComparator.DESCENDING);
        }
        return this.overridingExtensions;
    }

    public String toString() {
        return "Content[" + this.id + ", \"" + this.name + "\"]";
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            String hashCodeString = String.valueOf(this.configElement.getNamespaceIdentifier()) + this.getId();
            this.hashCode = hashCodeString.hashCode();
            if (this.hashCode == -1) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    public INavigatorContentDescriptor getOverriddenDescriptor() {
        return this.overriddenDescriptor;
    }

    void setOverriddenDescriptor(INavigatorContentDescriptor theOverriddenDescriptor) {
        this.overriddenDescriptor = theOverriddenDescriptor;
    }

    public boolean hasSaveablesProvider() {
        return this.providesSaveables;
    }
}

