/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.db.derby;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.db.derby.Messages;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.internal.ui.DelimitedStringList;
import org.eclipse.datatools.connectivity.internal.ui.DriverListCombo;
import org.eclipse.datatools.connectivity.ui.wizards.ConnectionProfileDetailsPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DerbyEmbeddedDBProfileDetailsWizardPage
extends ConnectionProfileDetailsPage {
    private Text mDatabaseNameText;
    private Text mURLText;
    private Text mDBUIDText;
    private Text mDBPWDText;
    private Button mSaveDBPWDCheckbox;
    private DelimitedStringList mDBConnProps;
    final DriverListCombo combo = new DriverListCombo();
    private Button mCreateDBCheckbox;
    private Button mUpgradeDBCheckbox;
    private Text mDBFilePathText;
    private Button mBrowseFilePathButton;
    private DriverInstance mDriverInstance;
    private String mDriverCategory;

    public DerbyEmbeddedDBProfileDetailsWizardPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.title"));
        this.setDescription(Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.msg"));
        this.setDriverCategory("org.eclipse.datatools.connectivity.db.derby.driverCategory");
        this.combo.setFilter("templateIDStartsWith = org.eclipse.datatools.connectivity.db.derby,templateIDEndsWith = genericDriverTemplate");
    }

    public void createCustomControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        content.setLayout((Layout)layout);
        this.combo.setLabelText(Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.driverCombo.label"));
        this.combo.setCategory(this.getDriverCategory());
        this.combo.setNullDriverIsValid(false);
        this.combo.createContents(content);
        if (this.combo.getErrorMessage() != null) {
            this.setErrorMessage(this.combo.getErrorMessage());
        }
        this.mDatabaseNameText = (Text)this.createLabelTextPair(content, Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.databaseName.label"), (Control)this.mURLText, 2048, 768);
        Label label = new Label(content, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.0"));
        Composite textAndBrowseComposite = new Composite(content, 0);
        GridLayout subCompositeLayout = new GridLayout(2, false);
        subCompositeLayout.marginLeft = -5;
        subCompositeLayout.marginRight = -5;
        subCompositeLayout.marginTop = -5;
        subCompositeLayout.marginBottom = -5;
        textAndBrowseComposite.setLayout((Layout)subCompositeLayout);
        textAndBrowseComposite.setLayoutData((Object)new GridData(768));
        this.mDBFilePathText = new Text(textAndBrowseComposite, 2048);
        this.mDBFilePathText.setLayoutData((Object)new GridData(768));
        this.mBrowseFilePathButton = new Button(textAndBrowseComposite, 8);
        this.mBrowseFilePathButton.setText(Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.1"));
        this.mBrowseFilePathButton.setLayoutData((Object)new GridData(128));
        this.mDBUIDText = (Text)this.createLabelTextPair(content, Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.userName.label"), (Control)this.mDBUIDText, 2048, 768);
        this.mDBPWDText = (Text)this.createLabelTextPair(content, Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.password.label"), (Control)this.mDBPWDText, 0x400800, 768);
        this.mURLText = (Text)this.createLabelTextPair(content, Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.url.label"), (Control)this.mURLText, 2048, 768);
        this.mCreateDBCheckbox = new Button(content, 32);
        this.mCreateDBCheckbox.setText(Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.2"));
        this.mCreateDBCheckbox.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        this.mUpgradeDBCheckbox = new Button(content, 32);
        this.mUpgradeDBCheckbox.setText(Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.3"));
        this.mUpgradeDBCheckbox.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        this.mSaveDBPWDCheckbox = new Button(content, 32);
        this.mSaveDBPWDCheckbox.setText(Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.persistpassword.label"));
        this.mSaveDBPWDCheckbox.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        Composite spacer = new Composite(content, 0);
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        gdata.heightHint = 20;
        spacer.setLayoutData((Object)gdata);
        label = new Label(content, 0);
        gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        label.setLayoutData((Object)gdata);
        label.setText(Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.optionalProps.label"));
        this.mDBConnProps = new DelimitedStringList(content, 0);
        gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        this.mDBConnProps.setLayoutData((Object)gdata);
        this.mDBConnProps.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                DerbyEmbeddedDBProfileDetailsWizardPage.this.setErrorMessage(null);
                if (DerbyEmbeddedDBProfileDetailsWizardPage.this.mDBConnProps.getWarning() != null) {
                    DerbyEmbeddedDBProfileDetailsWizardPage.this.setErrorMessage(DerbyEmbeddedDBProfileDetailsWizardPage.this.mDBConnProps.getWarning());
                }
            }
        });
        this.combo.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                DerbyEmbeddedDBProfileDetailsWizardPage.this.mDriverInstance = DerbyEmbeddedDBProfileDetailsWizardPage.this.combo.getSelectedDriverInstance();
                DerbyEmbeddedDBProfileDetailsWizardPage.this.setErrorMessage(null);
                if (DerbyEmbeddedDBProfileDetailsWizardPage.this.combo.getErrorMessage() != null) {
                    DerbyEmbeddedDBProfileDetailsWizardPage.this.setErrorMessage(DerbyEmbeddedDBProfileDetailsWizardPage.this.combo.getErrorMessage());
                }
                DerbyEmbeddedDBProfileDetailsWizardPage.this.mDatabaseNameText.setText(DerbyEmbeddedDBProfileDetailsWizardPage.this.getDriverDatabaseName());
                DerbyEmbeddedDBProfileDetailsWizardPage.this.mURLText.setText(DerbyEmbeddedDBProfileDetailsWizardPage.this.getDriverURL());
                DerbyEmbeddedDBProfileDetailsWizardPage.this.updatePropsFromURL();
                String username = DerbyEmbeddedDBProfileDetailsWizardPage.this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.username");
                if (username == null || username.trim().length() == 0) {
                    username = new String();
                }
                DerbyEmbeddedDBProfileDetailsWizardPage.this.mDBUIDText.setText(username);
                String password = DerbyEmbeddedDBProfileDetailsWizardPage.this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.password");
                if (password == null || password.trim().length() == 0) {
                    password = new String();
                }
                DerbyEmbeddedDBProfileDetailsWizardPage.this.mDBPWDText.setText(password);
                DerbyEmbeddedDBProfileDetailsWizardPage.this.setPageComplete(DerbyEmbeddedDBProfileDetailsWizardPage.this.isValid());
            }
        });
        this.mDBFilePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DerbyEmbeddedDBProfileDetailsWizardPage.this.updateURLFromProps();
            }
        });
        this.mCreateDBCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DerbyEmbeddedDBProfileDetailsWizardPage.this.updateURLFromProps();
            }

            public void widgetSelected(SelectionEvent e) {
                DerbyEmbeddedDBProfileDetailsWizardPage.this.updateURLFromProps();
            }
        });
        this.mUpgradeDBCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DerbyEmbeddedDBProfileDetailsWizardPage.this.updateURLFromProps();
            }

            public void widgetSelected(SelectionEvent e) {
                DerbyEmbeddedDBProfileDetailsWizardPage.this.updateURLFromProps();
            }
        });
        this.mBrowseFilePathButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DerbyEmbeddedDBProfileDetailsWizardPage.this.browseForDBFolder();
            }

            public void widgetSelected(SelectionEvent e) {
                DerbyEmbeddedDBProfileDetailsWizardPage.this.browseForDBFolder();
            }
        });
        this.combo.selectFirstItem();
        if (this.mDriverInstance == null) {
            this.mDriverInstance = this.combo.getSelectedDriverInstance();
        }
        if (this.mDriverInstance != null) {
            this.mURLText.setText(this.getDriverURL());
        }
        this.mURLText.setEnabled(false);
    }

    private void browseForDBFolder() {
        String selectedDirectory;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText(Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.FileDialog.title.filebrowse"));
        dialog.setMessage(Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.FileDialog.msg.filebrowse"));
        String dirName = this.mDBFilePathText.getText();
        File path = new File(dirName);
        if (path.exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.mDBFilePathText.setText(selectedDirectory);
        }
    }

    private void updatePropsFromURL() {
        if (this.mDBFilePathText != null && this.mURLText != null && this.mCreateDBCheckbox != null && this.mUpgradeDBCheckbox != null) {
            String[] chunks2;
            String url = this.mURLText.getText();
            String[] chunks = this.parseString(url, ";");
            if (chunks.length > 0 && (chunks2 = this.parseString(chunks[0], ":")).length > 2) {
                String filepath = chunks2[2];
                if (chunks2.length > 3) {
                    filepath = filepath + ":" + chunks2[3];
                }
                this.mDBFilePathText.setText(filepath);
            }
            if (chunks.length > 1) {
                for (int i = 1; i < chunks.length; ++i) {
                    if (chunks[i].startsWith("create=")) {
                        this.mCreateDBCheckbox.setSelection(true);
                        continue;
                    }
                    if (!chunks[i].startsWith("upgrade=")) continue;
                    this.mUpgradeDBCheckbox.setSelection(true);
                }
            }
        }
    }

    private void updateURLFromProps() {
        if (this.mDBFilePathText != null && this.mURLText != null && this.mCreateDBCheckbox != null && this.mUpgradeDBCheckbox != null) {
            String[] chunks2;
            String url = this.mURLText.getText();
            String filePath = this.mDBFilePathText.getText();
            boolean createDB = this.mCreateDBCheckbox.getSelection();
            boolean upgradeDB = this.mUpgradeDBCheckbox.getSelection();
            String[] chunks = this.parseString(url, ";");
            if (chunks.length > 0 && (chunks2 = this.parseString(chunks[0], ":")).length > 2) {
                url = chunks2[0] + ":" + chunks2[1] + ":" + filePath;
                if (createDB) {
                    url = url + ";" + "create=true";
                }
                if (upgradeDB) {
                    url = url + ";" + "upgrade=true";
                }
                this.mURLText.setText(url);
            }
        }
    }

    private String[] parseString(String str_list, String token) {
        StringTokenizer tk = new StringTokenizer(str_list, token);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }

    private String getPropertyFromDriverInstance(String propertyID) {
        String returnStr = new String();
        if (this.mDriverInstance != null && this.mDriverInstance.getProperty(propertyID) != null) {
            returnStr = this.mDriverInstance.getProperty(propertyID);
        }
        return returnStr;
    }

    public String getDriverURL() {
        if (this.mDriverInstance != null && this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.URL") != null) {
            return this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.URL");
        }
        return new String();
    }

    public String getDriverDatabaseName() {
        if (this.mDriverInstance != null && this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.databaseName") != null) {
            return this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.databaseName");
        }
        return new String();
    }

    public String getVendor() {
        String vendor = "";
        if (this.mDriverInstance != null) {
            vendor = this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.vendor");
        }
        return vendor;
    }

    public String getVersion() {
        String version = "";
        if (this.mDriverInstance != null) {
            version = this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.version");
        }
        return version;
    }

    public String getDriverClass() {
        String driverClass = "";
        if (this.mDriverInstance != null) {
            driverClass = this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.driverClass");
        }
        return driverClass;
    }

    public String getDBUID() {
        return this.mDBUIDText.getText();
    }

    public String getDBPWD() {
        return this.mDBPWDText.getText();
    }

    public boolean getSaveDBPWD() {
        return this.mSaveDBPWDCheckbox.getSelection();
    }

    public String getDBConnProps() {
        return this.mDBConnProps.getSelection();
    }

    public String getDatabaseName() {
        return this.mDatabaseNameText.getText();
    }

    public String getURL() {
        return this.mURLText.getText();
    }

    public String getDriverID() {
        return this.mDriverInstance.getId();
    }

    private Control createLabelTextPair(Composite parent, String labelText, Control ctl, int style, int gData) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(labelText);
        ctl = new Text(parent, style);
        ctl.setLayoutData((Object)new GridData(gData));
        return ctl;
    }

    public List getSummaryData() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        data.add(new String[]{Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.summary.driverName.label"), this.mDriverInstance.getName()});
        data.add(new String[]{Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.summary.connProps.label"), this.getDBConnProps()});
        data.add(new String[]{Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.summary.userName.label"), this.getDBUID()});
        StringBuffer pwdMask = new StringBuffer();
        if (this.getDBPWD() != null && this.getDBPWD().length() > 0) {
            int count = this.getDBPWD().length();
            for (int i = 0; i < count; ++i) {
                pwdMask = pwdMask.append('*');
            }
        }
        data.add(new String[]{Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.summary.password.label"), pwdMask.toString()});
        data.add(new String[]{Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.summary.url.label"), this.getURL()});
        return data;
    }

    private boolean isValid() {
        if (this.getErrorMessage() != null) {
            this.setPageComplete(false);
            return false;
        }
        return true;
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        this.isValid();
    }

    public String getDriverCategory() {
        return this.mDriverCategory;
    }

    public void setDriverCategory(String driverCategory) {
        this.mDriverCategory = driverCategory;
        if (this.combo != null) {
            this.combo.setCategory(this.mDriverCategory);
        }
    }
}

