/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.symbols;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.IMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.AbstractSymbolSourceProviderFactory;
import org.eclipse.jst.jsf.context.symbol.source.ISymbolSourceProvider;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.designtime.internal.symbols.ResourceBundleMapSourceFactory;
import org.eclipse.jst.jsf.designtime.symbols.FileContextUtil;
import org.eclipse.jst.jsf.designtime.symbols.SymbolUtil;
import org.eclipse.jst.jsf.facesconfig.emf.BaseNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ResourceBundleType;
import org.eclipse.jst.jsf.facesconfig.emf.VarType;

public final class ResourceBundleSymbolSourceProvider
extends AbstractSymbolSourceProviderFactory
implements ISymbolSourceProvider {
    protected final ISymbolSourceProvider create(IProject project) {
        return this;
    }

    public final ISymbol[] getSymbols(IAdaptable context, int symbolScopeMask) {
        if (this.isProvider(context)) {
            ArrayList<ISymbol> symbols = new ArrayList<ISymbol>();
            IFile fileContext = FileContextUtil.deriveIFileFromContext(context);
            IProject project = fileContext.getProject();
            JSFAppConfigManager appconfigMgr = JSFAppConfigManager.getInstance(project);
            List resourceBundles = appconfigMgr.getResourceBundles();
            for (ResourceBundleType resBundle : resourceBundles) {
                String basename = this.getBaseName(resBundle);
                String name = this.getVarName(resBundle);
                if (basename == null || name == null) continue;
                try {
                    symbols.add(this.createSymbolForResourceBundle(project, name, basename));
                }
                catch (JavaModelException e) {
                    JSFCorePlugin.log((Exception)((Object)e), "Error creating base name for: " + basename);
                }
                catch (IOException e) {
                    JSFCorePlugin.log(e, "Error creating base name for: " + basename);
                }
                catch (CoreException e) {
                    JSFCorePlugin.log((Exception)((Object)e), "Error creating base name for: " + basename);
                }
            }
            return symbols.toArray(ISymbol.EMPTY_SYMBOL_ARRAY);
        }
        return ISymbol.EMPTY_SYMBOL_ARRAY;
    }

    private ISymbol createSymbolForResourceBundle(IProject project, String name, String basename) throws JavaModelException, IOException, CoreException {
        Map mapSource = ResourceBundleMapSourceFactory.getResourceBundleMapSource(project, basename);
        IMapTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIMapTypeDescriptor();
        typeDesc.setMapSource(mapSource);
        IComponentSymbol symbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
        symbol.setName(name);
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        symbol.setDetailedDescription("Resource bundle map for bundle <i>" + basename + "</i>");
        return symbol;
    }

    private String getBaseName(ResourceBundleType resBundle) {
        BaseNameType baseNameType = resBundle.getBaseName();
        if (baseNameType != null) {
            return baseNameType.getTextContent();
        }
        return null;
    }

    private String getVarName(ResourceBundleType resBundle) {
        VarType varName = resBundle.getVar();
        if (varName != null) {
            return varName.getTextContent();
        }
        return null;
    }

    public final ISymbol[] getSymbols(String prefix, IAdaptable context, int symbolScopeMask) {
        return SymbolUtil.filterSymbolsByPrefix(this.getSymbols(context, symbolScopeMask), prefix);
    }

    public final boolean isProvider(IAdaptable context) {
        IProject project;
        IFile file = FileContextUtil.deriveIFileFromContext(context);
        if (file != null && (project = file.getProject()) != null && project.isAccessible()) {
            return JSFAppConfigUtils.isValidJSFProject(project, "1.2");
        }
        return false;
    }
}

