/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadataprocessors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IImageDescriptorProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.MetaDataQueryHelper;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.metadataprocessors.IMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataContext;
import org.eclipse.jst.jsf.metadataprocessors.TaglibMetadataContext;

public abstract class AbstractMetaDataEnabledFeature
implements IMetaDataEnabledFeature {
    private MetaDataContext mdContext;
    private IStructuredDocumentContext sdContext;
    private static final List EMPTY_LIST = new ArrayList(0);

    public void setMetaDataContext(MetaDataContext context) {
        this.mdContext = context;
    }

    public MetaDataContext getMetaDataContext() {
        return this.mdContext;
    }

    public void setStructuredDocumentContext(IStructuredDocumentContext context) {
        this.sdContext = context;
    }

    public IStructuredDocumentContext getStructuredDocumentContext() {
        return this.sdContext;
    }

    protected String getTraitValueAsString(String traitName) {
        Trait t = this.getTraitForEntityUsingContext(traitName);
        if (t != null) {
            return TraitValueHelper.getValueAsString((Trait)t);
        }
        return null;
    }

    protected List getTraitValueAsListOfStrings(String traitName) {
        Trait t = this.getTraitForEntityUsingContext(traitName);
        if (t != null) {
            return TraitValueHelper.getValueAsListOfStrings((Trait)t);
        }
        return EMPTY_LIST;
    }

    private Trait getTraitForEntityUsingContext(String traitName) {
        Entity entity = ((TaglibMetadataContext)this.getMetaDataContext()).getEntity();
        return MetaDataQueryHelper.getTrait((Entity)entity, (String)traitName);
    }

    protected String getSmallIcon() {
        return this.getTraitValueAsString("small-icon");
    }

    protected ImageDescriptor getImage() {
        String smallIcon = this.getSmallIcon();
        if (smallIcon == null) {
            return null;
        }
        try {
            Trait t = this.getMetaDataContext().getTrait();
            IMetaDataSourceModelProvider provider = t.getSourceModelProvider();
            IImageDescriptorProvider ip = (IImageDescriptorProvider)provider.getAdapter(IImageDescriptorProvider.class);
            if (ip != null) {
                return ip.getImageDescriptor(smallIcon);
            }
        }
        catch (RuntimeException runtimeException) {}
        return null;
    }
}

