/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.operators;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.common.internal.types.BooleanLiteralType;
import org.eclipse.jst.jsf.common.internal.types.LiteralType;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercer;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercionException;
import org.eclipse.jst.jsf.common.internal.types.TypeTransformer;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.el.operators.BinaryOperator;

abstract class RelationalBinaryOperator
extends BinaryOperator {
    private final String _jsfVersion;

    RelationalBinaryOperator(String jsfVersion) {
        this._jsfVersion = jsfVersion;
    }

    protected abstract boolean doRealOperation(Number var1, Number var2);

    protected abstract boolean doRealOperation(String var1, String var2);

    protected abstract String getOperationName();

    protected ValueType handleNumericComparison(ValueType firstArg, ValueType secondArg, Class numberType) {
        try {
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
            Number firstValue = null;
            if (firstArg instanceof LiteralType) {
                firstValue = ((LiteralType)firstArg).coerceToNumber(numberType);
            }
            Number secondValue = null;
            if (secondArg instanceof LiteralType) {
                secondValue = ((LiteralType)secondArg).coerceToNumber(numberType);
            }
            if (firstValue != null && secondValue != null) {
                boolean result = this.doRealOperation(firstValue, secondValue);
                return result ? BooleanLiteralType.TRUE : BooleanLiteralType.FALSE;
            }
            return new ValueType("Z", 2);
        }
        catch (TypeCoercionException typeCoercionException) {
            return null;
        }
    }

    protected Diagnostic validateNumericComparison(ValueType firstType, ValueType secondType, Class numberType) {
        try {
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstType.getSignature()));
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)secondType.getSignature()));
            Number firstValue = null;
            if (firstType instanceof LiteralType) {
                firstValue = ((LiteralType)firstType).coerceToNumber(numberType);
            }
            Number secondValue = null;
            if (secondType instanceof LiteralType) {
                secondValue = ((LiteralType)secondType).coerceToNumber(numberType);
            }
            if (firstValue != null && secondValue != null) {
                boolean result = this.doRealOperation(firstValue, secondValue);
                return DiagnosticFactory.create_BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME(this.getOperationName(), Boolean.toString(result));
            }
            return Diagnostic.OK_INSTANCE;
        }
        catch (TypeCoercionException typeCoercionException) {
            return DiagnosticFactory.create_BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION(this.getOperationName());
        }
    }

    protected ValueType handleStringComparison(ValueType firstType, ValueType secondType) {
        String firstValue = null;
        if (firstType instanceof LiteralType) {
            firstValue = ((LiteralType)firstType).getLiteralValue();
        }
        String secondValue = null;
        if (secondType instanceof LiteralType) {
            secondValue = ((LiteralType)secondType).getLiteralValue();
        }
        if (firstValue != null && secondValue != null) {
            boolean newValue = this.doRealOperation(firstValue, secondValue);
            return newValue ? BooleanLiteralType.TRUE : BooleanLiteralType.FALSE;
        }
        return new ValueType("Z", 2);
    }

    protected Diagnostic validateStringComparison(ValueType firstType, ValueType secondType) {
        String firstValue = null;
        if (firstType instanceof LiteralType) {
            firstValue = ((LiteralType)firstType).getLiteralValue();
        }
        String secondValue = null;
        if (secondType instanceof LiteralType) {
            secondValue = ((LiteralType)secondType).getLiteralValue();
        }
        if (firstValue != null && secondValue != null) {
            boolean newValue = this.doRealOperation(firstValue, secondValue);
            return DiagnosticFactory.create_BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME(this.getOperationName(), Boolean.toString(newValue));
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected final String getJsfVersion() {
        return this._jsfVersion;
    }

    protected final boolean isPreJSF12() {
        return "1.1".equals(this._jsfVersion) || "1.0".equals(this._jsfVersion);
    }

    protected final boolean isJSF12OrLater() {
        return !this.isPreJSF12();
    }
}

