/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.services.ActionService;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.routineeditor.ProcEditorInput;
import org.eclipse.datatools.sqltools.routineeditor.internal.Messages;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorDocumentProviderFactory;
import org.eclipse.datatools.sqltools.routineeditor.ui.actions.DebugAction;
import org.eclipse.datatools.sqltools.routineeditor.ui.actions.RefreshFromDatabaseAction;
import org.eclipse.datatools.sqltools.routineeditor.ui.actions.RoutineAction;
import org.eclipse.datatools.sqltools.routineeditor.ui.actions.RunAction;
import org.eclipse.datatools.sqltools.routineeditor.ui.actions.SaveToDatabaseAction;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStorageEditorInput;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class RoutineEditor
extends SQLEditor {
    public static final String EDITOR_ID = "org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditor";
    protected ProfileStatusChecker _profileChecker = new ProfileStatusChecker();
    private Action _saveToDBAction = null;
    private Action _refreshAction = null;

    public RoutineEditor() {
        this.setDocumentProvider(RoutineEditorDocumentProviderFactory.getDocumentProvider(null));
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.getSite().getPage().addPartListener((IPartListener2)this._profileChecker);
    }

    protected void initializeEditor() {
        super.initializeEditor();
    }

    protected void createActions() {
        super.createActions();
        IActionBars bars = ((IEditorSite)this.getSite()).getActionBars();
        RoutineAction a = new RunAction(this);
        this.setAction("org.eclipse.datatools.sqltools.sqleditor.runAction", (IAction)a);
        bars.setGlobalActionHandler("org.eclipse.datatools.sqltools.sqleditor.runAction", (IAction)a);
        a = new DebugAction(this);
        this.setAction("org.eclipse.datatools.sqltools.sqleditor.debugAction", (IAction)a);
        bars.setGlobalActionHandler("org.eclipse.datatools.sqltools.sqleditor.debugAction", (IAction)a);
        this._saveToDBAction = new SaveToDatabaseAction(this.getConstructedResourceBundle(), "SQLEditor.action.savetodb.", (ITextEditor)this);
        this.setAction("org.eclipse.datatools.sqltools.sqleditor.saveToDatabaseAction", (IAction)this._saveToDBAction);
        bars.setGlobalActionHandler("org.eclipse.datatools.sqltools.sqleditor.saveToDatabaseAction", (IAction)this._saveToDBAction);
        this.markAsContentDependentAction("org.eclipse.datatools.sqltools.sqleditor.saveToDatabaseAction", true);
        this._refreshAction = new RefreshFromDatabaseAction(this.getConstructedResourceBundle(), "SQLEditor.action.refresh.", (ITextEditor)this);
        this.setAction("org.eclipse.datatools.sqltools.sqleditor.refreshFromDatabaseAction", (IAction)this._refreshAction);
        bars.setGlobalActionHandler("org.eclipse.datatools.sqltools.sqleditor.refreshFromDatabaseAction", (IAction)this._refreshAction);
        this.markAsContentDependentAction("org.eclipse.datatools.sqltools.sqleditor.refreshFromDatabaseAction", true);
    }

    protected void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator());
        menu.remove("org.eclipse.datatools.sqltools.sqleditor.ExecuteSQLAction");
        SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)this.getConnectionInfo().getDatabaseVendorDefinitionId());
        ActionService actionService = config.getActionService();
        if (actionService.supportsAction("org.eclipse.datatools.sqltools.sqleditor.runAction")) {
            this.addAction(menu, "group.sqleditor.execute", "org.eclipse.datatools.sqltools.sqleditor.runAction");
        }
        if (actionService.supportsAction("org.eclipse.datatools.sqltools.sqleditor.debugAction")) {
            this.addAction(menu, "group.sqleditor.execute", "org.eclipse.datatools.sqltools.sqleditor.debugAction");
        }
        this.addAction(menu, "group.undo", "org.eclipse.datatools.sqltools.sqleditor.refreshFromDatabaseAction");
        this.addAction(menu, "group.sqleditor.save", "org.eclipse.datatools.sqltools.sqleditor.saveToDatabaseAction");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave(IProgressMonitor monitor) {
        try {
            if (this.getEditorInput() instanceof ProcEditorInput) {
                if (!this.isConnected()) {
                    this.doSaveAs();
                } else {
                    super.doSave(monitor);
                }
            }
        }
        finally {
            if (!monitor.isCanceled()) {
                monitor.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSaveAs() {
        ISQLEditorConnectionInfo connInfo = this.getConnectionInfo();
        Shell shell = this.getSite().getShell();
        IProgressMonitor progressMonitor = this.getProgressMonitor();
        IEditorInput input = this.getEditorInput();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        if (input instanceof SQLEditorStorageEditorInput) {
            dialog.setOriginalName(((SQLEditorStorageEditorInput)input).getName() + ".sql");
        }
        dialog.create();
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            return;
        }
        if (dialog.open() == 1) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return;
        }
        IPath filePath = dialog.getResult();
        if (filePath == null) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return;
        }
        boolean success = false;
        IDocumentProvider newProvider = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile(filePath);
        FileEditorInput newInput = new FileEditorInput(file);
        try {
            IWorkbenchPage page = SQLEditorPlugin.getActiveWorkbenchPage();
            SQLEditor editor = (SQLEditor)page.openEditor((IEditorInput)newInput, "org.eclipse.datatools.sqltools.sqlscrapbook.SQLScrapbookEditor");
            newProvider = editor.getDocumentProvider();
            newProvider.aboutToChange((Object)newInput);
            IDocument newDoc = newProvider.getDocument((Object)newInput);
            newDoc.set(provider.getDocument((Object)input).get());
            newProvider.saveDocument(progressMonitor, (Object)newInput, newDoc, true);
            editor.setConnectionInfo(connInfo);
            this.close(false);
            success = true;
        }
        catch (CoreException x) {
            IStatus status = x.getStatus();
            if (status == null || status.getSeverity() != 8) {
                String title = Messages.Editor_error_save_title;
                String msg = NLS.bind((String)Messages.Editor_error_save_message, (Object[])new Object[]{x.getMessage()});
                if (status != null) {
                    switch (status.getSeverity()) {
                        case 1: {
                            MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                        case 2: {
                            MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                        default: {
                            MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                    }
                } else {
                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                }
            }
        }
        catch (Exception x) {
            String title = Messages.Editor_error_save_title;
            String msg = NLS.bind((String)Messages.Editor_error_save_message, (Object[])new Object[]{x.getMessage()});
            MessageDialog.openError((Shell)shell, (String)title, (String)msg);
        }
        finally {
            newProvider.changed((Object)newInput);
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    public int getSQLType() {
        int sqlType = 100;
        if (this.getEditorInput() instanceof ProcEditorInput) {
            int procType = ((ProcEditorInput)this.getEditorInput()).getProcIdentifier().getType();
            switch (procType) {
                case 0: {
                    sqlType = 58;
                    break;
                }
                case 1: {
                    sqlType = 59;
                    break;
                }
                case 2: {
                    sqlType = 60;
                    break;
                }
                case 3: {
                    sqlType = 61;
                }
            }
        }
        return sqlType;
    }

    public void dispose() {
        try {
            DatabaseIdentifier databaseIdentifier = this.getDatabaseIdentifier();
            if (EditorCorePlugin.getControlConnectionManager().getControlConnection(databaseIdentifier) != null) {
                IControlConnection controlCon = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(databaseIdentifier);
                controlCon.refresh(this.getCurrProcIdentifier());
            }
        }
        catch (Exception ex) {
            RoutineEditorActivator.getDefault().log(ex);
        }
        super.dispose();
        this.getSite().getPage().removePartListener((IPartListener2)this._profileChecker);
    }

    public ResourceBundle getConstructedResourceBundle() {
        return org.eclipse.datatools.sqltools.routineeditor.ui.actions.Messages.getResourceBundle();
    }

    public ProcIdentifier getCurrProcIdentifier() {
        IEditorInput input = this.getEditorInput();
        ProcIdentifier currProc = null;
        if (input instanceof ProcEditorInput) {
            currProc = ((ProcEditorInput)input).getProcIdentifier();
        }
        return currProc;
    }

    public void setConnectionInfo(ISQLEditorConnectionInfo connInfo) {
        super.setConnectionInfo(connInfo);
        ProcIdentifier proc = this.getCurrProcIdentifier();
        if (proc != null) {
            proc.getDatabaseIdentifier().setProfileName(connInfo.getConnectionProfileName());
            this.setTitleToolTip(this.getTitleToolTip());
        }
    }

    private class ProfileStatusChecker
    implements IPartListener2 {
        private ProfileStatusChecker() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            switch (RoutineEditor.this.getConnectionInfo().getProfileStatus()) {
                case 1: {
                    RoutineEditor.this.getConnectionInfo().setConnectionProfileName(null);
                }
                case 2: 
                case 4: {
                    RoutineEditor.this.getConnectionInfo().setProfileStatus(0);
                    RoutineEditor.this.refreshActionStatus();
                    RoutineEditor.this.refreshConnectionStatus();
                    if (RoutineEditor.this.isDirty()) {
                        String msg = Messages.SQLEditor_profile_disconnected;
                        this.forceSaveAs(msg);
                        break;
                    }
                    RoutineEditor.this.close(false);
                    break;
                }
            }
        }

        private void forceSaveAs(String message) {
            if (MessageDialog.openConfirm((Shell)RoutineEditor.this.getSite().getShell(), (String)Messages.SQLEditor_profile_information, (String)message)) {
                RoutineEditor.this.doSaveAs();
                if (RoutineEditor.this.getEditorInput() instanceof ProcEditorInput) {
                    RoutineEditor.this.close(false);
                }
            } else {
                RoutineEditor.this.close(false);
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    }
}

