/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public class FacesConfigUtil {
    public static final String FACES_CONFIG_CONTENT_TYPE_ID = "org.eclipse.jst.jsf.facesconfig.facesConfigFile";

    public static boolean isFacesConfigFile(IFile file) {
        return FacesConfigUtil.isFacesConfigFile(file, true);
    }

    public static boolean isFacesConfigFile(IFile file, boolean ignoreNonFacesProject) {
        if (!"xml".equalsIgnoreCase(file.getFileExtension())) {
            return false;
        }
        IProject project = file.getProject();
        if (project == null) {
            return false;
        }
        try {
            IContentType contentType;
            IContentDescription contentDescription = file.getContentDescription();
            if (contentDescription != null && (contentType = contentDescription.getContentType()) != null) {
                return FACES_CONFIG_CONTENT_TYPE_ID.equals(contentType.getId());
            }
        }
        catch (CoreException coreException) {}
        return false;
    }
}

