/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.project;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.emf.workbench.WorkbenchByteArrayOutputStream;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.util.plugin.JEMUtilPlugin;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.archive.operations.JavaComponentLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.componentcore.AppClientBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.componentcore.EJBBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.componentcore.JCABinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.componentcore.WebBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.moduleextension.EarModuleManager;
import org.eclipse.jst.j2ee.internal.project.ManifestFileCreationAction;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.j2ee.project.facet.JavaProjectMigrationDataModelProvider;
import org.eclipse.jst.j2ee.project.facet.JavaProjectMigrationOperation;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.SimpleValidateEdit;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class J2EEProjectUtilities
extends ProjectUtilities
implements IJ2EEFacetConstants {
    private static final IVirtualReference[] NO_REFERENCES = new IVirtualReference[0];

    public static IPath getRuntimeLocation(IProject aProject) {
        if (JemProjectUtilities.isBinaryProject((IProject)aProject)) {
            return J2EEProjectUtilities.getBinaryProjectJARLocation(aProject);
        }
        return JemProjectUtilities.getJavaProjectOutputAbsoluteLocation((IProject)aProject);
    }

    public static IPath getBinaryProjectJARLocation(IProject aProject) {
        List sources = JemProjectUtilities.getLocalJARPathsFromClasspath((IProject)aProject);
        if (!sources.isEmpty()) {
            IPath path = (IPath)sources.get(0);
            return aProject.getFile(path).getLocation();
        }
        return null;
    }

    public static Archive getClientJAR(EJBJarFile file, EARFile earFile) {
        EJBJar jar = null;
        try {
            jar = file.getDeploymentDescriptor();
        }
        catch (DeploymentDescriptorLoadException deploymentDescriptorLoadException) {
            return null;
        }
        if (jar == null) {
            return null;
        }
        String clientJAR = jar.getEjbClientJar();
        if (clientJAR == null || clientJAR.length() == 0) {
            return null;
        }
        String normalized = ArchiveUtil.deriveEARRelativeURI((String)clientJAR, (String)file.getURI());
        if (normalized != null) {
            try {
                File aFile = earFile.getFile(normalized);
                if (aFile.isArchive() && !aFile.isModuleFile()) {
                    return (Archive)aFile;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void appendJavaClassPath(IProject p, IClasspathEntry newEntry) throws JavaModelException {
        IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)p);
        if (javaProject == null) {
            return;
        }
        IClasspathEntry[] classpath = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> newPathList = new ArrayList<IClasspathEntry>(classpath.length);
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            if (Platform.getOS().equals("win32")) {
                if (entry.getPath().toString().equalsIgnoreCase(newEntry.getPath().toString())) return;
                newPathList.add(entry);
            } else {
                if (entry.getPath().equals((Object)newEntry.getPath())) return;
                newPathList.add(entry);
            }
            ++i;
        }
        newPathList.add(newEntry);
        IClasspathEntry[] newClasspath = newPathList.toArray(new IClasspathEntry[newPathList.size()]);
        javaProject.setRawClasspath(newClasspath, (IProgressMonitor)new NullProgressMonitor());
    }

    public static Archive asArchiveFromBinary(String jarUri, IProject aProject) throws OpenFailureException {
        IPath path = J2EEProjectUtilities.getBinaryProjectJARLocation(aProject);
        if (path != null) {
            String location = path.toOSString();
            Archive anArchive = CommonarchiveFactoryImpl.getActiveFactory().primOpenArchive(location);
            anArchive.setURI(jarUri);
            return anArchive;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArchiveManifest readManifest(IFile aFile) {
        in = null;
        try {
            if (aFile == null || !aFile.exists()) {
            }
            ** GOTO lbl-1000
        }
        catch (Exception ex) {
            try {
                Logger.getLogger().logError((Throwable)ex);
            }
            catch (Throwable var3_4) {
                if (in == null) throw var3_4;
                try {
                    in.close();
                    throw var3_4;
                }
                catch (IOException v0) {}
                throw var3_4;
            }
        }
        if (in == null) return null;
        try {
            in.close();
            return null;
        }
        catch (IOException v1) {}
        return null;
lbl-1000:
        // 1 sources

        {
            in = aFile.getContents();
            var4_2 = new ArchiveManifestImpl(in);
            if (in == null) return var4_2;
        }
        try {
            in.close();
            return var4_2;
        }
        catch (IOException v2) {}
        return var4_2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArchiveManifest readManifest(IProject p) {
        in = null;
        try {
            aFile = J2EEProjectUtilities.getManifestFile(p);
            if (aFile == null || !aFile.exists()) {
            }
            ** GOTO lbl-1000
        }
        catch (Exception ex) {
            try {
                Logger.getLogger().logError((Throwable)ex);
            }
            catch (Throwable var3_5) {
                if (in == null) throw var3_5;
                try {
                    in.close();
                    throw var3_5;
                }
                catch (IOException v0) {}
                throw var3_5;
            }
        }
        if (in == null) return null;
        try {
            in.close();
            return null;
        }
        catch (IOException v1) {}
        return null;
lbl-1000:
        // 1 sources

        {
            in = aFile.getContents();
            var4_4 = new ArchiveManifestImpl(in);
            if (in == null) return var4_4;
        }
        try {
            in.close();
            return var4_4;
        }
        catch (IOException v2) {}
        return var4_4;
    }

    public static IFile getManifestFile(IProject project) {
        return J2EEProjectUtilities.getManifestFile(project, true);
    }

    public static IFile getManifestFile(IProject p, boolean createIfNecessary) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)p);
        try {
            IFile file = ComponentUtilities.findFile((IVirtualComponent)component, (IPath)new Path("META-INF/MANIFEST.MF"));
            if (createIfNecessary && file == null) {
                IVirtualFolder virtualFolder = component.getRootFolder();
                file = virtualFolder.getUnderlyingFolder().getFile((IPath)new Path("META-INF/MANIFEST.MF"));
                try {
                    ManifestFileCreationAction.createManifestFile(file, p);
                }
                catch (CoreException e) {
                    Logger.getLogger().log((Throwable)e);
                }
                catch (IOException e) {
                    Logger.getLogger().log((Throwable)e);
                }
            }
            return file;
        }
        catch (CoreException ce) {
            Logger.getLogger().log((Throwable)ce);
            return null;
        }
    }

    public static void writeManifest(IProject aProject, ArchiveManifest manifest) throws IOException {
        J2EEProjectUtilities.writeManifest(aProject, J2EEProjectUtilities.getManifestFile(aProject), manifest);
    }

    public static void writeManifest(IFile aFile, ArchiveManifest manifest) throws IOException {
        J2EEProjectUtilities.writeManifest(aFile.getProject(), aFile, manifest);
    }

    private static void writeManifest(IProject aProject, IFile aFile, ArchiveManifest manifest) throws IOException {
        if (aFile != null && SimpleValidateEdit.validateEdit((IFile[])new IFile[]{aFile})) {
            WorkbenchByteArrayOutputStream out = new WorkbenchByteArrayOutputStream(aFile);
            manifest.writeSplittingClasspath((OutputStream)out);
            out.close();
            J2EEComponentClasspathUpdater.getInstance().queueUpdateModule(aProject);
        }
    }

    public static Map collectEJBClientJARs(EARFile earFile) {
        if (earFile == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<EJBJarFile, Archive> ejbClientJARs = null;
        List ejbJARFiles = earFile.getEJBJarFiles();
        Archive clientJAR = null;
        int i = 0;
        while (i < ejbJARFiles.size()) {
            EJBJarFile ejbJarFile = (EJBJarFile)ejbJARFiles.get(i);
            clientJAR = J2EEProjectUtilities.getClientJAR(ejbJarFile, earFile);
            if (clientJAR != null) {
                if (ejbClientJARs == null) {
                    ejbClientJARs = new HashMap<EJBJarFile, Archive>();
                }
                ejbClientJARs.put(ejbJarFile, clientJAR);
            }
            ++i;
        }
        return ejbClientJARs == null ? Collections.EMPTY_MAP : ejbClientJARs;
    }

    public static String computeRelativeText(String referencingURI, String referencedURI, EnterpriseBean bean) {
        if (bean == null) {
            return null;
        }
        String beanName = bean.getName();
        if (beanName == null) {
            return null;
        }
        String relativeUri = J2EEProjectUtilities.computeRelativeText(referencingURI, referencedURI);
        if (relativeUri == null) {
            return beanName;
        }
        return String.valueOf(relativeUri) + "#" + beanName;
    }

    public static String computeRelativeText(String referencingURI, String referencedURI) {
        if (referencingURI == null || referencedURI == null) {
            return null;
        }
        Path pPre = new Path(referencingURI);
        Path pDep = new Path(referencedURI);
        if (pPre.getDevice() != null || pDep.getDevice() != null) {
            return null;
        }
        pPre = pPre.makeRelative();
        pDep = pDep.makeRelative();
        while (pPre.segmentCount() > 1 && pDep.segmentCount() > 1 && pPre.segment(0).equals(pDep.segment(0))) {
            pPre = pPre.removeFirstSegments(1);
            pDep = pDep.removeFirstSegments(1);
        }
        Object result = null;
        StringBuffer buf = new StringBuffer();
        String segment = null;
        do {
            segment = pDep.lastSegment();
            pPre = pPre.removeLastSegments(1);
            pDep = pDep.removeLastSegments(1);
            if (segment != null) {
                result = result == null ? new Path(segment) : new Path(segment).append((IPath)result);
            }
            if (pPre.equals((Object)pDep) || pPre.isEmpty()) continue;
            buf.append("../");
        } while (!pPre.equals((Object)pDep));
        if (result != null) {
            buf.append(result.makeRelative().toString());
        }
        return buf.toString();
    }

    public static IProject getEJBProjectFromEJBClientProject(IProject ejbClientProject) {
        try {
            if (ejbClientProject != null && ejbClientProject.hasNature("org.eclipse.jdt.core.javanature")) {
                IProject[] allProjects = J2EEProjectUtilities.getAllProjects();
                int i = 0;
                while (i < allProjects.length) {
                    if (EarModuleManager.getEJBModuleExtension().getEJBJar(allProjects[i]) != null && ejbClientProject == EarModuleManager.getEJBModuleExtension().getDefinedEJBClientJARProject(allProjects[i])) {
                        return allProjects[i];
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static EnterpriseBean getEnterpriseBean(ICompilationUnit cu) {
        IProject proj = cu.getJavaProject().getProject();
        EJBJar jar = EarModuleManager.getEJBModuleExtension().getEJBJar(proj);
        if (jar == null) {
            jar = EarModuleManager.getEJBModuleExtension().getEJBJar(J2EEProjectUtilities.getEJBProjectFromEJBClientProject(proj));
        }
        if (jar != null) {
            int index = cu.getElementName().indexOf(46);
            String className = cu.getElementName();
            if (index > 0) {
                className = className.substring(0, index);
            }
            JavaClass javaClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(cu.getParent().getElementName(), className, jar.eResource().getResourceSet());
            return jar.getEnterpriseBeanWithReference(javaClass);
        }
        return null;
    }

    public static IContainer getSourceFolderOrFirst(IProject p, String defaultSourceName) {
        IPath sourcePath;
        block4: {
            try {
                sourcePath = J2EEProjectUtilities.getSourcePathOrFirst(p, defaultSourceName);
                if (sourcePath != null) break block4;
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        if (sourcePath.isEmpty()) {
            return p;
        }
        return p.getFolder(sourcePath);
    }

    public static void removeBuilders(IProject project, List builderids) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] oldSpec = desc.getBuildSpec();
        int oldLength = oldSpec.length;
        if (oldLength == 0) {
            return;
        }
        int remaining = 0;
        int i = 0;
        while (i < oldSpec.length) {
            if (builderids.contains(oldSpec[i].getBuilderName())) {
                oldSpec[i] = null;
            } else {
                ++remaining;
            }
            ++i;
        }
        if (remaining == oldSpec.length) {
            return;
        }
        ICommand[] newSpec = new ICommand[remaining];
        int i2 = 0;
        int newIndex = 0;
        while (i2 < oldLength) {
            if (oldSpec[i2] != null) {
                newSpec[newIndex++] = oldSpec[i2];
            }
            ++i2;
        }
        desc.setBuildSpec(newSpec);
        project.setDescription(desc, 0, null);
    }

    public static IPath getSourcePathOrFirst(IProject p, String defaultSourceName) {
        IJavaProject javaProj = JemProjectUtilities.getJavaProject((IProject)p);
        if (javaProj == null) {
            return null;
        }
        IClasspathEntry[] cp = null;
        try {
            cp = javaProj.getRawClasspath();
        }
        catch (JavaModelException ex) {
            JEMUtilPlugin.getLogger().logError((Throwable)ex);
            return null;
        }
        IClasspathEntry firstSource = null;
        IPath defaultSourcePath = null;
        if (defaultSourceName != null) {
            defaultSourcePath = J2EEProjectUtilities.createPath((IProject)p, (String)defaultSourceName);
        }
        boolean found = false;
        int i = 0;
        while (i < cp.length) {
            IPath sourceFolderPath;
            IFolder sourceFolder;
            if (cp[i].getEntryKind() == 3 && J2EEProjectUtilities.isSourceFolderAnInputContainer(sourceFolder = p.getFolder(sourceFolderPath = cp[i].getPath().removeFirstSegments(1)))) {
                found = true;
                if (firstSource == null) {
                    firstSource = cp[i];
                    if (defaultSourcePath == null) break;
                }
                if (cp[i].getPath().equals((Object)defaultSourcePath)) {
                    return defaultSourcePath.removeFirstSegments(1);
                }
            }
            ++i;
        }
        if (!found) {
            i = 0;
            while (i < cp.length) {
                if (cp[i].getEntryKind() == 3) {
                    if (firstSource == null) {
                        firstSource = cp[i];
                        if (defaultSourcePath == null) break;
                    }
                    if (cp[i].getPath().equals((Object)defaultSourcePath)) {
                        return defaultSourcePath.removeFirstSegments(1);
                    }
                }
                ++i;
            }
        }
        if (firstSource == null) {
            return null;
        }
        if (firstSource.getPath().segment(0).equals(p.getName())) {
            return firstSource.getPath().removeFirstSegments(1);
        }
        return null;
    }

    public static boolean isSourceFolderAnInputContainer(IFolder sourceFolder) {
        IProject project;
        block8: {
            IFolder parent = sourceFolder;
            do {
                if ((parent = parent.getParent()) != null) continue;
                return false;
            } while (!(parent instanceof IProject));
            project = (IProject)parent;
            if (project.isAccessible()) break block8;
            return false;
        }
        try {
            if (J2EEProjectUtilities.isEJBProject(project)) {
                return sourceFolder.findMember("META-INF/ejb-jar.xml") != null;
            }
            if (J2EEProjectUtilities.isApplicationClientProject(project)) {
                return sourceFolder.findMember("META-INF/application-client.xml") != null;
            }
            if (J2EEProjectUtilities.isDynamicWebProject(project)) {
                return sourceFolder.findMember("WEB-INF/web.xml") != null;
            }
            if (J2EEProjectUtilities.isJCAProject(project)) {
                return sourceFolder.findMember("META-INF/ra.xml") != null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static Archive asArchive(String jarUri, IProject project, boolean exportSource) throws OpenFailureException {
        return J2EEProjectUtilities.asArchive(jarUri, project, exportSource, true);
    }

    public static Archive asArchive(String jarUri, IProject project, boolean exportSource, boolean includeClasspathComponents) throws OpenFailureException {
        JavaComponentLoadStrategyImpl strat = new JavaComponentLoadStrategyImpl(ComponentCore.createComponent((IProject)project), includeClasspathComponents);
        strat.setExportSource(exportSource);
        return CommonarchiveFactoryImpl.getActiveFactory().primOpenArchive((LoadStrategy)strat, jarUri);
    }

    public static boolean isProjectOfType(IProject project, String typeID) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return false;
        }
        if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)typeID)) {
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)typeID);
            return projectFacet != null && facetedProject.hasProjectFacet(projectFacet);
        }
        return false;
    }

    private static boolean isProjectOfType(IFacetedProject facetedProject, String typeID) {
        if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)typeID)) {
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)typeID);
            return projectFacet != null && facetedProject.hasProjectFacet(projectFacet);
        }
        return false;
    }

    private static boolean isEARProject(IFacetedProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, "jst.ear");
    }

    private static boolean isDynamicWebProject(IFacetedProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, "jst.web");
    }

    private static boolean isStaticWebProject(IFacetedProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, "wst.web");
    }

    private static boolean isEJBProject(IFacetedProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, "jst.ejb");
    }

    private static boolean isJCAProject(IFacetedProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, "jst.connector");
    }

    private static boolean isApplicationClientProject(IFacetedProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, "jst.appclient");
    }

    private static boolean isUtilityProject(IFacetedProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, "jst.utility");
    }

    public static boolean isEARProject(IProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, "jst.ear");
    }

    public static boolean isDynamicWebComponent(IVirtualComponent component) {
        if (component.isBinary()) {
            return WebBinaryComponentHelper.handlesComponent(component);
        }
        return J2EEProjectUtilities.isProjectOfType(component.getProject(), "jst.web");
    }

    public static boolean isDynamicWebProject(IProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, "jst.web");
    }

    public static boolean isStaticWebProject(IProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, "wst.web");
    }

    public static boolean isEJBComponent(IVirtualComponent component) {
        if (component.isBinary()) {
            return EJBBinaryComponentHelper.handlesComponent(component);
        }
        return J2EEProjectUtilities.isProjectOfType(component.getProject(), "jst.ejb");
    }

    public static boolean isEJBProject(IProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, "jst.ejb");
    }

    public static boolean isJCAComponent(IVirtualComponent component) {
        if (component.isBinary()) {
            return JCABinaryComponentHelper.handlesComponent(component);
        }
        return J2EEProjectUtilities.isProjectOfType(component.getProject(), "jst.connector");
    }

    public static boolean isJCAProject(IProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, "jst.connector");
    }

    public static boolean isApplicationClientComponent(IVirtualComponent component) {
        if (component.isBinary()) {
            return AppClientBinaryComponentHelper.handlesComponent(component);
        }
        return J2EEProjectUtilities.isProjectOfType(component.getProject(), "jst.appclient");
    }

    public static boolean isApplicationClientProject(IProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, "jst.appclient");
    }

    public static boolean isUtilityProject(IProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, "jst.utility");
    }

    public static boolean isStandaloneProject(IProject project) {
        return J2EEProjectUtilities.getReferencingEARProjects(project).length == 0;
    }

    public static IProject[] getReferencingEARProjects(IProject project) {
        if (project != null && J2EEProjectUtilities.isEARProject(project)) {
            return new IProject[]{project};
        }
        ArrayList<IProject> result = new ArrayList<IProject>();
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            IVirtualComponent[] refComponents = component.getReferencingComponents();
            int i = 0;
            while (i < refComponents.length) {
                if (J2EEProjectUtilities.isEARProject(refComponents[i].getProject())) {
                    result.add(refComponents[i].getProject());
                }
                ++i;
            }
        }
        return result.toArray(new IProject[result.size()]);
    }

    public static IProject[] getAllProjectsInWorkspaceOfType(String type) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> result = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            if (J2EEProjectUtilities.isProjectOfType(projects[i], type)) {
                result.add(projects[i]);
            }
            ++i;
        }
        return result.toArray(new IProject[result.size()]);
    }

    public static String getJ2EEComponentType(IVirtualComponent component) {
        if (component != null) {
            if (component.isBinary()) {
                if (J2EEProjectUtilities.isApplicationClientComponent(component)) {
                    return "jst.appclient";
                }
                if (J2EEProjectUtilities.isDynamicWebComponent(component)) {
                    return "jst.web";
                }
                if (J2EEProjectUtilities.isEJBComponent(component)) {
                    return "jst.ejb";
                }
                if (J2EEProjectUtilities.isJCAComponent(component)) {
                    return "jst.connector";
                }
                return "jst.utility";
            }
            return J2EEProjectUtilities.getJ2EEProjectType(component.getProject());
        }
        return "";
    }

    public static String getJ2EEProjectType(IProject project) {
        if (project != null && project.isAccessible()) {
            IFacetedProject facetedProject = null;
            try {
                facetedProject = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException coreException) {
                return "";
            }
            if (J2EEProjectUtilities.isApplicationClientProject(facetedProject)) {
                return "jst.appclient";
            }
            if (J2EEProjectUtilities.isDynamicWebProject(facetedProject)) {
                return "jst.web";
            }
            if (J2EEProjectUtilities.isEJBProject(facetedProject)) {
                return "jst.ejb";
            }
            if (J2EEProjectUtilities.isEARProject(facetedProject)) {
                return "jst.ear";
            }
            if (J2EEProjectUtilities.isJCAProject(facetedProject)) {
                return "jst.connector";
            }
            if (J2EEProjectUtilities.isStaticWebProject(facetedProject)) {
                return "wst.web";
            }
            if (J2EEProjectUtilities.isUtilityProject(facetedProject)) {
                return "jst.utility";
            }
        }
        return "";
    }

    public static IRuntime getServerRuntime(IProject project) throws CoreException {
        if (project == null) {
            return null;
        }
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        if (facetedProject == null) {
            return null;
        }
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = facetedProject.getRuntime();
        if (runtime == null) {
            return null;
        }
        return FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime);
    }

    public static String getJ2EEProjectVersion(IProject project) {
        String type = J2EEProjectUtilities.getJ2EEProjectType(project);
        IFacetedProject facetedProject = null;
        IProjectFacet facet = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
            facet = ProjectFacetsManager.getProjectFacet((String)type);
        }
        catch (Exception exception) {}
        if (facet != null && facetedProject.hasProjectFacet(facet)) {
            return facetedProject.getInstalledVersion(facet).getVersionString();
        }
        return null;
    }

    public static JavaProjectMigrationOperation createFlexJavaProjectForProjectOperation(IProject project) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new JavaProjectMigrationDataModelProvider());
        model.setProperty("IJavaProjectMigrationDataModelProperties.PROJECT_NAME", (Object)project.getName());
        return new JavaProjectMigrationOperation(model);
    }

    public static IPackageFragmentRoot[] getSourceContainers(IProject project) {
        IJavaProject jProject = JemProjectUtilities.getJavaProject((IProject)project);
        if (jProject == null) {
            return new IPackageFragmentRoot[0];
        }
        ArrayList<IPackageFragmentRoot> list = new ArrayList<IPackageFragmentRoot>();
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        try {
            IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IResource resource;
                if (roots[i].getKind() == 1 && (resource = roots[i].getResource()) != null) {
                    IVirtualResource[] vResources = ComponentCore.createResources((IResource)resource);
                    boolean found = false;
                    int j = 0;
                    while (!found && j < vResources.length) {
                        if (vResources[j].getComponent().equals(vc)) {
                            if (!list.contains(roots[i])) {
                                list.add(roots[i]);
                            }
                            found = true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        return list.toArray(new IPackageFragmentRoot[list.size()]);
    }

    public static IContainer[] getOutputContainers(IProject project) {
        ArrayList<IContainer> result = new ArrayList<IContainer>();
        try {
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                return new IContainer[0];
            }
        }
        catch (Exception exception) {}
        IPackageFragmentRoot[] sourceContainers = J2EEProjectUtilities.getSourceContainers(project);
        int i = 0;
        while (i < sourceContainers.length) {
            IContainer outputFolder = J2EEProjectUtilities.getOutputContainer(project, sourceContainers[i]);
            if (outputFolder != null && !result.contains(outputFolder)) {
                result.add(outputFolder);
            }
            ++i;
        }
        return result.toArray(new IContainer[result.size()]);
    }

    public static IContainer getOutputContainer(IProject project, IPackageFragmentRoot sourceContainer) {
        try {
            IJavaProject jProject = JavaCore.create((IProject)project);
            IPath outputPath = sourceContainer.getRawClasspathEntry().getOutputLocation();
            if (outputPath == null) {
                if (jProject.getOutputLocation().segmentCount() == 1) {
                    return project;
                }
                return project.getFolder(jProject.getOutputLocation().removeFirstSegments(1));
            }
            return project.getFolder(outputPath.removeFirstSegments(1));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IPath getResolvedPathForArchiveComponent(String name) {
        URI uri = URI.createURI((String)name);
        String resourceType = uri.segment(0);
        URI contenturi = ModuleURIUtil.trimToRelativePath((URI)uri, (int)1);
        String contentName = contenturi.toString();
        if (resourceType.equals("lib")) {
            return Path.fromOSString((String)contentName);
        }
        if (resourceType.equals("var")) {
            String classpathVar = contenturi.segment(0);
            URI remainingPathuri = ModuleURIUtil.trimToRelativePath((URI)contenturi, (int)1);
            String remainingPath = remainingPathuri.toString();
            String[] classpathvars = JavaCore.getClasspathVariableNames();
            boolean found = false;
            int i = 0;
            while (i < classpathvars.length) {
                if (classpathVar.equals(classpathvars[i])) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) {
                IPath path = JavaCore.getClasspathVariable((String)classpathVar);
                URI finaluri = URI.createURI((String)(String.valueOf(path.toOSString()) + '/' + remainingPath));
                return Path.fromOSString((String)finaluri.toString());
            }
        }
        return null;
    }

    public static List getAllJavaNonFlexProjects() throws CoreException {
        ArrayList<IProject> nonFlexJavaProjects = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isAccessible() && projects[i].hasNature("org.eclipse.jdt.core.javanature") && !projects[i].hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
                nonFlexJavaProjects.add(projects[i]);
            }
            ++i;
        }
        return nonFlexJavaProjects;
    }

    public static String getServerContextRoot(IProject project) {
        return ComponentUtilities.getServerContextRoot((IProject)project);
    }

    public static void setServerContextRoot(IProject project, String contextRoot) {
        ComponentUtilities.setServerContextRoot((IProject)project, (String)contextRoot);
    }

    public static boolean isJEEProject(IProject project) {
        IFacetedProject facetedProject;
        boolean ret;
        block10: {
            ret = false;
            facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject != null) break block10;
            return false;
        }
        try {
            if (J2EEProjectUtilities.isEARProject(facetedProject)) {
                IProjectFacet earFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
                ret = facetedProject.hasProjectFacet(earFacet.getVersion(J2EEVersionUtil.convertVersionIntToString(50)));
            } else if (J2EEProjectUtilities.isDynamicWebProject(facetedProject)) {
                IProjectFacet webFacet = ProjectFacetsManager.getProjectFacet((String)"jst.web");
                ret = facetedProject.hasProjectFacet(webFacet.getVersion(J2EEVersionUtil.convertVersionIntToString(J2EEVersionUtil.convertJ2EEVersionIDToWebVersionID(50))));
            } else if (J2EEProjectUtilities.isEJBProject(facetedProject)) {
                IProjectFacet ejbFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
                ret = facetedProject.hasProjectFacet(ejbFacet.getVersion(J2EEVersionUtil.convertVersionIntToString(J2EEVersionUtil.convertJ2EEVersionIDToEJBVersionID(50))));
            } else if (J2EEProjectUtilities.isApplicationClientProject(facetedProject)) {
                IProjectFacet appFacet = ProjectFacetsManager.getProjectFacet((String)"jst.appclient");
                ret = facetedProject.hasProjectFacet(appFacet.getVersion(J2EEVersionUtil.convertVersionIntToString(50)));
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static boolean isLegacyJ2EEProject(IProject project) {
        IFacetedProject facetedProject;
        boolean ret;
        block14: {
            ret = false;
            facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject != null) break block14;
            return false;
        }
        try {
            if (J2EEProjectUtilities.isEARProject(facetedProject)) {
                IProjectFacet earFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
                ret = facetedProject.hasProjectFacet(earFacet.getVersion(J2EEVersionUtil.convertVersionIntToString(14))) || facetedProject.hasProjectFacet(earFacet.getVersion(J2EEVersionUtil.convertVersionIntToString(13))) || facetedProject.hasProjectFacet(earFacet.getVersion(J2EEVersionUtil.convertVersionIntToString(12)));
            } else if (J2EEProjectUtilities.isDynamicWebProject(facetedProject)) {
                IProjectFacet webFacet = ProjectFacetsManager.getProjectFacet((String)"jst.web");
                ret = facetedProject.hasProjectFacet(webFacet.getVersion(J2EEVersionUtil.convertVersionIntToString(J2EEVersionUtil.convertJ2EEVersionIDToWebVersionID(14)))) || facetedProject.hasProjectFacet(webFacet.getVersion(J2EEVersionUtil.convertVersionIntToString(J2EEVersionUtil.convertJ2EEVersionIDToWebVersionID(13)))) || facetedProject.hasProjectFacet(webFacet.getVersion(J2EEVersionUtil.convertVersionIntToString(J2EEVersionUtil.convertJ2EEVersionIDToWebVersionID(12))));
            } else if (J2EEProjectUtilities.isEJBProject(facetedProject)) {
                IProjectFacet ejbFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
                ret = facetedProject.hasProjectFacet(ejbFacet.getVersion(J2EEVersionUtil.convertVersionIntToString(J2EEVersionUtil.convertJ2EEVersionIDToEJBVersionID(14)))) || facetedProject.hasProjectFacet(ejbFacet.getVersion(J2EEVersionUtil.convertVersionIntToString(J2EEVersionUtil.convertJ2EEVersionIDToEJBVersionID(13)))) || facetedProject.hasProjectFacet(ejbFacet.getVersion(J2EEVersionUtil.convertVersionIntToString(J2EEVersionUtil.convertJ2EEVersionIDToEJBVersionID(12))));
            } else if (J2EEProjectUtilities.isApplicationClientProject(facetedProject)) {
                IProjectFacet appFacet = ProjectFacetsManager.getProjectFacet((String)"jst.appclient");
                ret = facetedProject.hasProjectFacet(appFacet.getVersion(J2EEVersionUtil.convertVersionIntToString(14))) || facetedProject.hasProjectFacet(appFacet.getVersion(J2EEVersionUtil.convertVersionIntToString(13))) || facetedProject.hasProjectFacet(appFacet.getVersion(J2EEVersionUtil.convertVersionIntToString(12)));
            } else if (J2EEProjectUtilities.isJCAProject(facetedProject)) {
                IProjectFacet jcaFacet = ProjectFacetsManager.getProjectFacet((String)"jst.connector");
                ret = facetedProject.hasProjectFacet(jcaFacet.getVersion(J2EEVersionUtil.convertVersionIntToString(J2EEVersionUtil.convertJ2EEVersionIDToConnectorVersionID(14)))) || facetedProject.hasProjectFacet(jcaFacet.getVersion(J2EEVersionUtil.convertVersionIntToString(J2EEVersionUtil.convertJ2EEVersionIDToConnectorVersionID(13))));
            } else if (J2EEProjectUtilities.isUtilityProject(facetedProject)) {
                ret = true;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static IVirtualReference[] getJ2EEModuleReferences(IVirtualComponent earComponent) {
        ArrayList<String> j2eeTypes = new ArrayList<String>();
        j2eeTypes.add("jst.appclient");
        j2eeTypes.add("jst.connector");
        j2eeTypes.add("jst.ejb");
        j2eeTypes.add("jst.web");
        return J2EEProjectUtilities.getComponentReferences(earComponent, j2eeTypes);
    }

    public static IVirtualReference[] getComponentReferences(IVirtualComponent earComponent) {
        return J2EEProjectUtilities.getComponentReferences(earComponent, Collections.EMPTY_LIST);
    }

    public static IVirtualReference getComponentReference(IVirtualComponent earComponent, String componentName) {
        IVirtualReference[] refs = J2EEProjectUtilities.getComponentReferences(earComponent, Collections.EMPTY_LIST);
        int i = 0;
        while (i < refs.length) {
            IVirtualReference reference = refs[i];
            if (reference.getReferencedComponent().getName().equals(componentName)) {
                return reference;
            }
            ++i;
        }
        return null;
    }

    private static IVirtualReference[] getComponentReferences(IVirtualComponent earComponent, List componentTypes) {
        List components = J2EEProjectUtilities.getComponentReferencesAsList(earComponent, componentTypes);
        if (components.size() > 0) {
            return components.toArray(new IVirtualReference[components.size()]);
        }
        return NO_REFERENCES;
    }

    private static List getComponentReferencesAsList(IVirtualComponent earComponent, List componentTypes) {
        ArrayList<IVirtualReference> components = new ArrayList<IVirtualReference>();
        if (earComponent != null && J2EEProjectUtilities.isEARProject(earComponent.getProject())) {
            IVirtualReference[] refComponents = earComponent.getReferences();
            int i = 0;
            while (i < refComponents.length) {
                IVirtualComponent module = refComponents[i].getReferencedComponent();
                if (module != null) {
                    if (componentTypes == null || componentTypes.size() == 0) {
                        components.add(refComponents[i]);
                    } else if (componentTypes.contains(J2EEProjectUtilities.getJ2EEComponentType(module))) {
                        components.add(refComponents[i]);
                    }
                }
                ++i;
            }
        }
        return components;
    }
}

