/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.build;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.documentModel.validate.PHPProblemsValidator;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;

public class FullPhpProjectBuildVisitor
implements IResourceVisitor {
    private IProgressMonitor monitor;
    private PHPProblemsValidator validator = PHPProblemsValidator.getInstance();

    public FullPhpProjectBuildVisitor(IProgressMonitor iProgressMonitor) {
        this.monitor = iProgressMonitor;
    }

    public boolean visit(IResource iResource) {
        if (iResource.getType() == 1) {
            this.handle((IFile)iResource);
            return false;
        }
        if (iResource.getType() == 4) {
            return this.handle((IProject)iResource);
        }
        return true;
    }

    private boolean handle(IProject iProject) {
        return PHPWorkspaceModelManager.getInstance().getModelForProject(iProject, true) != null;
    }

    private void handle(IFile iFile) {
        if (this.monitor.isCanceled()) {
            return;
        }
        this.monitor.subTask(NLS.bind((String)"Compiling: {0} ...", (Object)iFile.getFullPath().toPortableString()));
        this.validator.validateFile(iFile);
        PHPWorkspaceModelManager.getInstance().addFileToModel(iFile);
    }
}

