/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.dse.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.IPropertySetChangeEvent;
import org.eclipse.datatools.connectivity.IPropertySetListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.Category;
import org.eclipse.datatools.connectivity.internal.ui.LocalRepositoryNode;
import org.eclipse.datatools.connectivity.ui.RefreshProfileJob;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.INavigatorContentService;

public class ConnectionProfileContentProvider
implements ICommonContentProvider {
    private boolean mShowCategories = true;
    private Viewer mViewer;
    private Object mInput;
    private IExtensionStateModel mStateModel;
    private IProfileListener mProfileListener = new IProfileListener(){

        public void profileAdded(IConnectionProfile profile) {
            profile.addPropertySetListener(ConnectionProfileContentProvider.this.mPropertyListener);
            ConnectionProfileContentProvider.this.refreshViewer(ConnectionProfileContentProvider.this.mShowCategories && !ConnectionProfileContentProvider.this.isRepositoryProfile(profile) ? profile.getCategory() : null, true);
        }

        public void profileDeleted(IConnectionProfile profile) {
            profile.removePropertySetListener(ConnectionProfileContentProvider.this.mPropertyListener);
            ConnectionProfileContentProvider.this.refreshViewer(ConnectionProfileContentProvider.this.mShowCategories && !ConnectionProfileContentProvider.this.isRepositoryProfile(profile) ? profile.getCategory() : null, true);
        }

        public void profileChanged(IConnectionProfile profile) {
            ConnectionProfileContentProvider.this.refreshViewer(profile, false);
        }
    };
    private IPropertySetListener mPropertyListener = new IPropertySetListener(){

        public void propertySetChanged(IPropertySetChangeEvent event) {
            ConnectionProfileContentProvider.this.handleProfilePropertyChanged(event);
        }
    };

    public ConnectionProfileContentProvider() {
        ProfileManager.getInstance().addProfileListener(this.mProfileListener);
    }

    public void setShowCategories(boolean showCategories) {
        if (showCategories != this.mShowCategories) {
            this.mShowCategories = showCategories;
            this.refreshViewer(null, false);
        }
    }

    public boolean isShowCategories() {
        return this.mShowCategories;
    }

    protected void refreshViewer(final Object object, boolean expand) {
        if (this.mViewer instanceof TreeViewer && object instanceof IConnectionProfile) {
            RefreshProfileJob.scheduleRefreshProfileJob((IConnectionProfile)((IConnectionProfile)object), (TreeViewer)((TreeViewer)this.mViewer));
        } else {
            Runnable runner = new Runnable(){

                public void run() {
                    ((CommonViewer)ConnectionProfileContentProvider.this.mViewer).refresh(object);
                }
            };
            this.mViewer.getControl().getDisplay().syncExec(runner);
        }
    }

    protected void handleProfilePropertyChanged(IPropertySetChangeEvent event) {
        if (IConnectionProfile.CONNECTION_PROFILE_PROPERTY_SET.equals(event.getPropertySetType()) && event.getChangedProperty("connectionState") != null) {
            final IPropertySetChangeEvent finalEvent = event;
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    IViewPart dse = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.datatools.connectivity.DataSourceExplorerNavigator");
                    if (dse != null) {
                        CommonNavigator navigator = (CommonNavigator)dse;
                        INavigatorContentService contentService = navigator.getNavigatorContentService();
                        String description = contentService.createCommonDescriptionProvider().getDescription((Object)finalEvent.getConnectionProfile());
                        Image image = contentService.createCommonLabelProvider().getImage((Object)finalEvent.getConnectionProfile());
                        navigator.getViewSite().getActionBars().getStatusLineManager().setMessage(image, description);
                    }
                }
            });
            this.refreshViewer(event.getConnectionProfile(), false);
        }
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = new Object[]{};
        if (parentElement instanceof IWorkspaceRoot) {
            return this.getChildren(ProfileManager.getInstance());
        }
        if (parentElement instanceof ProfileManager) {
            ProfileManager pm = (ProfileManager)parentElement;
            ArrayList<LocalRepositoryNode> kids = new ArrayList<LocalRepositoryNode>();
            kids.add(new LocalRepositoryNode());
            this.recurseSubCategoryProfiles(pm.getCategory("org.eclipse.datatools.connectivity.connectionProfileRepositoryCategory"), kids);
            children = kids.size() == 1 ? this.getChildren(kids.get(0)) : kids.toArray();
        } else if (parentElement instanceof LocalRepositoryNode) {
            ArrayList<Object> kids = new ArrayList<Object>();
            ProfileManager pm = ProfileManager.getInstance();
            if (this.mShowCategories) {
                kids.addAll(Arrays.asList(pm.getRootCategories()));
                kids.remove(pm.getCategory("org.eclipse.datatools.connectivity.connectionProfileRepositoryCategory"));
                children = kids.toArray();
            } else {
                kids.addAll(Arrays.asList(pm.getProfiles()));
                this.removeRepositoryProfiles(kids, pm.getCategory("org.eclipse.datatools.connectivity.connectionProfileRepositoryCategory"));
            }
            children = kids.toArray();
        } else if (parentElement instanceof Object[]) {
            children = (Object[])parentElement;
        } else if (parentElement instanceof ICategory) {
            ICategory icat = (ICategory)parentElement;
            ArrayList arry = new ArrayList();
            if (this.mShowCategories) {
                arry.addAll(icat.getChildCategories());
                arry.addAll(icat.getAssociatedProfiles());
            } else {
                arry.addAll(icat.getAssociatedProfiles());
                this.recurseSubCategoryProfiles(icat, arry);
            }
            children = arry.toArray();
        } else if (parentElement instanceof IConnectionProfile) {
            children = new Object[]{};
        }
        return children;
    }

    private void removeRepositoryProfiles(List kids, ICategory category) {
        kids.removeAll(category.getAssociatedProfiles());
        Iterator it = category.getChildCategories().iterator();
        while (it.hasNext()) {
            this.removeRepositoryProfiles(kids, (ICategory)it.next());
        }
    }

    private void recurseSubCategoryProfiles(ICategory parent, List arry) {
        arry.addAll(parent.getAssociatedProfiles());
        Iterator it = parent.getChildCategories().iterator();
        while (it.hasNext()) {
            ICategory sub = (ICategory)it.next();
            this.recurseSubCategoryProfiles(sub, arry);
        }
    }

    public Object getParent(Object element) {
        Object parent = null;
        if (element instanceof ICategory) {
            parent = ((ICategory)element).getParent();
            if (parent == null) {
                parent = ((Category)element).getRepositoryProfile();
            }
            if (parent == null) {
                parent = this.mInput;
            }
        } else if (element instanceof IConnectionProfile) {
            if (this.mShowCategories) {
                parent = ((IConnectionProfile)element).getCategory();
                if (parent == null || this.isRepositoryProfile((IConnectionProfile)element)) {
                    parent = this.mInput;
                }
            } else {
                parent = ((IConnectionProfile)element).getParentProfile();
                if (parent == null) {
                    parent = this.mInput;
                }
            }
        }
        return parent;
    }

    private boolean isRepositoryProfile(IConnectionProfile profile) {
        for (ICategory cat = profile.getCategory(); cat != null; cat = cat.getParent()) {
            if (!"org.eclipse.datatools.connectivity.connectionProfileRepositoryCategory".equals(cat.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        ProfileManager.getInstance().removeProfileListener(this.mProfileListener);
        Iterator<IConnectionProfile> it = Arrays.asList(ProfileManager.getInstance().getProfiles()).iterator();
        while (it.hasNext()) {
            it.next().removePropertySetListener(this.mPropertyListener);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.mInput = newInput;
        this.mViewer = viewer;
        if (this.mViewer == null) {
            Iterator<IConnectionProfile> it = Arrays.asList(ProfileManager.getInstance().getProfiles()).iterator();
            while (it.hasNext()) {
                it.next().removePropertySetListener(this.mPropertyListener);
            }
        } else {
            Iterator<IConnectionProfile> it = Arrays.asList(ProfileManager.getInstance().getProfiles()).iterator();
            while (it.hasNext()) {
                it.next().addPropertySetListener(this.mPropertyListener);
            }
        }
    }

    public void init(ICommonContentExtensionSite aConfig) {
        this.mStateModel = aConfig.getExtensionStateModel();
    }

    public void restoreState(IMemento aMemento) {
        String showCatString = aMemento.getString("showCategories");
        this.mStateModel.setBooleanProperty("showCategories", this.mShowCategories);
        this.mStateModel.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("showCategories".equals(event.getProperty())) {
                    ConnectionProfileContentProvider.this.setShowCategories((Boolean)event.getNewValue());
                }
            }
        });
    }

    public void saveState(IMemento aMemento) {
        aMemento.putString("showCategories", Boolean.toString(this.isShowCategories()));
    }
}

