/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.breakpoint.adapter;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.RunToLineHandler;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org.eclipse.php.internal.debug.core.model.PHPRunToLineBreakpoint;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.debug.ui.breakpoint.provider.PHPBreakpointProvider;
import org.eclipse.php.internal.ui.util.StatusLineMessageTimerManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class PHPRunToLineAdapter
implements IRunToLineTarget {
    public void runToLine(IWorkbenchPart iWorkbenchPart, ISelection iSelection, ISuspendResume iSuspendResume) throws CoreException {
        IEditorPart iEditorPart = (IEditorPart)iWorkbenchPart;
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        String string = null;
        if (iEditorInput == null) {
            string = PHPDebugUIMessages.PHPRunToLineAdapter_0;
        } else {
            ITextEditor iTextEditor = (ITextEditor)iEditorPart;
            IDocument iDocument = iTextEditor.getDocumentProvider().getDocument((Object)iEditorInput);
            if (iDocument == null) {
                string = PHPDebugUIMessages.PHPRunToLineAdapter_1;
            } else {
                ITextSelection iTextSelection = (ITextSelection)iSelection;
                int n = 0;
                try {
                    n = iDocument.getLineOfOffset(iTextSelection.getOffset()) + 1;
                }
                catch (BadLocationException badLocationException) {}
                int n2 = PHPBreakpointProvider.getValidPosition(iDocument, n);
                if (n2 < 0) {
                    StatusLineMessageTimerManager.setErrorMessage((String)PHPDebugUIMessages.CannotRunToLine, (long)1000L, (boolean)true);
                    return;
                }
                int n3 = 0;
                try {
                    n3 = iDocument.getLineOfOffset(n2) + 1;
                    if (n3 != n) {
                        StatusLineMessageTimerManager.setErrorMessage((String)PHPDebugUIMessages.CannotRunToLine, (long)1000L, (boolean)true);
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    StatusLineMessageTimerManager.setErrorMessage((String)PHPDebugUIMessages.CannotRunToLine, (long)1000L, (boolean)true);
                    return;
                }
                if (n > 0) {
                    if (this.getValidPosition(iDocument, n) != -1) {
                        IDebugTarget iDebugTarget;
                        if (iSuspendResume instanceof IAdaptable && (iDebugTarget = (IDebugTarget)((IAdaptable)iSuspendResume).getAdapter(IDebugTarget.class)) != null) {
                            IFile iFile = this.getFile(iTextEditor);
                            PHPRunToLineBreakpoint pHPRunToLineBreakpoint = new PHPRunToLineBreakpoint(iFile, n);
                            RunToLineHandler runToLineHandler = new RunToLineHandler(iDebugTarget, iSuspendResume, (IBreakpoint)pHPRunToLineBreakpoint);
                            runToLineHandler.run((IProgressMonitor)new NullProgressMonitor());
                            return;
                        }
                    } else {
                        string = PHPDebugUIMessages.PHPRunToLineAdapter_2;
                    }
                } else {
                    string = PHPDebugUIMessages.PHPRunToLineAdapter_2;
                }
            }
        }
        throw new CoreException((IStatus)new Status(4, PHPDebugUIPlugin.getID(), 150, string, null));
    }

    public boolean canRunToLine(IWorkbenchPart iWorkbenchPart, ISelection iSelection, ISuspendResume iSuspendResume) {
        if (iSuspendResume instanceof PHPDebugElement) {
            return iSuspendResume.isSuspended();
        }
        return false;
    }

    protected IFile getFile(ITextEditor iTextEditor) {
        if (iTextEditor == null) {
            return null;
        }
        IEditorInput iEditorInput = iTextEditor.getEditorInput();
        if (!(iEditorInput instanceof IFileEditorInput)) {
            return null;
        }
        return ((IFileEditorInput)iEditorInput).getFile();
    }

    private int getValidPosition(IDocument iDocument, int n) {
        int n2 = -1;
        if (iDocument != null) {
            int n3 = 0;
            int n4 = 0;
            try {
                IRegion iRegion = iDocument.getLineInformation(n - 1);
                n3 = iRegion.getOffset();
                n4 = Math.max(iRegion.getOffset(), iRegion.getOffset() + iRegion.getLength());
                String string = iDocument.get(n3, n4 - n3).trim();
                if (string.equals("") || string.equals("<%") || string.equals("%>") || string.equals("<?php") || string.equals("?>") || string.trim().startsWith("//")) {
                    n2 = -1;
                } else {
                    ITypedRegion[] iTypedRegionArray = null;
                    iTypedRegionArray = iDocument.computePartitioning(n3, n4 - n3);
                    int n5 = 0;
                    while (n5 < iTypedRegionArray.length) {
                        String string2 = iTypedRegionArray[n5].getType();
                        if (PHPStructuredTextPartitioner.isPHPPartitionType((String)string2)) {
                            n2 = iTypedRegionArray[n5].getOffset();
                        }
                        ++n5;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                n2 = -1;
            }
        }
        return n2;
    }
}

