/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;

class LineSelectionTextTripleClickStrategy {
    LineSelectionTextTripleClickStrategy() {
    }

    static void tripleClicked(ITextViewer text) {
        int position = text.getSelectedRange().x;
        if (position < 0) {
            return;
        }
        try {
            IDocument document = text.getDocument();
            int lineNumber = document.getLineOfOffset(position);
            String lineDelimiter = document.getLineDelimiter(lineNumber);
            int lineDelimiterLength = lineDelimiter != null ? lineDelimiter.length() : 0;
            IRegion line = document.getLineInformationOfOffset(position);
            text.setSelectedRange(line.getOffset(), line.getLength() + lineDelimiterLength);
        }
        catch (BadLocationException badLocationException) {}
    }
}

