/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.wizards;

import java.io.File;
import java.util.Vector;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.ui.ProfileImageRegistry;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ExportProfilesDialog
extends Dialog {
    private CheckboxTableViewer tvViewer;
    private Text txtFile;
    private Button btnEncryption;
    private IConnectionProfile[] mProfiles;
    private File mFile;
    private boolean mNeedEncryption;

    public ExportProfilesDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(80);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 20;
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        Group group = new Group(container, 0);
        group.setText(ConnectivityUIPlugin.getDefault().getResourceString("ExportProfilesDialog.group.text"));
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        group.setLayoutData((Object)gridData);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.makeColumnsEqualWidth = true;
        gridLayout_1.numColumns = 3;
        group.setLayout((Layout)gridLayout_1);
        CheckboxTableViewer checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)group, (int)2816);
        checkboxTableViewer.setSorter(new ViewerSorter());
        checkboxTableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        checkboxTableViewer.setContentProvider((IContentProvider)new ContentProvider());
        Table table = checkboxTableViewer.getTable();
        GridData gridData_1 = new GridData(1808);
        gridData_1.horizontalSpan = 3;
        gridData_1.widthHint = 392;
        table.setLayoutData((Object)gridData_1);
        checkboxTableViewer.setInput(new Object());
        this.tvViewer = checkboxTableViewer;
        Button button = new Button((Composite)group, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportProfilesDialog.this.tvViewer.setAllChecked(true);
            }
        });
        button.setLayoutData((Object)new GridData(64));
        button.setText(ConnectivityUIPlugin.getDefault().getResourceString("ExportProfilesDialog.button.text"));
        Label label = new Label((Composite)group, 0);
        button = new Button((Composite)group, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportProfilesDialog.this.tvViewer.setAllChecked(false);
            }
        });
        button.setLayoutData((Object)new GridData(64));
        button.setText(ConnectivityUIPlugin.getDefault().getResourceString("ExportProfilesDialog.button.text1"));
        Label label2 = new Label(container, 0);
        gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        gridData.widthHint = 495;
        label2.setLayoutData((Object)gridData);
        label2 = new Label(container, 0);
        gridData = new GridData();
        gridData.horizontalIndent = 5;
        label2.setLayoutData((Object)gridData);
        label2.setText(ConnectivityUIPlugin.getDefault().getResourceString("ExportProfilesDialog.label.text"));
        Text text = new Text(container, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 243;
        text.setLayoutData((Object)gridData);
        this.txtFile = text;
        Button button2 = new Button(container, 0);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportProfilesDialog.this.txtFile.setText(new FileDialog(ExportProfilesDialog.this.getShell()).open());
            }
        });
        button2.setLayoutData((Object)new GridData(64));
        button2.setText(ConnectivityUIPlugin.getDefault().getResourceString("ExportProfilesDialog.button.text2"));
        button2 = new Button(container, 32);
        gridData = new GridData(512);
        gridData.horizontalIndent = 10;
        gridData.horizontalSpan = 3;
        button2.setLayoutData((Object)gridData);
        button2.setText(ConnectivityUIPlugin.getDefault().getResourceString("ExportProfilesDialog.btnEncryption.text"));
        button2.setSelection(true);
        this.btnEncryption = button2;
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ConnectivityUIPlugin.getDefault().getResourceString("ExportProfilesDialog.null.title"));
    }

    public IConnectionProfile[] getSelectedProfiles() {
        return this.mProfiles;
    }

    public File getFile() {
        return this.mFile;
    }

    public boolean needEncryption() {
        return this.mNeedEncryption;
    }

    protected void okPressed() {
        Vector<Object> vec = new Vector<Object>();
        Object[] elements = this.tvViewer.getCheckedElements();
        if (elements.length == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.export.noselection"));
            return;
        }
        if (this.txtFile.getText().length() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.export.nofile"));
            return;
        }
        for (int i = 0; i < elements.length; ++i) {
            vec.add(elements[i]);
        }
        this.mProfiles = vec.toArray(new IConnectionProfile[0]);
        this.mFile = new File(this.txtFile.getText());
        String fileParent = this.mFile.getParent();
        boolean hasParent = fileParent != null && this.mFile.getParent().length() != 0;
        boolean pathEndsInFileSeparator = false;
        boolean hasValidParent = false;
        if (hasParent) {
            File parentFile = new File(fileParent);
            hasValidParent = parentFile.exists();
            pathEndsInFileSeparator = parentFile.isDirectory();
        }
        if (!(hasParent && hasValidParent && pathEndsInFileSeparator)) {
            MessageDialog.openError((Shell)this.getShell(), (String)ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.export.notvalidfile"));
            return;
        }
        this.mNeedEncryption = this.btnEncryption.getSelection();
        super.okPressed();
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ProfileManager.getInstance().getProfiles();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            IConnectionProfile profile = (IConnectionProfile)element;
            return profile.getName();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            IConnectionProfile profile = (IConnectionProfile)element;
            return ProfileImageRegistry.getInstance().getProfileImage(profile.getProvider());
        }
    }
}

