/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.text.Collator;
import java.util.NoSuchElementException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.jpt.db.internal.Catalog;
import org.eclipse.jpt.db.internal.Connection;
import org.eclipse.jpt.db.internal.ConnectionListener;
import org.eclipse.jpt.db.internal.ConnectionProfileRepository;
import org.eclipse.jpt.db.internal.DTPConnectionProfileWrapper;
import org.eclipse.jpt.db.internal.DTPWrapper;
import org.eclipse.jpt.db.internal.Database;
import org.eclipse.jpt.db.internal.NullConnectionProfile;
import org.eclipse.jpt.db.internal.ProfileListener;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.db.internal.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectionProfile
extends DTPWrapper
implements Comparable<ConnectionProfile> {
    private Connection connection;
    private Database database;
    private String catalogName;
    private ConnectionListener connectionListener;
    private ConnectionProfileRepository profileRepository;

    static ConnectionProfile createProfile(ConnectionProfileRepository profileRepository, IConnectionProfile dtpProfile) {
        return dtpProfile == null ? NullConnectionProfile.instance() : new DTPConnectionProfileWrapper(profileRepository, dtpProfile);
    }

    ConnectionProfile(ConnectionProfileRepository profileRepository) {
        this.profileRepository = profileRepository;
        this.connectionListener = this.buildConnectionListener();
        this.catalogName = "";
    }

    public abstract void connect();

    public abstract void disconnect();

    protected abstract Connection buildConnection();

    protected abstract Database buildDatabase();

    abstract void databaseChanged(Database var1, int var2);

    abstract void catalogChanged(Catalog var1, Database var2, int var3);

    abstract void schemaChanged(Schema var1, Database var2, int var3);

    abstract void tableChanged(Table var1, Schema var2, Database var3, int var4);

    protected void refreshDatabase() {
        this.disposeDatabase();
        this.database = null;
    }

    @Override
    protected void dispose() {
        this.disengageConnectionListener();
        this.disposeConnection();
        this.disposeDatabase();
    }

    private void disposeConnection() {
        if (this.connection != null) {
            this.getConnection().dispose();
        }
    }

    private void disposeDatabase() {
        if (this.database != null) {
            this.getDatabase().dispose();
        }
    }

    public Connection getConnection() {
        if (this.connection == null) {
            this.connection = this.buildConnection();
            this.engageConnectionListener();
        }
        return this.connection;
    }

    public Database getDatabase() {
        if (this.database == null) {
            this.database = this.buildDatabase();
            this.setDefaultCatalogName();
        }
        return this.database;
    }

    public abstract String getDatabaseName();

    public abstract String getDatabaseProduct();

    public abstract String getDatabaseVendor();

    public abstract String getDatabaseVersion();

    public abstract String getDriverClass();

    public abstract String getUrl();

    public abstract String getUserName();

    public abstract String getUserPassword();

    public abstract String getInstanceId();

    public abstract String getProviderId();

    public abstract boolean isConnected();

    @Override
    protected boolean connectionIsOnline() {
        return this.isConnected();
    }

    abstract boolean wraps(IConnectionProfile var1);

    public boolean isNull() {
        return true;
    }

    ConnectionProfileRepository getProfileRepository() {
        return this.profileRepository;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setDefaultCatalogName() {
        this.setCatalogName(this.database.getDefaultCatalogName());
    }

    public void setCatalogName(String catalogName) {
        if (this.catalogName == catalogName) {
            return;
        }
        if (this.database.supportsCatalogs()) {
            String name = catalogName != null ? catalogName : this.database.getDefaultCatalogName();
            Catalog catalog = this.database.catalogNamed(name);
            if (catalog == null) {
                throw new NoSuchElementException();
            }
            this.catalogName = name;
            this.database.refresh();
            this.catalogChanged(catalog, this.database, 0);
        } else {
            this.catalogName = "";
            this.database.refresh();
        }
    }

    public abstract void addProfileListener(ProfileListener var1);

    public abstract void removeProfileListener(ProfileListener var1);

    public abstract void addConnectionListener(ConnectionListener var1);

    public abstract void removeConnectionListener(ConnectionListener var1);

    private ConnectionListener buildConnectionListener() {
        return new ConnectionListener(){

            public void aboutToClose(Connection c) {
            }

            public void closed(Connection c) {
                ConnectionProfile.this.refreshDatabase();
            }

            public void modified(Connection c) {
            }

            public boolean okToClose(Connection c) {
                return true;
            }

            public void opened(Connection c) {
                ConnectionProfile.this.refreshDatabase();
            }

            public void databaseChanged(Connection c, Database db) {
            }

            public void schemaChanged(Connection c, Schema schema) {
            }

            public void tableChanged(Connection c, Table table) {
            }
        };
    }

    protected void disengageConnectionListener() {
        this.removeConnectionListener();
    }

    protected void engageConnectionListener() {
        this.addConnectionListener();
    }

    private void addConnectionListener() {
        this.addConnectionListener(this.connectionListener);
    }

    private void removeConnectionListener() {
        this.removeConnectionListener(this.connectionListener);
    }

    @Override
    public int compareTo(ConnectionProfile connectionProfile) {
        return Collator.getInstance().compare(this.getName(), connectionProfile.getName());
    }
}

