/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.jdt.dbunit.internal.ui;

import java.util.Arrays;
import java.util.Comparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionFactoryProvider;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileConnectionManager;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPWizardNode;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ProfileWizardProvider;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.ui.DbUnitMessages;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ConnectionProfileGroup {
    public static final String JDBC_CATEGORY = "org.eclipse.datatools.connectivity.db.category";
    private Cursor _cursor;
    private Combo _DBCPCombo;
    private boolean _readOnly = false;
    private Button _mModify;
    private Button _mConnect;
    private Composite _cpGroup;
    private String _cpName = null;
    private String _category = null;
    private String _providerID = null;
    private ListenerList changeListeners = new ListenerList();
    private IConnection _connection = null;
    private Throwable _connectException = null;

    public ConnectionProfileGroup(Composite parent) {
        this(parent, false, false, true, 1);
    }

    public ConnectionProfileGroup(Composite parent, boolean labelVisible, boolean newButtonVisible, boolean connectButtonVisible, int numColumnsForParent) {
        this._cpGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        int numColumns = 1;
        if (labelVisible) {
            ++numColumns;
        }
        if (newButtonVisible) {
            ++numColumns;
        }
        if (connectButtonVisible) {
            ++numColumns;
        }
        layout.numColumns = numColumns;
        layout.marginWidth = 0;
        this._cpGroup.setLayout((Layout)layout);
        GridData cGridData = new GridData(768);
        if (numColumnsForParent > 1) {
            cGridData.horizontalSpan = numColumnsForParent;
            if (labelVisible) {
                --cGridData.horizontalSpan;
            }
            if (newButtonVisible) {
                --cGridData.horizontalSpan;
            }
            if (connectButtonVisible) {
                --cGridData.horizontalSpan;
            }
        }
        this._cpGroup.setLayoutData((Object)cGridData);
        if (labelVisible) {
            Label label = new Label(this._cpGroup, 0);
            label.setText(DbUnitMessages.ConnectionProfileGroup_Profile_Combo_Label);
        }
        this._DBCPCombo = new Combo(this._cpGroup, 12);
        GridData data = new GridData(768);
        this._DBCPCombo.setLayoutData((Object)data);
        this._DBCPCombo.setEnabled(!this._readOnly);
        if (newButtonVisible) {
            this._mModify = new Button(this._cpGroup, 8);
            this._mModify.setLayoutData((Object)new GridData(128));
            this._mModify.setText(DbUnitMessages.ConnectionProfileGroup_New_Button_Label);
            this._mModify.addSelectionListener((SelectionListener)new NewButtonSelectionChangedListener());
            this._mModify.setVisible(newButtonVisible);
        }
        if (connectButtonVisible) {
            this._mConnect = new Button(this._cpGroup, 8);
            this._mConnect.setLayoutData((Object)new GridData(128));
            this._mConnect.setText(DbUnitMessages.ConnectionProfileGroup_Connect_Button_Label);
            this._mConnect.addSelectionListener((SelectionListener)new ConnectButtonSelectionChangedListener(this));
            this._mConnect.setEnabled(false);
            this._mConnect.setVisible(connectButtonVisible);
        }
        ComboSelectionListener listener = new ComboSelectionListener(this);
        this._DBCPCombo.addModifyListener((ModifyListener)listener);
        this._DBCPCombo.addSelectionListener((SelectionListener)listener);
    }

    public void setSelectedProfile(String profileName) {
        if (this._DBCPCombo.getItemCount() == 0) {
            this._mConnect.setEnabled(false);
            return;
        }
        if (profileName != null) {
            this._cpName = profileName;
            this._DBCPCombo.setText(profileName);
        } else {
            this._mConnect.setEnabled(false);
        }
    }

    public String getSelectedProfile() {
        if (this._DBCPCombo.getItemCount() == 0) {
            return null;
        }
        if (this._DBCPCombo.getSelectionIndex() == -1) {
            return null;
        }
        return this._DBCPCombo.getItem(this._DBCPCombo.getSelectionIndex());
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public IConnection getConnection() {
        return this._connection;
    }

    public Throwable getConnectionException() {
        return this._connectException;
    }

    public void setIsReadOnly(boolean flag) {
        this._readOnly = flag;
        if (this._DBCPCombo != null) {
            this._DBCPCombo.setEnabled(!this._readOnly);
            this._mModify.setEnabled(!this._readOnly);
            if (this._DBCPCombo.getSelectionIndex() == -1) {
                this._mConnect.setEnabled(false);
            }
        }
    }

    private void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this.changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
        if (this._DBCPCombo.getSelectionIndex() > -1 && this._mConnect != null) {
            this._mConnect.setEnabled(true);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove((Object)listener);
    }

    public String getCategory() {
        return this._category;
    }

    public void setCategory(String category) {
        this._category = category;
    }

    public void loadProfiles() {
        this._DBCPCombo.removeAll();
        this.fillConnectionProfiles();
    }

    public void fillConnectionProfiles() {
        IConnectionProfile[] profiles = null;
        profiles = this._category != null ? ProfileManager.getInstance().getProfilesByCategory(this._category) : (this._providerID != null ? ProfileManager.getInstance().getProfileByProviderID(this._providerID) : ProfileManager.getInstance().getProfiles());
        Arrays.sort(profiles, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                IConnectionProfile profile1 = (IConnectionProfile)arg0;
                IConnectionProfile profile2 = (IConnectionProfile)arg1;
                String profileName1 = profile1.getName();
                String profileName2 = profile2.getName();
                int temp = profileName1.compareToIgnoreCase(profileName2);
                return temp;
            }
        });
        this._DBCPCombo.removeAll();
        int i = 0;
        while (i < profiles.length) {
            IConnectionProfile profile = profiles[i];
            String profileName = profile.getName();
            this._DBCPCombo.add(profileName);
            ++i;
        }
    }

    private void internalGetConnection() {
        IConnectionProfile icp = ProfileManager.getInstance().getProfileByName(this.getSelectedProfile());
        IConnectionFactoryProvider factoryProvider = icp.getProvider().getConnectionFactory("java.sql.Connection");
        IConnection connect = null;
        if (factoryProvider != null) {
            ProfileConnectionManager.getProfileConnectionManagerInstance().manageProfileConnection(icp, "java.sql.Connection", (Object)this);
            if (!icp.isConnected()) {
                IStatus status = icp.connect();
                switch (status.getSeverity()) {
                    case 0: 
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 4: {
                        icp.setConnected(false);
                    }
                }
            }
            connect = ProfileConnectionManager.getProfileConnectionManagerInstance().getConnection(icp, "java.sql.Connection");
        }
        if (connect != null) {
            if (connect.getConnectException() != null) {
                this._connectException = connect.getConnectException();
                connect.getConnectException().printStackTrace();
                this._connection = null;
                this.fireChangedEvent(this);
                ExceptionHandler.showException((Shell)this._DBCPCombo.getShell(), (String)DbUnitMessages.ConnectionProfileGroup_Connection_Error_Title, (String)DbUnitMessages.ConnectionProfileGroup_Connection_Error_Text, (Throwable)connect.getConnectException());
            } else {
                this._connection = connect;
                this._connectException = null;
                this.fireChangedEvent(this);
            }
        }
    }

    public void forceGetConnectionNow() {
        if (this.getSelectedProfile() != null && this.getSelectedProfile().length() > 0) {
            this.internalGetConnection();
        }
    }

    public void setWaitCursor() {
        if (this._cursor == null) {
            this._cursor = new Cursor((Device)Display.getDefault(), 1);
            Display.getDefault().getActiveShell().setCursor(this._cursor);
        }
    }

    public void setPointerCursor() {
        if (this._cursor != null) {
            Display.getDefault().getActiveShell().setCursor(null);
            this._cursor.dispose();
            this._cursor = null;
        }
    }

    public boolean canConnect() {
        return this._mConnect.getEnabled();
    }

    public boolean canNew() {
        return this._mModify.getEnabled();
    }

    public void setShowConnectButton(boolean flag) {
        this._mConnect.setVisible(flag);
    }

    private class ComboSelectionListener
    implements SelectionListener,
    ModifyListener {
        private ConnectionProfileGroup parent;

        public ComboSelectionListener(ConnectionProfileGroup combo) {
            this.parent = combo;
        }

        public void widgetSelected(SelectionEvent e) {
            if (ConnectionProfileGroup.this._cpName != null) {
                if (ConnectionProfileGroup.this._cpName.equals(ConnectionProfileGroup.this._DBCPCombo.getText())) {
                    return;
                }
                ConnectionProfileGroup.this._cpName = ConnectionProfileGroup.this._DBCPCombo.getText();
            }
            ConnectionProfileGroup.this._connection = null;
            ConnectionProfileGroup.this.fireChangedEvent(this.parent);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void modifyText(ModifyEvent e) {
            ConnectionProfileGroup.this.fireChangedEvent(this.parent);
        }
    }

    public class NewButtonSelectionChangedListener
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            NewCPWizard wizard;
            Shell newShell = new Shell();
            if (ConnectionProfileGroup.this._category != null) {
                ICategory category = (ICategory)ConnectionProfileManager.getInstance().getCategory(ConnectionProfileGroup.this._category);
                ViewerFilter viewerFilter = new ViewerFilter(this, category){
                    final /* synthetic */ NewButtonSelectionChangedListener this$1;
                    private final /* synthetic */ ICategory val$category;
                    {
                        this.this$1 = newButtonSelectionChangedListener;
                        this.val$category = iCategory;
                    }

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        ICategory cat;
                        if (this.val$category == null) {
                            return true;
                        }
                        CPWizardNode wizardNode = (CPWizardNode)element;
                        return wizardNode.getProvider() instanceof ProfileWizardProvider && (cat = ConnectionProfileManager.getInstance().getProvider(((ProfileWizardProvider)wizardNode.getProvider()).getProfile()).getCategory()).getId().equals(this.val$category.getId());
                    }
                };
                wizard = new NewCPWizard(viewerFilter, null);
            } else {
                wizard = new NewCPWizard();
            }
            WizardDialog wizardDialog = new WizardDialog(newShell, (IWizard)wizard);
            wizardDialog.setBlockOnOpen(true);
            GroupProfileListener listener = new GroupProfileListener();
            ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
            wizardDialog.open();
            ConnectionProfileGroup.this.loadProfiles();
            if (listener.getNewProfileName() != null) {
                ConnectionProfileGroup.this.setSelectedProfile(listener.getNewProfileName());
            }
            newShell.dispose();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private class GroupProfileListener
    implements IProfileListener {
        private String newProfileName = null;

        private GroupProfileListener() {
        }

        public String getNewProfileName() {
            return this.newProfileName;
        }

        public void profileAdded(IConnectionProfile profile) {
            this.newProfileName = profile.getName();
        }

        public void profileDeleted(IConnectionProfile profile) {
        }

        public void profileChanged(IConnectionProfile profile) {
        }
    }

    public class ConnectButtonSelectionChangedListener
    implements SelectionListener {
        public ConnectButtonSelectionChangedListener(ConnectionProfileGroup combo) {
        }

        public void widgetSelected(SelectionEvent e) {
            ConnectionProfileGroup.this.internalGetConnection();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

