/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import com.ibm.icu.text.DateFormat;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSAnnotateBlock;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.client.Annotate;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.AnnotateListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.AnnotateView;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryPage;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.RemoteAnnotationStorage;
import org.eclipse.team.internal.ccvs.ui.operations.CVSOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CommitterColors;
import org.eclipse.team.internal.ccvs.ui.operations.ShowAnnotationOperation;
import org.eclipse.team.internal.ccvs.ui.operations.SourceViewerInformationControl;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.team.ui.history.RevisionAnnotationController;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public class ShowAnnotationOperation
extends CVSOperation {
    private final ICVSResource fCVSResource;
    private final String fRevision;
    private final boolean fBinary;

    public ShowAnnotationOperation(IWorkbenchPart part, ICVSResource cvsResource, String revision, boolean binary) {
        super(part);
        this.fCVSResource = cvsResource;
        this.fRevision = revision;
        this.fBinary = binary;
    }

    protected void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        boolean useLiveAnnotate = this.isKnownUseLiveAnnotate();
        boolean useView = this.isKnownUseView();
        monitor.beginTask(null, 80 + (useView ? 0 : 20) + (useLiveAnnotate ? 0 : 20));
        final AnnotateListener listener = new AnnotateListener();
        this.fetchAnnotation(listener, this.fCVSResource, this.fRevision, Policy.subMonitorFor(monitor, 80));
        if (!useLiveAnnotate || this.fCVSResource.getIResource() == null) {
            this.fetchContents(listener, Policy.subMonitorFor(monitor, 20));
        }
        final RevisionInformation information = !useView ? this.createRevisionInformation(listener, Policy.subMonitorFor(monitor, 20)) : null;
        Display display = this.getPart().getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                boolean useQuickDiffAnnotate = ShowAnnotationOperation.this.promptForQuickDiffAnnotate();
                if (useQuickDiffAnnotate) {
                    try {
                        AbstractDecoratedTextEditor editor = ShowAnnotationOperation.this.getEditor(listener);
                        if (editor != null) {
                            editor.showRevisionInformation(information, "org.eclipse.quickdiff.providers.CVSReferenceProvider");
                            IWorkbenchPage page = ShowAnnotationOperation.this.getPart().getSite().getPage();
                            ShowAnnotationOperation.this.showHistoryView(page, editor);
                            page.activate((IWorkbenchPart)editor);
                        }
                    }
                    catch (PartInitException e) {
                        CVSException.wrapException((CoreException)((Object)e));
                    }
                } else {
                    ShowAnnotationOperation.this.showView(listener);
                }
            }
        });
        monitor.done();
    }

    private IHistoryView showHistoryView(IWorkbenchPage page, AbstractDecoratedTextEditor editor) throws PartInitException {
        IHistoryView historyView;
        IHistoryPage historyPage;
        IResource object = this.fCVSResource.getIResource();
        if (object == null) {
            object = editor.getEditorInput();
        }
        if ((historyPage = (historyView = TeamUI.showHistoryFor((IWorkbenchPage)page, (Object)object, null)).getHistoryPage()) instanceof CVSHistoryPage) {
            CVSHistoryPage cvsHistoryPage = (CVSHistoryPage)historyPage;
            cvsHistoryPage.setMode(1);
            cvsHistoryPage.linkWithEditor();
        }
        return historyView;
    }

    protected String getTaskName() {
        return CVSUIMessages.ShowAnnotationOperation_taskName;
    }

    protected boolean hasCharset(ICVSResource cvsResource, InputStream contents) {
        try {
            return TeamPlugin.getCharset((String)cvsResource.getName(), (InputStream)contents) != null;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    protected void showView(AnnotateListener listener) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        String defaultPerspectiveID = this.promptForPerspectiveSwitch();
        if (defaultPerspectiveID != null) {
            try {
                workbench.showPerspective(defaultPerspectiveID, window);
            }
            catch (WorkbenchException e) {
                Utils.handleError((Shell)window.getShell(), (Exception)((Object)e), (String)CVSUIMessages.ShowAnnotationOperation_0, (String)e.getMessage());
            }
        }
        try {
            AnnotateView view = AnnotateView.openInActivePerspective();
            view.showAnnotations(this.fCVSResource, listener.getCvsAnnotateBlocks(), listener.getContents());
        }
        catch (PartInitException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
    }

    private AbstractDecoratedTextEditor getEditor(AnnotateListener listener) throws PartInitException {
        IResource resource = this.fCVSResource.getIResource();
        if (resource instanceof IFile) {
            return RevisionAnnotationController.openEditor((IWorkbenchPage)this.getPart().getSite().getPage(), (IFile)((IFile)resource));
        }
        if (this.fCVSResource instanceof ICVSRemoteResource) {
            return RevisionAnnotationController.openEditor((IWorkbenchPage)this.getPart().getSite().getPage(), (Object)this.fCVSResource, (IStorage)new RemoteAnnotationStorage((ICVSRemoteFile)this.fCVSResource, listener.getContents()));
        }
        return null;
    }

    private void fetchAnnotation(AnnotateListener listener, ICVSResource cvsResource, String revision, IProgressMonitor monitor) throws CVSException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(null, 100);
        ICVSFolder folder = cvsResource.getParent();
        FolderSyncInfo info = folder.getFolderSyncInfo();
        ICVSRepositoryLocation location = KnownRepositories.getInstance().getRepository(info.getRoot());
        Session session = new Session(location, folder, true);
        session.open(Policy.subMonitorFor(monitor, 10), false);
        try {
            Command.QuietOption quietness = CVSProviderPlugin.getPlugin().getQuietness();
            try {
                IStatus status;
                CVSProviderPlugin.getPlugin().setQuietness(Command.VERBOSE);
                ArrayList<Object> localOptions = new ArrayList<Object>();
                if (revision != null) {
                    localOptions.add(Annotate.makeRevisionOption((String)revision));
                }
                if (this.fBinary) {
                    localOptions.add(Annotate.FORCE_BINARY_ANNOTATE);
                }
                if ((status = Command.ANNOTATE.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions.toArray(new Command.LocalOption[localOptions.size()]), new ICVSResource[]{cvsResource}, (ICommandOutputListener)listener, Policy.subMonitorFor(monitor, 90))).getCode() == -10) {
                    throw new CVSServerException(status);
                }
            }
            finally {
                CVSProviderPlugin.getPlugin().setQuietness(quietness);
                monitor.done();
            }
        }
        finally {
            session.close();
        }
    }

    private RevisionInformation createRevisionInformation(AnnotateListener listener, IProgressMonitor monitor) throws CVSException {
        HashMap<String, ILogEntry> logEntriesByRevision = new HashMap<String, ILogEntry>();
        if (this.fCVSResource instanceof ICVSFile) {
            try {
                ILogEntry[] logEntries = ((ICVSFile)this.fCVSResource).getLogEntries(monitor);
                int i = 0;
                while (i < logEntries.length) {
                    ILogEntry entry = logEntries[i];
                    logEntriesByRevision.put(entry.getRevision(), entry);
                    ++i;
                }
            }
            catch (CVSException e) {
                throw e;
            }
            catch (TeamException e) {
                throw CVSException.wrapException((CoreException)((Object)e));
            }
        }
        final CommitterColors colors = CommitterColors.getDefault();
        RevisionInformation info = new RevisionInformation();
        class AnnotationControlCreator
        implements IInformationControlCreator {
            private final String statusFieldText;
            final /* synthetic */ ShowAnnotationOperation this$0;

            public AnnotationControlCreator(ShowAnnotationOperation showAnnotationOperation, String statusFieldText) {
                this.this$0 = showAnnotationOperation;
                this.statusFieldText = statusFieldText;
            }

            public IInformationControl createInformationControl(Shell parent) {
                return new SourceViewerInformationControl(parent, 4, 0, "org.eclipse.jface.defaultfont", this.statusFieldText);
            }
        }
        info.setHoverControlCreator((IInformationControlCreator)new AnnotationControlCreator(this, EditorsUI.getTooltipAffordanceString()));
        info.setInformationPresenterControlCreator((IInformationControlCreator)new AnnotationControlCreator(this, null));
        HashMap<String, Revision> sets = new HashMap<String, Revision>();
        List annotateBlocks = listener.getCvsAnnotateBlocks();
        Iterator blocks = annotateBlocks.iterator();
        while (blocks.hasNext()) {
            final CVSAnnotateBlock block = (CVSAnnotateBlock)blocks.next();
            final String revisionString = block.getRevision();
            Revision revision = (Revision)sets.get(revisionString);
            if (revision == null) {
                final ILogEntry entry = (ILogEntry)logEntriesByRevision.get(revisionString);
                if (entry == null) continue;
                revision = new Revision(){
                    private String fCommitter = null;

                    public Object getHoverInfo() {
                        if (entry != null) {
                            return String.valueOf(entry.getAuthor()) + " " + entry.getRevision() + " " + DateFormat.getDateTimeInstance((int)2, (int)3).format(entry.getDate()) + "\n\n" + entry.getComment();
                        }
                        return block.toString().substring(0, block.toString().indexOf(" ("));
                    }

                    private String getCommitterId() {
                        if (this.fCommitter == null) {
                            this.fCommitter = block.toString().substring(0, block.toString().indexOf(32));
                        }
                        return this.fCommitter;
                    }

                    public String getId() {
                        return revisionString;
                    }

                    public Date getDate() {
                        return entry.getDate();
                    }

                    public RGB getColor() {
                        return colors.getCommitterRGB(this.getCommitterId());
                    }

                    public String getAuthor() {
                        return this.getCommitterId();
                    }
                };
                sets.put(revisionString, revision);
                info.addRevision(revision);
            }
            revision.addRange((ILineRange)new LineRange(block.getStartLine(), block.getEndLine() - block.getStartLine() + 1));
        }
        return info;
    }

    private void fetchContents(AnnotateListener listener, IProgressMonitor monitor) {
        try {
            if (this.hasCharset(this.fCVSResource, listener.getContents())) {
                listener.setContents(this.getRemoteContents(this.fCVSResource, monitor));
            }
        }
        catch (CoreException e) {
            CVSUIPlugin.log(e);
        }
    }

    private InputStream getRemoteContents(ICVSResource resource, IProgressMonitor monitor) throws CoreException {
        ICVSRemoteResource remote = CVSWorkspaceRoot.getRemoteResourceFor((ICVSResource)resource);
        if (remote == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        IStorage storage = ((IResourceVariant)remote).getStorage(monitor);
        if (storage == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return storage.getContents();
    }

    private String promptForPerspectiveSwitch() {
        IPerspectiveDescriptor current;
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        String option = store.getString("pref_change_perspective_on_show_annotations");
        String desiredID = store.getString("pref_default_perspective_for_show_annotations");
        if (option.equals("always")) {
            return desiredID;
        }
        if (option.equals("never")) {
            return null;
        }
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor desired = registry.findPerspectiveWithId(desiredID);
        IWorkbenchPage page = CVSUIPlugin.getActivePage();
        if (page != null && (current = page.getPerspective()) != null && current.getId().equals(desiredID)) {
            return null;
        }
        if (desired != null) {
            String desc = desired.getDescription();
            String message = desc == null ? NLS.bind((String)CVSUIMessages.ShowAnnotationOperation_2, (Object[])new String[]{desired.getLabel()}) : NLS.bind((String)CVSUIMessages.ShowAnnotationOperation_3, (Object[])new String[]{desired.getLabel(), desc});
            MessageDialogWithToggle m = MessageDialogWithToggle.openYesNoQuestion((Shell)Utils.getShell(null), (String)CVSUIMessages.ShowAnnotationOperation_1, (String)message, (String)CVSUIMessages.ShowAnnotationOperation_4, (boolean)false, (IPreferenceStore)store, (String)"pref_change_perspective_on_show_annotations");
            int result = m.getReturnCode();
            switch (result) {
                case 0: 
                case 2: {
                    return desiredID;
                }
                case 3: {
                    return null;
                }
            }
        }
        return null;
    }

    private boolean isKnownUseView() {
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        String option = store.getString("pref_use_quickdiffannotate");
        return option.equals("never");
    }

    private boolean isKnownUseLiveAnnotate() {
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        String option = store.getString("pref_use_quickdiffannotate");
        return option.equals("always");
    }

    private boolean promptForQuickDiffAnnotate() {
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        String option = store.getString("pref_use_quickdiffannotate");
        if (option.equals("always")) {
            return true;
        }
        if (option.equals("never")) {
            return false;
        }
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)Utils.getShell(null), (String)CVSUIMessages.ShowAnnotationOperation_QDAnnotateTitle, (String)CVSUIMessages.ShowAnnotationOperation_QDAnnotateMessage, (String)CVSUIMessages.ShowAnnotationOperation_4, (boolean)false, (IPreferenceStore)store, (String)"pref_use_quickdiffannotate");
        int result = dialog.getReturnCode();
        switch (result) {
            case 0: 
            case 2: {
                return true;
            }
        }
        return false;
    }
}

