/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.binding;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.php.internal.core.ast.binding.Attribute;
import org.eclipse.php.internal.core.ast.binding.ProgramScope;
import org.eclipse.php.internal.core.ast.binding.Scope;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;

public abstract class ScopeBase
implements Scope {
    public final int start;
    public int length;
    public final ProgramScope programScope;
    public final Map entryMap = new HashMap(1);

    public ScopeBase(int n, ProgramScope programScope) {
        assert (programScope != null);
        this.start = n;
        this.programScope = programScope;
    }

    public Attribute probe(String string) {
        assert (string != null);
        return (Attribute)this.entryMap.get(string);
    }

    public Attribute lookup(VariableBase variableBase) {
        assert (variableBase != null);
        return Attribute.NULL_ATTRIBUTE;
    }

    public void insertIdentifier(String string, Attribute attribute) {
        assert (string != null && attribute != null);
        if (this.entryMap.containsKey(string)) {
            throw new IllegalArgumentException();
        }
        this.entryMap.put(string, attribute);
    }

    public int getStart() {
        return this.start;
    }

    public int getLength() {
        return this.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer, "");
        return stringBuffer.toString();
    }

    protected void appendInterval(StringBuffer stringBuffer) {
        stringBuffer.append(" start='").append(this.start).append("' length='").append(this.length).append("'");
    }

    public void toString(StringBuffer stringBuffer, String string) {
        Iterator iterator = this.entryMap.entrySet().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\n").append("\t").append(string).append("<Entry");
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            Attribute attribute = (Attribute)entry.getValue();
            stringBuffer.append(" key='").append(string2).append("' value='").append(attribute.toString()).append("'");
            stringBuffer.append("/>");
        }
    }
}

