/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.format.htmlFormatters.HTMLFormatterNoPHPFactory;
import org.eclipse.wst.html.core.internal.format.HTMLFormatProcessorImpl;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.Node;

public class PhpFormatProcessorImpl
extends HTMLFormatProcessorImpl {
    protected String getFileExtension() {
        return "php";
    }

    protected IStructuredFormatter getFormatter(Node node) {
        return HTMLFormatterNoPHPFactory.getInstance().createFormatter(node, this.getFormatPreferences());
    }

    protected void refreshFormatPreferences() {
        super.refreshFormatPreferences();
    }

    public void formatDocument(IDocument iDocument, int n, int n2) throws IOException, CoreException {
        if (iDocument == null) {
            return;
        }
        if (n >= 0 && n2 >= 0) {
            if (n + n2 > iDocument.getLength()) {
                if (n > iDocument.getLength()) {
                    return;
                }
                n2 = iDocument.getLength() - n;
            }
            IStructuredModel iStructuredModel = null;
            try {
                iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForEdit(iDocument);
                this.formatModel(iStructuredModel, n, n2);
                if (!iStructuredModel.isSharedForEdit() && iStructuredModel.isSaveNeeded()) {
                    iStructuredModel.save();
                }
            }
            finally {
                if (iStructuredModel != null) {
                    iStructuredModel.releaseFromEdit();
                }
            }
        }
    }

    public void formatModel(IStructuredModel iStructuredModel, int n, int n2) {
        HTMLFormatterNoPHPFactory.getInstance().start = n;
        HTMLFormatterNoPHPFactory.getInstance().length = n2;
        super.formatModel(iStructuredModel, n, n2);
    }
}

