/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModelFilterable;
import org.eclipse.php.internal.core.phpModel.parser.IProjectModelListener;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.internal.core.phpModel.parser.PHPUserModelManager;
import org.eclipse.php.internal.core.phpModel.parser.codeDataDB.CodeDataDB;
import org.eclipse.php.internal.core.phpModel.parser.codeDataDB.FilesCodeDataDB;
import org.eclipse.php.internal.core.phpModel.parser.codeDataDB.GlobalVariablesCodeDataDB;
import org.eclipse.php.internal.core.phpModel.parser.codeDataDB.TreeCodeDataDB;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.IPHPMarker;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableTypeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariablesTypeManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class PHPUserModel
implements IPhpModel,
IProjectModelListener,
IPhpModelFilterable {
    private static final CodeData[] EMPTY = new CodeData[0];
    public static String ID = "PHPUserModel";
    private FilesCodeDataDB phpFileDataDB;
    private CodeDataDB classesDB;
    private CodeDataDB functionsDB;
    private CodeDataDB constantsDB;
    private CodeDataDB globalsVariablesDB;
    private List listeners = Collections.synchronizedList(new ArrayList(2));
    private PHPUserModelManager manager;
    IPhpModelFilterable.IPhpModelFilter filter = null;

    public PHPUserModel() {
        this.phpFileDataDB = new FilesCodeDataDB();
        this.classesDB = new TreeCodeDataDB();
        this.functionsDB = new TreeCodeDataDB();
        this.constantsDB = new TreeCodeDataDB();
        this.globalsVariablesDB = new GlobalVariablesCodeDataDB();
    }

    public PHPUserModel(IPhpModelFilterable.IPhpModelFilter iPhpModelFilter) {
        this();
        this.setFilter(iPhpModelFilter);
    }

    public String getID() {
        return ID;
    }

    public synchronized void clear() {
        this.phpFileDataDB.clear();
        this.classesDB.clear();
        this.functionsDB.clear();
        this.constantsDB.clear();
        this.globalsVariablesDB.clear();
        this.fireDataCleared();
    }

    public CodeData[] getFileDatas() {
        List list = this.phpFileDataDB.asList();
        CodeData[] codeDataArray = new PHPFileData[list.size()];
        list.toArray(codeDataArray);
        return codeDataArray;
    }

    public PHPFileData getFileData(String string) {
        return (PHPFileData)this.phpFileDataDB.getUniqCodeData(string);
    }

    public synchronized void insert(PHPFileData pHPFileData) {
        boolean bl;
        String string = pHPFileData.getName();
        PHPFileData pHPFileData2 = (PHPFileData)this.phpFileDataDB.getUniqCodeData(string);
        boolean bl2 = bl = pHPFileData2 != null;
        if (bl) {
            this.delete(pHPFileData2);
        }
        this.phpFileDataDB.addCodeData(pHPFileData);
        PHPClassData[] pHPClassDataArray = pHPFileData.getClasses();
        int n = 0;
        while (n < pHPClassDataArray.length) {
            this.classesDB.addCodeData(pHPClassDataArray[n]);
            ++n;
        }
        PHPFunctionData[] pHPFunctionDataArray = pHPFileData.getFunctions();
        int n2 = 0;
        while (n2 < pHPFunctionDataArray.length) {
            this.functionsDB.addCodeData(pHPFunctionDataArray[n2]);
            ++n2;
        }
        PHPConstantData[] pHPConstantDataArray = pHPFileData.getConstants();
        int n3 = 0;
        while (n3 < pHPConstantDataArray.length) {
            this.constantsDB.addCodeData(pHPConstantDataArray[n3]);
            ++n3;
        }
        PHPVariableData[] pHPVariableDataArray = pHPFileData.getVariableTypeManager().getVariables(ModelSupport.EMPTY_CONTEXT);
        if (pHPVariableDataArray != null) {
            int n4 = 0;
            while (n4 < pHPVariableDataArray.length) {
                this.globalsVariablesDB.addCodeData(pHPVariableDataArray[n4]);
                ++n4;
            }
        }
        if (bl) {
            this.fireFileDataChanged(pHPFileData);
        } else {
            this.fireFileDataAdded(pHPFileData);
        }
    }

    public synchronized void delete(String string) {
        PHPFileData pHPFileData = (PHPFileData)this.phpFileDataDB.getUniqCodeData(string);
        if (pHPFileData != null) {
            this.delete(pHPFileData);
            this.fireFileDataRemoved(pHPFileData);
        }
    }

    protected synchronized void delete(PHPFileData pHPFileData) {
        PHPClassData[] pHPClassDataArray = pHPFileData.getClasses();
        int n = 0;
        while (n < pHPClassDataArray.length) {
            this.classesDB.removeCodeData(pHPClassDataArray[n]);
            ++n;
        }
        PHPFunctionData[] pHPFunctionDataArray = pHPFileData.getFunctions();
        int n2 = 0;
        while (n2 < pHPFunctionDataArray.length) {
            this.functionsDB.removeCodeData(pHPFunctionDataArray[n2]);
            ++n2;
        }
        PHPConstantData[] pHPConstantDataArray = pHPFileData.getConstants();
        int n3 = 0;
        while (n3 < pHPConstantDataArray.length) {
            this.constantsDB.removeCodeData(pHPConstantDataArray[n3]);
            ++n3;
        }
        PHPVariableData[] pHPVariableDataArray = pHPFileData.getVariableTypeManager().getVariables(ModelSupport.EMPTY_CONTEXT);
        if (pHPVariableDataArray != null) {
            int n4 = 0;
            while (n4 < pHPVariableDataArray.length) {
                this.globalsVariablesDB.removeCodeData(pHPVariableDataArray[n4]);
                ++n4;
            }
        }
        this.phpFileDataDB.removeCodeData(pHPFileData);
    }

    public CodeData[] getFunctions() {
        List list = this.functionsDB.asList();
        CodeData[] codeDataArray = new PHPFunctionData[list.size()];
        list.toArray(codeDataArray);
        return codeDataArray;
    }

    public CodeData[] getFunction(String string) {
        Collection collection = this.functionsDB.getCodeData(string);
        if (collection == null || collection.size() == 0) {
            return PHPCodeDataFactory.EMPTY_CODE_DATA_ARRAY;
        }
        CodeData[] codeDataArray = new PHPFunctionData[collection.size()];
        collection.toArray(codeDataArray);
        return codeDataArray;
    }

    public PHPFunctionData getFunction(String string, String string2) {
        Collection collection = this.functionsDB.getCodeData(string2);
        if (collection == null || collection.size() == 0) {
            return null;
        }
        for (PHPFunctionData pHPFunctionData : collection) {
            if (!pHPFunctionData.getUserData().getFileName().equals(string)) continue;
            return pHPFunctionData;
        }
        if (this.filter != null) {
            for (PHPFunctionData pHPFunctionData : collection) {
                if (!this.filter.select(this, pHPFunctionData, string)) continue;
                return pHPFunctionData;
            }
        }
        return (PHPFunctionData)collection.iterator().next();
    }

    public CodeData[] getFunctions(String string) {
        return ModelSupport.getCodeDataStartingWith(this.getFunctions(), string);
    }

    public CodeData[] getClasses() {
        List list = this.classesDB.asList();
        CodeData[] codeDataArray = new PHPClassData[list.size()];
        list.toArray(codeDataArray);
        return codeDataArray;
    }

    public PHPClassData getClass(String string, String string2) {
        Collection collection = this.classesDB.getCodeData(string2);
        if (collection == null || collection.size() == 0) {
            return null;
        }
        for (PHPClassData pHPClassData : collection) {
            if (!pHPClassData.getUserData().getFileName().equals(string)) continue;
            return pHPClassData;
        }
        if (this.filter != null) {
            for (PHPClassData pHPClassData : collection) {
                if (!this.filter.select(this, pHPClassData, string)) continue;
                return pHPClassData;
            }
        }
        return (PHPClassData)collection.iterator().next();
    }

    public CodeData[] getClass(String string) {
        Collection collection = this.classesDB.getCodeData(string);
        if (collection == null) {
            return PHPCodeDataFactory.EMPTY_CLASS_DATA_ARRAY;
        }
        return collection.toArray(new CodeData[collection.size()]);
    }

    public CodeData[] getClasses(String string) {
        return ModelSupport.getCodeDataStartingWith(this.getClasses(), string);
    }

    public CodeData[] getGlobalVariables(String string, String string2, boolean bl) {
        if (!bl) {
            PHPFileData pHPFileData = this.getFileData(string);
            CodeData[] codeDataArray = null;
            if (pHPFileData != null) {
                codeDataArray = pHPFileData.getVariableTypeManager().getVariables(ModelSupport.EMPTY_CONTEXT);
            }
            if (codeDataArray == null) {
                codeDataArray = PHPCodeDataFactory.EMPTY_CODE_DATA_ARRAY;
            }
            return ModelSupport.getCodeDataStartingWith(codeDataArray, string2);
        }
        List list = this.globalsVariablesDB.asList();
        CodeData[] codeDataArray = new CodeData[list.size()];
        list.toArray(codeDataArray);
        return ModelSupport.getCodeDataStartingWith(codeDataArray, string2);
    }

    public CodeData[] getVariables(String string, PHPCodeContext pHPCodeContext, String string2, boolean bl) {
        if (pHPCodeContext.equals(ModelSupport.EMPTY_CONTEXT)) {
            return this.getGlobalVariables(string, string2, bl);
        }
        PHPFileData pHPFileData = this.getFileData(string);
        CodeData[] codeDataArray = null;
        if (pHPFileData != null) {
            codeDataArray = pHPFileData.getVariableTypeManager().getVariables(pHPCodeContext);
        }
        if (codeDataArray == null) {
            codeDataArray = PHPCodeDataFactory.EMPTY_CODE_DATA_ARRAY;
        }
        return ModelSupport.getCodeDataStartingWith(codeDataArray, string2);
    }

    private String getClassVariableType(PHPClassData pHPClassData, String string, int n) {
        String string2;
        PHPCodeContext pHPCodeContext;
        if (pHPClassData == null) {
            return null;
        }
        String string3 = pHPClassData.getUserData().getFileName();
        PHPFileData pHPFileData = (PHPFileData)this.phpFileDataDB.getUniqCodeData(string3);
        if (pHPFileData == null) {
            return null;
        }
        PHPVariablesTypeManager pHPVariablesTypeManager = pHPFileData.getVariableTypeManager();
        PHPVariableTypeData pHPVariableTypeData = pHPVariablesTypeManager.getVariableTypeData(pHPCodeContext = ModelSupport.createContext(pHPClassData.getName(), ""), string, n);
        if (pHPVariableTypeData != null) {
            return pHPVariableTypeData.getType();
        }
        String string4 = string2 = pHPClassData.getSuperClassData() != null ? pHPClassData.getSuperClassData().getName() : null;
        if (string2 != null) {
            String string5 = this.getClassVariableType(this.getClass(string3, string2), string, n);
            return string5;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVariableType(String string, PHPCodeContext pHPCodeContext, String string2, int n, boolean bl) {
        Object object;
        PHPVariablesTypeManager pHPVariablesTypeManager;
        PHPVariableTypeData pHPVariableTypeData;
        PHPFileData pHPFileData = (PHPFileData)this.phpFileDataDB.getUniqCodeData(string);
        if (pHPFileData == null) {
            return null;
        }
        if (string2.length() > 0 && string2.charAt(0) == '$') {
            string2 = string2.substring(1);
        }
        if ((pHPVariableTypeData = (pHPVariablesTypeManager = pHPFileData.getVariableTypeManager()).getVariableTypeData(pHPCodeContext, string2, n)) != null) {
            return pHPVariableTypeData.getType();
        }
        String string3 = pHPCodeContext.getContainerClassName();
        if (string3 != null && !string3.equals("") && (object = this.getClassVariableType(this.getClass(string, string3), string2, n)) != null && ((String)object).length() > 0) {
            return object;
        }
        if (!pHPCodeContext.equals(ModelSupport.EMPTY_CONTEXT)) {
            object = pHPVariablesTypeManager.getVariable(pHPCodeContext, string2);
            if (object == null || !object.isGlobal()) {
                return null;
            }
            pHPCodeContext = ModelSupport.EMPTY_CONTEXT;
            pHPVariableTypeData = pHPVariablesTypeManager.getVariableTypeData(pHPCodeContext, string2, pHPFileData.getUserData().getStopLine());
            if (pHPVariableTypeData != null) {
                return pHPVariableTypeData.getType();
            }
        }
        if (!bl) {
            return null;
        }
        Object object2 = object = Collections.synchronizedList(this.phpFileDataDB.asList());
        synchronized (object2) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                pHPFileData = (PHPFileData)iterator.next();
                if (pHPFileData.getName().equals(string) || (pHPVariableTypeData = (pHPVariablesTypeManager = pHPFileData.getVariableTypeManager()).getVariableTypeData(pHPCodeContext, string2, pHPFileData.getUserData().getStopLine())) == null) continue;
                return pHPVariableTypeData.getType();
            }
        }
        return null;
    }

    public CodeData[] getConstant(String string) {
        Collection collection = this.constantsDB.getCodeData(string);
        if (collection != null && collection.size() > 0) {
            return collection.toArray(new CodeData[collection.size()]);
        }
        return null;
    }

    public PHPConstantData getConstant(String string, String string2) {
        Collection collection = this.constantsDB.getCodeData(string2);
        if (collection == null || collection.size() == 0) {
            return null;
        }
        for (PHPConstantData pHPConstantData : collection) {
            if (!pHPConstantData.getUserData().getFileName().equals(string)) continue;
            return pHPConstantData;
        }
        if (this.filter != null) {
            for (PHPConstantData pHPConstantData : collection) {
                if (!this.filter.select(this, pHPConstantData, string)) continue;
                return pHPConstantData;
            }
        }
        return (PHPConstantData)collection.iterator().next();
    }

    public CodeData[] getConstants() {
        List list = this.constantsDB.asList();
        CodeData[] codeDataArray = new PHPConstantData[list.size()];
        list.toArray(codeDataArray);
        return codeDataArray;
    }

    public CodeData[] getConstants(String string, boolean bl) {
        return bl ? ModelSupport.getCodeDataStartingWithCS(this.getConstants(), string) : ModelSupport.getCodeDataStartingWith(this.getConstants(), string);
    }

    public IPHPMarker[] getMarkers() {
        return null;
    }

    public void addModelListener(ModelListener modelListener) {
        if (!this.listeners.contains(modelListener)) {
            this.listeners.add(modelListener);
        }
    }

    public List getModelListenerList() {
        return this.listeners;
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    private void fireFileDataChanged(PHPFileData pHPFileData) {
        int n = this.listeners.size();
        int n2 = 0;
        while (n2 < n) {
            ModelListener modelListener = (ModelListener)this.listeners.get(n2);
            modelListener.fileDataChanged(pHPFileData);
            ++n2;
        }
    }

    private void fireFileDataRemoved(PHPFileData pHPFileData) {
        int n = this.listeners.size();
        int n2 = 0;
        while (n2 < n) {
            ModelListener modelListener = (ModelListener)this.listeners.get(n2);
            modelListener.fileDataRemoved(pHPFileData);
            ++n2;
        }
    }

    private void fireFileDataAdded(PHPFileData pHPFileData) {
        int n = this.listeners.size();
        int n2 = 0;
        while (n2 < n) {
            ModelListener modelListener = (ModelListener)this.listeners.get(n2);
            modelListener.fileDataAdded(pHPFileData);
            ++n2;
        }
    }

    private void fireDataCleared() {
        int n = this.listeners.size();
        int n2 = 0;
        while (n2 < n) {
            ModelListener modelListener = (ModelListener)this.listeners.get(n2);
            modelListener.dataCleared();
            ++n2;
        }
    }

    public void dispose() {
        this.manager.dispose();
    }

    public void initialize(IProject iProject) {
        this.manager = new PHPUserModelManager(iProject, this);
    }

    public void fileAdded(IFile iFile) {
    }

    public void fileRemoved(IFile iFile) {
        this.manager.fileRemoved(iFile);
    }

    public void fileChanged(IFile iFile, IStructuredDocument iStructuredDocument) {
    }

    public void setFilter(IPhpModelFilterable.IPhpModelFilter iPhpModelFilter) {
        this.filter = iPhpModelFilter;
    }

    public CodeData[] getFilteredClasses(String string, String string2) {
        CodeData[] codeDataArray = this.getClass(string2);
        return this.selectElements(string, codeDataArray);
    }

    public CodeData[] getFilteredConstants(String string, String string2) {
        CodeData[] codeDataArray = this.getConstant(string2);
        return this.selectElements(string, codeDataArray);
    }

    public CodeData[] getFilteredFunctions(String string, String string2) {
        CodeData[] codeDataArray = this.getFunction(string2);
        return this.selectElements(string, codeDataArray);
    }

    private CodeData[] selectElements(String string, CodeData[] codeDataArray) {
        if (codeDataArray == null || codeDataArray.length == 0) {
            return EMPTY;
        }
        if (this.filter == null) {
            return codeDataArray;
        }
        ArrayList<CodeData> arrayList = new ArrayList<CodeData>();
        if (codeDataArray != null && this.filter != null) {
            int n = 0;
            while (n < codeDataArray.length) {
                if (this.filter.select(this, codeDataArray[n], string)) {
                    arrayList.add(codeDataArray[n]);
                }
                ++n;
            }
        }
        if (arrayList.size() != 0) {
            return arrayList.toArray(new CodeData[arrayList.size()]);
        }
        return codeDataArray;
    }
}

