/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.php.internal.core.util.text.TextSequenceUtilities;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class PHPTextSequenceUtilities {
    private static final Pattern COMMENT_START_PATTERN = Pattern.compile("(/[*])|(//)");
    private static final Pattern COMMENT_END_PATTERN = Pattern.compile("[*]/");
    private static final String START_COMMENT = "/*";
    private static final char END_LINE = '\n';
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("function\\s", 2);
    private static final Pattern CLASS_PATTERN = Pattern.compile("(class|interface)\\s", 2);

    private PHPTextSequenceUtilities() {
    }

    public static TextSequence getStatment(int n, IStructuredDocumentRegion iStructuredDocumentRegion, boolean bl) {
        int n2 = n;
        if (n2 == iStructuredDocumentRegion.getEndOffset()) {
            --n2;
        }
        ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n2);
        IStructuredDocumentRegion iStructuredDocumentRegion2 = iStructuredDocumentRegion;
        if (iTextRegion instanceof ITextRegionContainer) {
            iStructuredDocumentRegion2 = (ITextRegionContainer)iTextRegion;
            iTextRegion = iStructuredDocumentRegion2.getRegionAtCharacterOffset(n);
        }
        if (iTextRegion != null && iTextRegion.getType() == "PHP_CLOSE") {
            iTextRegion = iStructuredDocumentRegion2.getRegionAtCharacterOffset(iStructuredDocumentRegion2.getStartOffset() + iTextRegion.getStart() - 1);
        }
        if (iTextRegion != null && iTextRegion.getType() == "PHP_CONTENT") {
            PhpScriptRegion phpScriptRegion = (PhpScriptRegion)iTextRegion;
            try {
                int n3 = iStructuredDocumentRegion2.getStartOffset() + phpScriptRegion.getStart();
                ITextRegion iTextRegion2 = n2 == n3 ? phpScriptRegion.getPhpToken(0) : phpScriptRegion.getPhpToken(n2 - n3 - 1);
                while (iTextRegion2.getStart() != 0) {
                    if (iTextRegion2.getType() == "PHP_CURLY_CLOSE" || iTextRegion2.getType() == "PHP_CURLY_OPEN" || iTextRegion2.getType() == "PHP_SEMICOLON") {
                        n3 += iTextRegion2.getEnd();
                        break;
                    }
                    iTextRegion2 = phpScriptRegion.getPhpToken(iTextRegion2.getStart() - 1);
                }
                TextSequence textSequence = TextSequenceUtilities.createTextSequence(iStructuredDocumentRegion, n3, n - n3);
                if (bl) {
                    textSequence = PHPTextSequenceUtilities.removeComments(textSequence);
                }
                textSequence = textSequence.subTextSequence(PHPTextSequenceUtilities.readForwardSpaces(textSequence, 0), textSequence.length());
                return textSequence;
            }
            catch (BadLocationException badLocationException) {}
        }
        return null;
    }

    private static TextSequence removeComments(TextSequence textSequence) {
        int n;
        block0: while ((n = PHPTextSequenceUtilities.getCommentStartIndex(textSequence)) > -1) {
            String string = textSequence.subSequence(n, n + 2).toString();
            if (string.equals(START_COMMENT)) {
                Matcher matcher = COMMENT_END_PATTERN.matcher(textSequence);
                boolean bl = matcher.find(n);
                if (!bl) break;
                int n2 = matcher.end();
                textSequence = textSequence.cutTextSequence(n, n2);
                continue;
            }
            int n3 = n + 2;
            while (n3 < textSequence.length()) {
                if (textSequence.charAt(n3) == '\n') {
                    textSequence = textSequence.cutTextSequence(n, n3);
                    continue block0;
                }
                ++n3;
            }
            break block0;
        }
        return textSequence;
    }

    private static int getCommentStartIndex(TextSequence textSequence) {
        Matcher matcher = COMMENT_START_PATTERN.matcher(textSequence);
        int n = 0;
        while (matcher.find(n)) {
            String string = TextSequenceUtilities.getType(textSequence, matcher.start());
            if (PHPPartitionTypes.isPHPCommentState(string) && !PHPPartitionTypes.isPHPQuotesState(string)) {
                return matcher.start();
            }
            n = matcher.start() + 2;
        }
        return -1;
    }

    public static int isInFunctionDeclaretion(TextSequence textSequence) {
        Matcher matcher = FUNCTION_PATTERN.matcher(textSequence);
        while (matcher.find()) {
            String string;
            int n = matcher.start();
            if (n != 0 && Character.isJavaIdentifierStart(textSequence.charAt(n - 1)) || !PHPPartitionTypes.isPHPRegularState(string = TextSequenceUtilities.getType(textSequence, n + 1))) continue;
            int n2 = matcher.end();
            while (n2 < textSequence.length()) {
                if (textSequence.charAt(n2) == ')' && PHPPartitionTypes.isPHPRegularState(string = TextSequenceUtilities.getType(textSequence, n2))) break;
                ++n2;
            }
            if (n2 != textSequence.length()) continue;
            return n;
        }
        return -1;
    }

    public static int isInClassDeclaretion(TextSequence textSequence) {
        Matcher matcher = CLASS_PATTERN.matcher(textSequence);
        while (matcher.find()) {
            int n;
            String string;
            int n2 = matcher.start();
            if (n2 != 0 && Character.isJavaIdentifierStart(textSequence.charAt(n2 - 1)) || !PHPPartitionTypes.isPHPRegularState(string = TextSequenceUtilities.getType(textSequence, n2 + 1))) continue;
            int n3 = n = matcher.end();
            while (n3 < textSequence.length()) {
                if (textSequence.charAt(n3) == '}' && PHPPartitionTypes.isPHPRegularState(string = TextSequenceUtilities.getType(textSequence, n3))) break;
                ++n3;
            }
            if (n3 != textSequence.length()) continue;
            return n;
        }
        return -1;
    }

    public static int readIdentifiarStartIndex(TextSequence textSequence, int n, boolean bl) {
        while (n > 0) {
            char c = textSequence.charAt(n - 1);
            if (!Character.isLetterOrDigit(c) && c != '_') break;
            --n;
        }
        if (bl && n > 0 && textSequence.charAt(n - 1) == '$') {
            --n;
        }
        return n;
    }

    public static int readIdentifiarEndIndex(TextSequence textSequence, int n, boolean bl) {
        int n2 = textSequence.length();
        if (bl && n < n2 && textSequence.charAt(n) == '$') {
            ++n;
        }
        while (n < n2) {
            char c = textSequence.charAt(n);
            if (!Character.isLetterOrDigit(c) && c != '_') break;
            ++n;
        }
        return n;
    }

    public static int readBackwardSpaces(TextSequence textSequence, int n) {
        int n2 = n;
        while (n2 > 0) {
            if (!Character.isWhitespace(textSequence.charAt(n2 - 1))) break;
            --n2;
        }
        return n2;
    }

    public static int readForwardSpaces(TextSequence textSequence, int n) {
        int n2 = n;
        while (n2 < textSequence.length()) {
            if (!Character.isWhitespace(textSequence.charAt(n2))) break;
            ++n2;
        }
        return n2;
    }

    public static int getPrivousTriggerIndex(TextSequence textSequence, int n) {
        int n2 = n;
        int n3 = 0;
        char c = '\u0000';
        while (n2 > 0) {
            char c2 = textSequence.charAt(n2 - 1);
            if (c2 == '\'' || c2 == '\"') {
                char c3 = c == '\u0000' ? c2 : (c = c == c2 ? (char)'\u0000' : c);
            }
            if (!(c != '\u0000' || Character.isLetterOrDigit(c2) || c2 == '_' || c2 == '$' || Character.isWhitespace(c2) && c2 != '\n')) {
                switch (c2) {
                    case '(': 
                    case '[': 
                    case '{': {
                        if (--n3 >= 0) break;
                        return -1;
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        ++n3;
                        break;
                    }
                    case ':': {
                        if (n3 != 0 || n2 < 2 || textSequence.charAt(n2 - 2) != ':') break;
                        return n2 - 2;
                    }
                    case '>': {
                        if (n3 != 0 || n2 < 2 || textSequence.charAt(n2 - 2) != '-') break;
                        return n2 - 2;
                    }
                    case '\n': {
                        return -1;
                    }
                    default: {
                        if (n3 != 0) break;
                        return -1;
                    }
                }
            }
            --n2;
        }
        return -1;
    }
}

