/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.highlighter.LineStyleProviderForPhp;
import org.eclipse.php.internal.ui.preferences.PHPStyledTextColorPicker;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.preferences.OverlayPreferenceStore;

public class PHPColorPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected OverlayPreferenceStore fOverlayStore;
    protected PHPStyledTextColorPicker fPicker = null;

    protected Composite createColoringComposite(Composite composite) {
        Composite composite2 = this.createComposite(composite, 1);
        return composite2;
    }

    protected Composite createComposite(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4);
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        return composite2;
    }

    protected Control createContents(Composite composite) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 768);
        scrolledComposite.setLayoutData((Object)new GridData(1808));
        Composite composite2 = this.createComposite((Composite)scrolledComposite, 1);
        scrolledComposite.setContent((Control)composite2);
        this.setSize(composite2);
        Label label = this.createDescriptionLabel(composite2, SSEUIMessages.AbstractColorPageDescription);
        Composite composite3 = this.createColoringComposite(composite2);
        this.createContentsForPicker(composite3);
        GridData gridData = (GridData)label.getLayoutData();
        gridData.widthHint = composite3.computeSize((int)-1, (int)-1).x;
        this.setSize(composite2);
        return composite2;
    }

    protected void createContentsForPicker(Composite composite) {
        this.fPicker = new PHPStyledTextColorPicker(composite, 0);
        GridData gridData = new GridData(1808);
        this.fPicker.setLayoutData(gridData);
        this.fPicker.setPreferenceStore((IPreferenceStore)this.fOverlayStore);
        this.setupPicker(this.fPicker);
        this.fPicker.setText(this.getSampleText());
    }

    protected Label createDescriptionLabel(Composite composite, String string) {
        Label label = new Label(composite, 16448);
        label.setText(string);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected Group createGroup(Composite composite, int n) {
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4);
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gridData);
        return group;
    }

    protected Label createLabel(Composite composite, String string) {
        Label label = new Label(composite, 16384);
        label.setText(string);
        GridData gridData = new GridData(4);
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        ArrayList arrayList2 = new ArrayList();
        this.initStyleList(arrayList2);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, (String)iterator.next()));
        }
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray(overlayKeyArray);
        return overlayKeyArray;
    }

    protected Button createPushButton(Composite composite, String string) {
        Button button = new Button(composite, 8);
        button.setText(string);
        GridData gridData = new GridData(4);
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
        return button;
    }

    protected Text createTextField(Composite composite, String string) {
        Text text = new Text(composite, 16384);
        text.setText(string);
        GridData gridData = new GridData(4);
        gridData.horizontalAlignment = 4;
        text.setLayoutData((Object)gridData);
        return text;
    }

    public void dispose() {
        super.dispose();
        if (this.fPicker != null && !this.fPicker.isDisposed()) {
            this.fPicker.releasePickerResources();
        }
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
        }
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return PreferenceConstants.getPreferenceStore();
    }

    public PHPStyledTextColorPicker getPicker() {
        return this.fPicker;
    }

    public String getSampleText() {
        return PHPUIMessages.ColorPage_CodeExample_0;
    }

    public void init(IWorkbench iWorkbench) {
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.createOverlayStoreKeys());
        this.fOverlayStore.load();
        this.fOverlayStore.start();
    }

    protected void initDescriptions(Dictionary dictionary) {
        dictionary.put("codeStyleNormal", PHPUIMessages.ColorPage_Normal);
        dictionary.put("editorColorBoundarymaker", PHPUIMessages.ColorPage_BoundryMaker);
        dictionary.put("editorColorKeyword", PHPUIMessages.ColorPage_Keyword);
        dictionary.put("editorColorVariable", PHPUIMessages.ColorPage_Variable);
        dictionary.put("editorColorString", PHPUIMessages.ColorPage_String);
        dictionary.put("editorColorNumber", PHPUIMessages.ColorPage_Number);
        dictionary.put("editorColorHeredoc", PHPUIMessages.ColorPage_Heredoc);
        dictionary.put("editorColorComment", PHPUIMessages.ColorPage_Comment);
        dictionary.put("editorColorPhpdoc", PHPUIMessages.ColorPage_Phpdoc);
        dictionary.put("editorColorTask", PHPUIMessages.ColorPage_TaskTag);
    }

    protected void initStyleList(ArrayList arrayList) {
        arrayList.add("codeStyleNormal");
        arrayList.add("editorColorBoundarymaker");
        arrayList.add("editorColorKeyword");
        arrayList.add("editorColorVariable");
        arrayList.add("editorColorString");
        arrayList.add("editorColorNumber");
        arrayList.add("editorColorHeredoc");
        arrayList.add("editorColorComment");
        arrayList.add("editorColorPhpdoc");
        arrayList.add("editorColorTask");
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.fPicker.refresh();
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        this.savePreferences();
        return true;
    }

    protected void savePreferences() {
        PHPUiPlugin.getDefault().savePluginPreferences();
    }

    protected void setSize(Composite composite) {
        if (composite != null) {
            this.applyDialogFont(composite);
            Point point = composite.computeSize(-1, -1);
            composite.setSize(point);
            if (composite.getParent() instanceof ScrolledComposite) {
                ScrolledComposite scrolledComposite = (ScrolledComposite)composite.getParent();
                scrolledComposite.setMinSize(point);
                scrolledComposite.setExpandHorizontal(true);
                scrolledComposite.setExpandVertical(true);
            }
        }
    }

    protected void setupPicker(PHPStyledTextColorPicker pHPStyledTextColorPicker) {
        IModelManager iModelManager = StructuredModelManager.getModelManager();
        pHPStyledTextColorPicker.setParser(iModelManager.createStructuredDocumentFor(ContentTypeIdForPHP.ContentTypeID_PHP).getParser());
        Hashtable hashtable = new Hashtable();
        this.initDescriptions(hashtable);
        ArrayList arrayList = new ArrayList();
        this.initStyleList(arrayList);
        LineStyleProviderForPhp lineStyleProviderForPhp = new LineStyleProviderForPhp();
        Hashtable hashtable2 = new Hashtable(lineStyleProviderForPhp.getColorTypesMap());
        pHPStyledTextColorPicker.setDescriptions(hashtable);
        pHPStyledTextColorPicker.setStyleList(arrayList);
        pHPStyledTextColorPicker.setContextStyleMap(hashtable2);
        pHPStyledTextColorPicker.setLineStyleProvider(lineStyleProviderForPhp);
    }

    public void setVisible(boolean bl) {
        boolean bl2 = false;
        if (bl) {
            this.getPicker().refresh();
            int n = Math.min(this.getControl().getShell().getSize().x, this.getControl().getDisplay().getClientArea().width * 9 / 10);
            int n2 = Math.min(this.getControl().getShell().getSize().y, this.getControl().getDisplay().getClientArea().height * 9 / 10);
            boolean bl3 = n != this.getControl().getShell().getSize().x;
            boolean bl4 = n2 != this.getControl().getShell().getSize().y;
            boolean bl5 = bl2 = bl3 || bl4;
            if (bl2) {
                if (bl4 && !bl3) {
                    this.getShell().setBounds(this.getShell().getLocation().x, 0, this.getShell().getSize().x, this.getControl().getDisplay().getClientArea().height);
                } else if (!bl4 && bl3) {
                    this.getShell().setBounds(0, this.getShell().getLocation().y, this.getControl().getDisplay().getClientArea().width, this.getShell().getSize().y);
                } else {
                    this.getShell().setBounds(0, 0, this.getControl().getDisplay().getClientArea().width, this.getControl().getDisplay().getClientArea().height);
                }
            }
        }
        super.setVisible(bl);
        if (bl2) {
            this.getControl().getShell().redraw();
            this.getControl().getShell().update();
        }
    }
}

