/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.communication;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.communication.DebugConnectionThread;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DebuggerCommunicationDaemon
implements ICommunicationDaemon {
    protected Object lock = new Object();
    protected ServerSocket serverSocket;
    protected boolean isAlive;
    private Preferences.IPropertyChangeListener portChangeListener;
    private Thread listenerThread;

    public void init() {
        this.initDeamonChangeListener();
        this.resetSocket();
    }

    protected void initDeamonChangeListener() {
        if (this.portChangeListener == null) {
            Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
            this.portChangeListener = new PortChangeListener();
            preferences.addPropertyChangeListener(this.portChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListen() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isAlive && this.serverSocket != null) {
                this.startListenThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListen() {
        Object object = this.lock;
        synchronized (object) {
            block15: {
                this.isAlive = false;
                if (this.serverSocket != null) {
                    try {
                        if (!this.serverSocket.isClosed()) {
                            this.serverSocket.close();
                        }
                    }
                    catch (SocketException socketException) {
                        this.serverSocket = null;
                        break block15;
                    }
                    catch (IOException iOException) {
                        try {
                            Logger.logException("Problem while closing the debugger ServerSocket.", iOException);
                            break block15;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.serverSocket = null;
                        }
                    }
                    this.serverSocket = null;
                }
            }
        }
        try {
            if (this.listenerThread != null) {
                this.listenerThread.join(2000L);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isListening() {
        Object object = this.lock;
        synchronized (object) {
            return this.isAlive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean resetSocket() {
        this.stopListen();
        int n = this.getReceiverPort();
        try {
            Object object = this.lock;
            synchronized (object) {
                this.serverSocket = new ServerSocket(n);
                this.startListen();
                return true;
            }
        }
        catch (BindException bindException) {
            this.handleMultipleBindingError();
            return false;
        }
        catch (IOException iOException) {
            Logger.logException("Error while restting the socket for the debug requests.", iOException);
        }
        return false;
    }

    public void handleMultipleBindingError() {
        final int n = this.getReceiverPort();
        Logger.log(4, "The debug port " + n + " is in use. Please select a different port for the debugger.");
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                String string = MessageFormat.format(PHPDebugCoreMessages.Port_Error_Message_Message, String.valueOf(n));
                MessageDialog.openWarning((Shell)display.getActiveShell(), (String)PHPDebugCoreMessages.Port_Error_Message_Title, (String)string);
            }
        });
    }

    protected int getReceiverPort() {
        return PHPProjectPreferences.getDebugPort(null);
    }

    protected void startConnectionThread(Socket socket) {
        new DebugConnectionThread(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startListenThread() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isAlive) {
                return;
            }
            this.isAlive = true;
        }
        object = " - Port: " + (this.serverSocket != null ? String.valueOf(this.serverSocket.getLocalPort()) : "??");
        this.listenerThread = new Thread((Runnable)new ReceiverThread(), "PHP Debugger ReceiverThread " + (String)object);
        this.listenerThread.start();
    }

    public boolean isEnabled() {
        return true;
    }

    private class PortChangeListener
    implements Preferences.IPropertyChangeListener {
        private PortChangeListener() {
        }

        public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getProperty().equals(PHPDebugCorePreferenceNames.DEBUG_PORT)) {
                DebuggerCommunicationDaemon.this.resetSocket();
            }
        }
    }

    private class ReceiverThread
    implements Runnable {
        private ReceiverThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (DebuggerCommunicationDaemon.this.isAlive) {
                    Socket socket = DebuggerCommunicationDaemon.this.serverSocket.accept();
                    DebuggerCommunicationDaemon.this.startConnectionThread(socket);
                }
            }
            catch (IOException iOException) {
                Object object = DebuggerCommunicationDaemon.this.lock;
                synchronized (object) {
                    if (DebuggerCommunicationDaemon.this.isAlive) {
                        Logger.logException("Error while listening to incoming debug requests. Listen thread terminated!", iOException);
                        DebuggerCommunicationDaemon.this.isAlive = false;
                    }
                }
            }
        }
    }
}

