/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.IPHPActionDelegator;
import org.eclipse.php.internal.ui.actions.PHPActionDelegatorRegistry;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.MoveProjectAction;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.SelectionListenerAction;

public class MoveAction
extends SelectionDispatchAction {
    private static final String MOVE_ACTION_ID = "org.eclipse.php.ui.actions.Move";
    private PHPStructuredEditor fEditor;
    private IPHPActionDelegator fReorgMoveAction;
    private IStructuredSelection selectedResources;

    public MoveAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.initMoveAction();
    }

    public MoveAction(PHPStructuredEditor pHPStructuredEditor) {
        super((IWorkbenchSite)pHPStructuredEditor.getEditorSite());
        this.fEditor = pHPStructuredEditor;
        this.initMoveAction();
    }

    private void initMoveAction() {
        this.fReorgMoveAction = PHPActionDelegatorRegistry.getActionDelegator(MOVE_ACTION_ID);
        this.setText(PHPUIMessages.MoveAction_text);
        this.update(this.getSelection());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.php.ui.move_action");
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        super.selectionChanged(selectionChangedEvent);
        this.setEnabled(this.computeEnableState());
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.selectedResources = null;
        if (iStructuredSelection != null && iStructuredSelection instanceof ITextSelection) {
            this.selectionChanged((ITextSelection)iStructuredSelection);
            return;
        }
        if (!iStructuredSelection.isEmpty()) {
            if (ActionUtils.containsOnlyProjects(iStructuredSelection.toList())) {
                this.setEnabled(false);
                return;
            }
            List list = iStructuredSelection.toList();
            IResource[] iResourceArray = ActionUtils.getResources(list);
            Object[] objectArray = ActionUtils.getPHPElements(list);
            if (list.size() != iResourceArray.length + objectArray.length) {
                this.setEnabled(false);
            } else {
                boolean bl = true;
                int n = 0;
                while (n < objectArray.length) {
                    if (!(objectArray[n] instanceof PHPFileData)) {
                        bl = false;
                    }
                    ++n;
                }
                if (bl) {
                    ArrayList<IResource> arrayList = new ArrayList<IResource>((Collection)Arrays.asList(iResourceArray));
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        IResource iResource;
                        if (objectArray[n2] instanceof PHPFileData && (iResource = PHPModelUtil.getResource((Object)objectArray[n2])) != null && iResource.exists()) {
                            arrayList.add(PHPModelUtil.getResource((Object)objectArray[n2]));
                        }
                        ++n2;
                    }
                    if (arrayList.size() == list.size()) {
                        this.selectedResources = new StructuredSelection(arrayList);
                        bl = this.createWorkbenchAction(this.selectedResources).isEnabled();
                    }
                }
                this.setEnabled(bl);
            }
        } else {
            this.setEnabled(false);
        }
        this.setEnabled(this.computeEnableState());
        this.fReorgMoveAction.setSelection(this.selectedResources);
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        IWorkbenchPart iWorkbenchPart = iWorkbenchPage.getActivePart();
        if (iWorkbenchPage == null) {
            return;
        }
        PHPStructuredEditor pHPStructuredEditor = EditorUtility.getPHPStructuredEditor(iWorkbenchPart);
        if (pHPStructuredEditor == null) {
            return;
        }
        Object[] objectArray = new IResource[]{pHPStructuredEditor.getFile()};
        this.selectedResources = new StructuredSelection(objectArray);
        this.setEnabled(true);
        this.fReorgMoveAction.setSelection(this.selectedResources);
    }

    private SelectionListenerAction createWorkbenchAction(IStructuredSelection iStructuredSelection) {
        List list = iStructuredSelection.toList();
        MoveProjectAction moveProjectAction = null;
        if (list.size() == 0 || list.get(0) instanceof IProject) {
            moveProjectAction = new MoveProjectAction(this.getShell());
            moveProjectAction.selectionChanged(iStructuredSelection);
        } else if (this.selectedResources != null) {
            moveProjectAction = new MoveResourceAction(this.getShell());
            moveProjectAction.selectionChanged(iStructuredSelection);
        }
        return moveProjectAction;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        if (this.isEnabled()) {
            this.fReorgMoveAction.run(iStructuredSelection);
        }
    }

    public void run(ITextSelection iTextSelection) {
        if (!ActionUtils.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        if (this.tryReorgMove(iTextSelection)) {
            return;
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)PHPUIMessages.MoveAction_Move, (String)PHPUIMessages.MoveAction_select);
    }

    private boolean tryReorgMove(ITextSelection iTextSelection) {
        PHPCodeData pHPCodeData = SelectionConverter.getElementAtOffset(this.fEditor);
        if (pHPCodeData == null) {
            return false;
        }
        StructuredSelection structuredSelection = new StructuredSelection((Object)pHPCodeData);
        this.selectionChanged((IStructuredSelection)structuredSelection);
        if (!this.isEnabled()) {
            return false;
        }
        this.fReorgMoveAction.run((IStructuredSelection)structuredSelection);
        return true;
    }

    public void update(ISelection iSelection) {
        super.update(iSelection);
        this.setEnabled(this.computeEnableState());
    }

    private boolean computeEnableState() {
        return this.isEnabled();
    }
}

