/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dialogs.saveFiles;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.internal.ui.dialogs.saveFiles.SaveFilesHandler;
import org.eclipse.php.internal.ui.util.ListContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class SaveFilesDialog
extends ListSelectionDialog {
    boolean promptAutoSave;
    SaveFilesHandler.SaveFilesResult result;

    public SaveFilesDialog(Shell shell, List list, SaveFilesHandler.SaveFilesResult saveFilesResult, boolean bl) {
        super(shell, (Object)list, (IStructuredContentProvider)new ListContentProvider(), (ILabelProvider)new LabelProvider(){

            public Image getImage(Object object) {
                return ((IEditorPart)object).getTitleImage();
            }

            public String getText(Object object) {
                IEditorPart iEditorPart = (IEditorPart)object;
                IFile iFile = (IFile)iEditorPart.getEditorInput().getAdapter(IResource.class);
                String string = iEditorPart.getTitle();
                if (iFile == null) {
                    return string;
                }
                return MessageFormat.format("{0} [{1}]", string, iFile.getFullPath().toString());
            }
        }, "Save Modified Resources");
        this.promptAutoSave = bl;
        this.result = saveFilesResult;
        this.setTitle("Save Modified Resources");
        this.setMessage("Do you want to save modified resources?");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        if (this.promptAutoSave) {
            final Button button = new Button(composite2, 32);
            button.setText("&Save all modified resources automatically");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SaveFilesDialog.this.result.setAutoSave(button.getSelection());
                }
            });
            SaveFilesDialog.applyDialogFont((Control)composite2);
        }
        return composite2;
    }
}

