/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.projection.IStructuredTextFoldingProvider;

public class DefaultPHPFoldingStructureProvider
implements IProjectionListener,
IStructuredTextFoldingProvider,
ModelListener {
    private static final PHPWorkspaceModelManager workspaceModelManagerInstance = PHPWorkspaceModelManager.getInstance();
    private ProjectionViewer viewer;
    private boolean collapseClasses = false;
    private boolean collapseFunctions = false;
    private boolean collapsePHPDoc = false;
    private boolean allowCollapsing;
    private IModelStateListener modelStateListener;
    private ArrayList toRemove = new ArrayList();
    private Map newFolds = new LinkedHashMap();
    private Timer timer;
    private IDocument document;
    private TimerTask timerTask;
    static int failCount;
    static final int MAX_RETRY = 3;
    static final int THREAD_DELAY = 5000;

    public void projectionEnabled() {
        this.projectionDisabled();
        this.initialize();
        if (this.document != null) {
            IStructuredModel iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.document);
            if (iStructuredModel == null) {
                TimerTask timerTask = new TimerTask(){

                    public void run() {
                        if (failCount++ < 3) {
                            DefaultPHPFoldingStructureProvider.this.projectionEnabled();
                        }
                    }
                };
                Timer timer = new Timer(false);
                timer.schedule(timerTask, 5000L);
                return;
            }
            this.modelStateListener = new PHPModelStateListener();
            iStructuredModel.addModelStateListener(this.modelStateListener);
            iStructuredModel.releaseFromRead();
            failCount = 0;
            this.timer = new Timer(false);
            this.timerTask = new FoldingTimerTask();
        }
    }

    public void projectionDisabled() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
            this.timerTask = null;
        }
        if (this.document != null) {
            IStructuredModel iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.document);
            if (iStructuredModel != null) {
                iStructuredModel.removeModelStateListener(this.modelStateListener);
                iStructuredModel.releaseFromRead();
            }
            this.modelStateListener = null;
            this.document = null;
        }
    }

    public void install(ProjectionViewer projectionViewer) {
        if (this.isInstalled()) {
            this.uninstall();
        }
        this.viewer = projectionViewer;
        projectionViewer.addProjectionListener((IProjectionListener)this);
        workspaceModelManagerInstance.addModelListener((ModelListener)this);
    }

    public void uninstall() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.isInstalled()) {
            this.projectionDisabled();
            this.viewer.removeProjectionListener((IProjectionListener)this);
            workspaceModelManagerInstance.removeModelListener((ModelListener)this);
            this.viewer = null;
        }
    }

    protected boolean isInstalled() {
        return this.viewer != null;
    }

    public void initialize() {
        if (!this.isInstalled()) {
            return;
        }
        this.initializePreferences();
        if (this.viewer.getProjectionAnnotationModel() != null) {
            this.viewer.getProjectionAnnotationModel().removeAllAnnotations();
        }
        this.document = this.viewer.getDocument();
        this.allowCollapsing = true;
        if (this.document != null) {
            this.updateFolds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFolds() {
        block16: {
            IStructuredModel iStructuredModel = null;
            PHPFileData pHPFileData = null;
            try {
                iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.document);
                if (iStructuredModel == null || !(iStructuredModel instanceof DOMModelForPHP)) break block16;
                DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)iStructuredModel;
                pHPFileData = dOMModelForPHP.getFileData();
                if (pHPFileData == null) {
                    return;
                }
                try {
                    workspaceModelManagerInstance.removeModelListener((ModelListener)this);
                    ProjectionAnnotationModel projectionAnnotationModel = this.viewer.getProjectionAnnotationModel();
                    if (projectionAnnotationModel == null) break block16;
                    Object object = projectionAnnotationModel.getLockObject();
                    synchronized (object) {
                        Object object22;
                        Map map = this.computeAdditions(pHPFileData);
                        this.toRemove.clear();
                        this.newFolds.clear();
                        Iterator iterator = projectionAnnotationModel.getAnnotationIterator();
                        LinkedHashMap<Position, ProjectionAnnotation> linkedHashMap = new LinkedHashMap<Position, ProjectionAnnotation>();
                        while (iterator.hasNext()) {
                            ProjectionAnnotation projectionAnnotation = (ProjectionAnnotation)iterator.next();
                            object22 = projectionAnnotationModel.getPosition((Annotation)projectionAnnotation);
                            linkedHashMap.put((Position)object22, projectionAnnotation);
                        }
                        for (Object object22 : map.values()) {
                            if (linkedHashMap.remove(object22) != null) continue;
                            this.newFolds.put(object22.getAnnotation(), object22);
                        }
                        object22 = linkedHashMap.values().iterator();
                        while (object22.hasNext()) {
                            this.toRemove.add(object22.next());
                        }
                        if (this.toRemove.size() > 0 || this.newFolds.size() > 0) {
                            projectionAnnotationModel.replaceAnnotations(this.toRemove.toArray(new Annotation[this.toRemove.size()]), this.newFolds);
                        }
                    }
                }
                catch (ArrayStoreException arrayStoreException) {
                    arrayStoreException.printStackTrace();
                }
            }
            finally {
                if (iStructuredModel != null) {
                    iStructuredModel.releaseFromRead();
                    if (pHPFileData != null) {
                        this.allowCollapsing = false;
                    }
                }
            }
        }
    }

    private void initializePreferences() {
        IPreferenceStore iPreferenceStore = PHPUiPlugin.getDefault().getPreferenceStore();
        this.collapseClasses = iPreferenceStore.getBoolean("foldClasses");
        this.collapseFunctions = iPreferenceStore.getBoolean("foldFunctions");
        this.collapsePHPDoc = iPreferenceStore.getBoolean("foldPHPDoc");
    }

    protected Map computeAdditions(PHPFileData pHPFileData) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        try {
            this.computeClassesAdditions(pHPFileData, linkedHashMap);
            this.computeFunctionsAdditions(pHPFileData, linkedHashMap);
            this.computePHPDocAdditions(pHPFileData, linkedHashMap);
        }
        catch (Exception exception) {}
        return linkedHashMap;
    }

    private void computePHPDocAdditions(PHPFileData pHPFileData, Map map) {
        ArrayList<PHPDocBlock> arrayList = new ArrayList<PHPDocBlock>();
        PHPDocBlock pHPDocBlock = pHPFileData.getDocBlock();
        arrayList.add(pHPDocBlock);
        PHPConstantData[] pHPConstantDataArray = pHPFileData.getConstants();
        int n = 0;
        while (n < pHPConstantDataArray.length) {
            arrayList.add(pHPConstantDataArray[n].getDocBlock());
            ++n;
        }
        PHPFunctionData[] pHPFunctionDataArray = pHPFileData.getFunctions();
        int n2 = 0;
        while (n2 < pHPFunctionDataArray.length) {
            arrayList.add(pHPFunctionDataArray[n2].getDocBlock());
            ++n2;
        }
        PHPClassData[] pHPClassDataArray = pHPFileData.getClasses();
        int n3 = 0;
        while (n3 < pHPClassDataArray.length) {
            arrayList.add(pHPClassDataArray[n3].getDocBlock());
            PHPFunctionData[] pHPFunctionDataArray2 = pHPClassDataArray[n3].getFunctions();
            int n4 = 0;
            while (n4 < pHPFunctionDataArray2.length) {
                arrayList.add(pHPFunctionDataArray2[n4].getDocBlock());
                ++n4;
            }
            PHPClassConstData[] pHPClassConstDataArray = pHPClassDataArray[n3].getConsts();
            int n5 = 0;
            while (n5 < pHPClassConstDataArray.length) {
                arrayList.add(pHPClassConstDataArray[n5].getDocBlock());
                ++n5;
            }
            PHPClassVarData[] pHPClassVarDataArray = pHPClassDataArray[n3].getVars();
            int n6 = 0;
            while (n6 < pHPClassVarDataArray.length) {
                arrayList.add(pHPClassVarDataArray[n6].getDocBlock());
                ++n6;
            }
            ++n3;
        }
        this.addAnnotations(arrayList, map, this.allowCollapsing && this.collapsePHPDoc, true);
    }

    private void computeFunctionsAdditions(PHPFileData pHPFileData, Map map) {
        ArrayList<PHPFunctionData> arrayList = new ArrayList<PHPFunctionData>();
        PHPFunctionData[] pHPFunctionDataArray = pHPFileData.getFunctions();
        int n = 0;
        while (n < pHPFunctionDataArray.length) {
            arrayList.add(pHPFunctionDataArray[n]);
            ++n;
        }
        PHPClassData[] pHPClassDataArray = pHPFileData.getClasses();
        int n2 = 0;
        while (n2 < pHPClassDataArray.length) {
            PHPFunctionData[] pHPFunctionDataArray2 = pHPClassDataArray[n2].getFunctions();
            int n3 = 0;
            while (n3 < pHPFunctionDataArray2.length) {
                arrayList.add(pHPFunctionDataArray2[n3]);
                ++n3;
            }
            ++n2;
        }
        this.addAnnotations(arrayList, map, this.allowCollapsing && this.collapseFunctions, false);
    }

    private void computeClassesAdditions(PHPFileData pHPFileData, Map map) {
        ArrayList<PHPClassData> arrayList = new ArrayList<PHPClassData>();
        PHPClassData[] pHPClassDataArray = pHPFileData.getClasses();
        int n = 0;
        while (n < pHPClassDataArray.length) {
            arrayList.add(pHPClassDataArray[n]);
            ++n;
        }
        this.addAnnotations(arrayList, map, this.allowCollapsing && this.collapseClasses, false);
    }

    private void addAnnotations(ArrayList arrayList, Map map, boolean bl, boolean bl2) {
        int n = 0;
        while (n < arrayList.size()) {
            Object e = arrayList.get(n);
            if (e != null) {
                AnnotatedPosition annotatedPosition = null;
                annotatedPosition = bl2 ? this.createAnnotatedPosition((PHPDocBlock)e) : this.createAnnotatedPosition((PHPCodeData)e);
                if (annotatedPosition != null) {
                    annotatedPosition.setAnnotation(new PHPProjectionAnnotation(e, bl, bl2));
                    map.put(annotatedPosition.getAnnotation(), annotatedPosition);
                }
            }
            ++n;
        }
    }

    private AnnotatedPosition createAnnotatedPosition(PHPCodeData pHPCodeData) {
        if (this.document == null) {
            return null;
        }
        try {
            int n = this.document.getLineOfOffset(pHPCodeData.getUserData().getStopPosition());
            int n2 = this.document.getLineOfOffset(pHPCodeData.getUserData().getEndPosition());
            return this.createAnnotatedPosition(n, n2);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private AnnotatedPosition createAnnotatedPosition(PHPDocBlock pHPDocBlock) {
        if (this.document == null) {
            return null;
        }
        try {
            int n = this.document.getLineOfOffset(pHPDocBlock.getStartPosition());
            int n2 = this.document.getLineOfOffset(pHPDocBlock.getEndPosition() + 1);
            return this.createAnnotatedPosition(n, n2);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private AnnotatedPosition createAnnotatedPosition(int n, int n2) throws BadLocationException {
        if (n != n2) {
            int n3;
            int n4 = this.document.getLineOffset(n);
            if (this.document.getNumberOfLines() > n2 + 1) {
                n3 = this.document.getLineOffset(n2 + 1);
            } else if (n2 > n) {
                n3 = this.document.getLineOffset(n2) + this.document.getLineLength(n2);
            } else {
                return null;
            }
            return new AnnotatedPosition(n4, n3 - n4);
        }
        return null;
    }

    public void dataCleared() {
    }

    public void fileDataAdded(PHPFileData pHPFileData) {
        IStructuredModel iStructuredModel = null;
        try {
            try {
                DOMModelForPHP dOMModelForPHP;
                iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.document);
                if (iStructuredModel != null && iStructuredModel instanceof DOMModelForPHP && (dOMModelForPHP = (DOMModelForPHP)iStructuredModel).getFileData() == pHPFileData) {
                    this.updateFolds();
                }
            }
            catch (Throwable throwable) {
                if (iStructuredModel != null) {
                    iStructuredModel.releaseFromRead();
                }
            }
        }
        finally {
            if (iStructuredModel != null) {
                iStructuredModel.releaseFromRead();
            }
        }
    }

    public void fileDataChanged(PHPFileData pHPFileData) {
    }

    public void fileDataRemoved(PHPFileData pHPFileData) {
    }

    private class AnnotatedPosition
    extends Position {
        private ProjectionAnnotation annotation;

        public AnnotatedPosition(int n, int n2) {
            super(n, n2);
        }

        public AnnotatedPosition(int n, int n2, ProjectionAnnotation projectionAnnotation) {
            super(n, n2);
            this.annotation = projectionAnnotation;
        }

        public ProjectionAnnotation getAnnotation() {
            return this.annotation;
        }

        public void setAnnotation(ProjectionAnnotation projectionAnnotation) {
            this.annotation = projectionAnnotation;
        }

        public String toString() {
            return "[AnnotatedPosition (" + this.getOffset() + ", " + this.getLength() + ")]";
        }
    }

    private class FoldingTimerTask
    extends TimerTask {
        private FoldingTimerTask() {
        }

        public void run() {
            DefaultPHPFoldingStructureProvider.this.updateFolds();
            DefaultPHPFoldingStructureProvider.this.timer.cancel();
        }
    }

    private class PHPModelStateListener
    implements IModelStateListener {
        private PHPModelStateListener() {
        }

        public void modelChanged(IStructuredModel iStructuredModel) {
            if (DefaultPHPFoldingStructureProvider.this.timer != null) {
                DefaultPHPFoldingStructureProvider.this.timer.cancel();
            }
            DefaultPHPFoldingStructureProvider.this.timer = new Timer(false);
            DefaultPHPFoldingStructureProvider.this.timer.schedule((TimerTask)new FoldingTimerTask(), 1000L);
        }

        public void modelAboutToBeChanged(IStructuredModel iStructuredModel) {
        }

        public void modelDirtyStateChanged(IStructuredModel iStructuredModel, boolean bl) {
        }

        public void modelResourceDeleted(IStructuredModel iStructuredModel) {
        }

        public void modelResourceMoved(IStructuredModel iStructuredModel, IStructuredModel iStructuredModel2) {
        }

        public void modelAboutToBeReinitialized(IStructuredModel iStructuredModel) {
        }

        public void modelReinitialized(IStructuredModel iStructuredModel) {
        }
    }

    private static final class PHPProjectionAnnotation
    extends ProjectionAnnotation {
        private Object phpElement;
        private boolean isComment;

        public PHPProjectionAnnotation(Object object, boolean bl, boolean bl2) {
            super(bl);
            this.phpElement = object;
            this.isComment = bl2;
        }

        public Object getElement() {
            return this.phpElement;
        }

        public void setElement(PHPCodeData pHPCodeData) {
            this.phpElement = pHPCodeData;
        }

        public boolean isComment() {
            return this.isComment;
        }

        public void setIsComment(boolean bl) {
            this.isComment = bl;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof PHPProjectionAnnotation) {
                return this.phpElement.equals(((PHPProjectionAnnotation)((Object)object)).phpElement);
            }
            return false;
        }

        public String toString() {
            return "PHPProjectionAnnotation:\n\telement: \t" + this.phpElement.toString() + "\n" + "\tcollapsed: \t" + this.isCollapsed() + "\n" + "\tcomment: \t" + this.isComment + "\n";
        }
    }
}

