/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.php.internal.core.containers.LocalFileStorage;
import org.eclipse.php.internal.core.containers.ZipEntryStorage;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.containers.LocalFileStorageEditorInput;
import org.eclipse.php.internal.ui.containers.ZipEntryStorageEditorInput;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.util.PHPOpenExternalFileAction;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class EditorUtility {
    private static String appendModifierString(String string, int n) {
        if (string == null) {
            string = "";
        }
        String string2 = Action.findModifierString((int)n);
        if (string.length() == 0) {
            return string2;
        }
        return MessageFormat.format(PHPUIMessages.EditorUtility_concatModifierStrings, string, string2);
    }

    private static ZipEntryStorageEditorInput createZipEntryStorageEditorInput(ZipFile zipFile, PHPCodeData pHPCodeData, IProject iProject) {
        ZipEntry zipEntry;
        block5: {
            ZipInputStream zipInputStream = null;
            zipEntry = null;
            File file = new File(zipFile.getName());
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            zipEntry = zipInputStream.getNextEntry();
            PHPFileData pHPFileData = null;
            pHPFileData = pHPCodeData instanceof PHPFileData ? (PHPFileData)pHPCodeData : PHPModelUtil.getPHPFileContainer((PHPCodeData)pHPCodeData);
            String string = pHPFileData.getName();
            string = string.substring(string.indexOf(File.separatorChar) + 1);
            while (zipEntry != null && !zipEntry.getName().equals(string)) {
                zipEntry = zipInputStream.getNextEntry();
            }
            if (zipEntry != null) break block5;
            return null;
        }
        try {
            ZipEntryStorage zipEntryStorage = new ZipEntryStorage(zipFile, zipEntry);
            zipEntryStorage.setProject(iProject);
            return new ZipEntryStorageEditorInput(zipEntryStorage);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.logException(fileNotFoundException);
            return null;
        }
        catch (IOException iOException) {
            Logger.logException(iOException);
            return null;
        }
    }

    public static int findLocalizedModifier(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    public static PHPCodeData getActiveEditorPHPInput() {
        IEditorInput iEditorInput;
        IEditorPart iEditorPart;
        IWorkbenchPage iWorkbenchPage = PHPUiPlugin.getActivePage();
        if (iWorkbenchPage != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) != null && (iEditorInput = iEditorPart.getEditorInput()) != null) {
            return (PHPCodeData)iEditorInput.getAdapter(PHPCodeData.class);
        }
        return null;
    }

    private static IContentType getContentType(File file) {
        if (file == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            IContentType iContentType = Platform.getContentTypeManager().findContentTypeFor((InputStream)fileInputStream, file.getName());
            return iContentType;
        }
        catch (IOException iOException) {
            Logger.logException(iOException);
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (IOException iOException) {
                Logger.logException(iOException);
            }
        }
    }

    private static String getEditorId(File file) {
        IWorkbench iWorkbench = PHPUiPlugin.getDefault().getWorkbench();
        IEditorRegistry iEditorRegistry = iWorkbench.getEditorRegistry();
        IEditorDescriptor iEditorDescriptor = iEditorRegistry.getDefaultEditor(file.getName(), EditorUtility.getContentType(file));
        if (iEditorDescriptor != null) {
            return iEditorDescriptor.getId();
        }
        return null;
    }

    public static String getEditorID(IEditorInput iEditorInput) {
        IEditorDescriptor iEditorDescriptor;
        try {
            String string;
            File file;
            LocalFileStorageEditorInput localFileStorageEditorInput;
            LocalFileStorage localFileStorage;
            if (iEditorInput instanceof LocalFileStorageEditorInput && (localFileStorage = (LocalFileStorage)(localFileStorageEditorInput = (LocalFileStorageEditorInput)iEditorInput).getStorage()) != null && (file = localFileStorage.getFile()) != null && (string = EditorUtility.getEditorId(file)) != null) {
                return string;
            }
            iEditorDescriptor = IDE.getEditorDescriptor((String)iEditorInput.getName());
        }
        catch (PartInitException partInitException) {
            return null;
        }
        if (iEditorDescriptor != null) {
            return iEditorDescriptor.getId();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object object) {
        if (object instanceof TreeItem) {
            IProject iProject = EditorUtility.getProject((TreeItem)object);
            String string = EditorUtility.getIncludeDirectory((TreeItem)object);
            return EditorUtility.getEditorInput((PHPCodeData)((TreeItem)object).getData(), iProject, string);
        }
        if (object instanceof PHPCodeData) {
            return EditorUtility.getEditorInput((PHPCodeData)object, null, null);
        }
        if (object instanceof IFile) {
            return new FileEditorInput((IFile)object);
        }
        if (object instanceof IEditorInput) {
            return (IEditorInput)object;
        }
        return null;
    }

    private static IEditorInput getEditorInput(PHPCodeData pHPCodeData, IProject iProject, String string) {
        IResource iResource = PHPModelUtil.getResource((Object)pHPCodeData);
        if (iResource == null || !iResource.exists() || !iResource.getProject().equals((Object)iProject)) {
            Object object = PHPModelUtil.getExternalResource((Object)pHPCodeData, (IProject)iProject);
            if (object instanceof File) {
                File file = (File)object;
                Path path = new Path(file.getPath());
                if (ExternalFilesRegistry.getInstance().isEntryExist(path.toString())) {
                    return new FileStoreEditorInput((IFileStore)new LocalFile(file));
                }
                LocalFileStorage localFileStorage = new LocalFileStorage((File)object);
                localFileStorage.setProject(iProject);
                localFileStorage.setIncBaseDirName(string);
                return new LocalFileStorageEditorInput(localFileStorage);
            }
            if (object instanceof ZipFile) {
                return EditorUtility.createZipEntryStorageEditorInput((ZipFile)object, pHPCodeData, iProject);
            }
        }
        if (iResource instanceof IFile) {
            return new FileEditorInput((IFile)iResource);
        }
        return null;
    }

    private static String getIncludeDirectory(TreeItem treeItem) {
        if (!(treeItem.getData() instanceof PHPCodeData)) {
            return null;
        }
        PHPCodeData pHPCodeData = (PHPCodeData)treeItem.getData();
        while (pHPCodeData != null && !(pHPCodeData instanceof PHPFileData)) {
            pHPCodeData = pHPCodeData.getContainer();
            treeItem = treeItem.getParentItem();
        }
        while (treeItem != null && !(treeItem.getData() instanceof PHPIncludePathModel)) {
            treeItem = treeItem.getParentItem();
        }
        if (treeItem == null) {
            return null;
        }
        PHPIncludePathModel pHPIncludePathModel = (PHPIncludePathModel)treeItem.getData();
        if (pHPIncludePathModel.getType() == 1) {
            IPath iPath = IncludePathVariableManager.instance().getIncludePathVariable(pHPIncludePathModel.getID());
            return iPath.toOSString();
        }
        return new Path(pHPIncludePathModel.getID()).toOSString();
    }

    public static String getModifierString(int n) {
        String string = "";
        if ((n & 0x40000) == 262144) {
            string = EditorUtility.appendModifierString(string, 262144);
        }
        if ((n & 0x10000) == 65536) {
            string = EditorUtility.appendModifierString(string, 65536);
        }
        if ((n & 0x20000) == 131072) {
            string = EditorUtility.appendModifierString(string, 131072);
        }
        if ((n & 0x400000) == 0x400000) {
            string = EditorUtility.appendModifierString(string, 0x400000);
        }
        return string;
    }

    public static PHPProjectModel getPHPProject(IEditorInput iEditorInput) {
        IProject iProject;
        if (iEditorInput instanceof IFileEditorInput && (iProject = ((IFileEditorInput)iEditorInput).getFile().getProject()) != null) {
            return PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
        }
        return null;
    }

    private static IProject getProject(TreeItem treeItem) {
        if (!(treeItem.getData() instanceof PHPCodeData)) {
            return null;
        }
        PHPCodeData pHPCodeData = (PHPCodeData)treeItem.getData();
        while (pHPCodeData != null && !(pHPCodeData instanceof PHPFileData)) {
            pHPCodeData = pHPCodeData.getContainer();
            treeItem = treeItem.getParentItem();
        }
        while (treeItem != null && !(treeItem.getData() instanceof IProject)) {
            treeItem = treeItem.getParentItem();
        }
        if (treeItem == null) {
            return null;
        }
        return (IProject)treeItem.getData();
    }

    private static void initializeHighlightRange(IEditorPart iEditorPart) {
        if (iEditorPart instanceof ITextEditor) {
            IAction iAction = iEditorPart.getEditorSite().getActionBars().getGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly");
            boolean bl = iAction != null;
            boolean bl2 = bl = bl && iAction.isEnabled() && iAction.isChecked();
            if (bl) {
                if (iAction instanceof TextEditorAction) {
                    ((TextEditorAction)iAction).setEditor(null);
                    ((TextEditorAction)iAction).setEditor((ITextEditor)iEditorPart);
                } else {
                    iAction.run();
                    iAction.run();
                }
            }
        }
    }

    public static boolean isEditorInput(Object object, IEditorPart iEditorPart) {
        if (iEditorPart != null) {
            return iEditorPart.getEditorInput().equals(EditorUtility.getEditorInput(object));
        }
        return false;
    }

    public static IEditorPart isOpenInEditor(Object object) {
        IWorkbenchPage iWorkbenchPage;
        IEditorInput iEditorInput = null;
        iEditorInput = EditorUtility.getEditorInput(object);
        if (iEditorInput != null && (iWorkbenchPage = PHPUiPlugin.getActivePage()) != null) {
            return iWorkbenchPage.findEditor(iEditorInput);
        }
        return null;
    }

    public static IEditorPart openInEditor(IEditorInput iEditorInput, String string, boolean bl) throws PartInitException {
        IWorkbenchPage iWorkbenchPage;
        if (iEditorInput != null && (iWorkbenchPage = PHPUiPlugin.getActivePage()) != null) {
            IEditorPart iEditorPart = iWorkbenchPage.openEditor(iEditorInput, string, bl);
            EditorUtility.initializeHighlightRange(iEditorPart);
            return iEditorPart;
        }
        return null;
    }

    public static IEditorPart openInEditor(IFile iFile, boolean bl) throws PartInitException {
        IWorkbenchPage iWorkbenchPage;
        if (iFile != null && (iWorkbenchPage = PHPUiPlugin.getActivePage()) != null) {
            IEditorPart iEditorPart = IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)bl);
            EditorUtility.initializeHighlightRange(iEditorPart);
            return iEditorPart;
        }
        return null;
    }

    public static IEditorPart openInEditor(Object object) throws PartInitException {
        return EditorUtility.openInEditor(object, true);
    }

    public static IEditorPart openInEditor(Object object, boolean bl) throws PartInitException {
        if (object instanceof IFile) {
            return EditorUtility.openInEditor((IFile)object, bl);
        }
        IEditorInput iEditorInput = EditorUtility.getEditorInput(object);
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            return EditorUtility.openInEditor(iFileEditorInput.getFile(), bl);
        }
        if (iEditorInput != null) {
            return EditorUtility.openInEditor(iEditorInput, EditorUtility.getEditorID(iEditorInput), bl);
        }
        return null;
    }

    public static IEditorPart openInEditor(String string, int n) throws CoreException {
        IProject[] iProjectArray;
        Path path;
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
        IFile iFile = iWorkspaceRoot.getFileForLocation((IPath)(path = new Path(string)));
        if (iFile == null) {
            if (path.segmentCount() < 2) {
                return null;
            }
            iFile = iWorkspaceRoot.getFile((IPath)path);
            if (iFile == null) {
                iProjectArray = iWorkspaceRoot.getProjects();
                int n2 = 0;
                while (n2 < iProjectArray.length) {
                    if (iProjectArray[n2].isOpen() && (iFile = iProjectArray[n2].getFile((IPath)path)) != null) break;
                    ++n2;
                }
            }
        }
        if (iFile == null || !iFile.exists()) {
            return null;
        }
        iProjectArray = iFile.createMarker("org.eclipse.core.resources.textmarker");
        iProjectArray.setAttribute("lineNumber", n);
        IWorkbenchPage iWorkbenchPage = PHPUiPlugin.getActivePage();
        IEditorPart iEditorPart = null;
        if (iWorkbenchPage != null) {
            iEditorPart = IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IMarker)iProjectArray);
        }
        iProjectArray.delete();
        return iEditorPart;
    }

    public static void revealInEditor(IEditorPart iEditorPart, final int n, final int n2) {
        if (iEditorPart instanceof ITextEditor) {
            ((ITextEditor)iEditorPart).selectAndReveal(n, n2);
            return;
        }
        if (iEditorPart instanceof IGotoMarker) {
            final IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (iEditorInput instanceof IFileEditorInput) {
                final IGotoMarker iGotoMarker = (IGotoMarker)iEditorPart;
                WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                        IMarker iMarker = null;
                        try {
                            iMarker = ((IFileEditorInput)iEditorInput).getFile().createMarker("org.eclipse.core.resources.textmarker");
                            iMarker.setAttribute("charStart", n);
                            iMarker.setAttribute("charEnd", n + n2);
                            iGotoMarker.gotoMarker(iMarker);
                        }
                        finally {
                            if (iMarker != null) {
                                iMarker.delete();
                            }
                        }
                    }
                };
                try {
                    workspaceModifyOperation.run(null);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    Assert.isTrue((boolean)false, (String)"this operation can not be canceled");
                }
            }
            return;
        }
        if (iEditorPart != null && iEditorPart.getEditorSite().getSelectionProvider() != null) {
            IEditorSite iEditorSite = iEditorPart.getEditorSite();
            if (iEditorSite == null) {
                return;
            }
            ISelectionProvider iSelectionProvider = iEditorPart.getEditorSite().getSelectionProvider();
            if (iSelectionProvider == null) {
                return;
            }
            iSelectionProvider.setSelection((ISelection)new TextSelection(n, n2));
        }
    }

    public static void revealInEditor(IEditorPart iEditorPart, IRegion iRegion) {
        if (iEditorPart != null && iRegion != null) {
            EditorUtility.revealInEditor(iEditorPart, iRegion.getOffset(), iRegion.getLength());
        }
    }

    public static void revealInEditor(IEditorPart iEditorPart, PHPCodeData pHPCodeData) {
        if (pHPCodeData == null) {
            return;
        }
        PHPStructuredEditor pHPStructuredEditor = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)iEditorPart);
        if (pHPStructuredEditor != null) {
            pHPStructuredEditor.setSelection(pHPCodeData, true);
            return;
        }
        int n = -1;
        int n2 = 0;
        UserData userData = pHPCodeData.getUserData();
        if (userData != null) {
            n = userData.getStartPosition();
            n2 = userData.getEndPosition() - userData.getStartPosition() + 1;
        }
        if (n >= 0) {
            EditorUtility.revealInEditor(iEditorPart, n, n2);
        }
    }

    public static final PHPStructuredEditor getPHPStructuredEditor(IWorkbenchPart iWorkbenchPart) {
        return iWorkbenchPart != null ? (PHPStructuredEditor)((Object)iWorkbenchPart.getAdapter(PHPStructuredEditor.class)) : null;
    }

    public static final PHPStructuredEditor getPHPStructuredEditor(ITextViewer iTextViewer) {
        IEditorReference[] iEditorReferenceArray;
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
        if (iEditorPart instanceof PHPStructuredEditor && (iEditorReferenceArray = (IEditorReference[])iEditorPart).getTextViewer().getDocument() == iTextViewer.getDocument()) {
            return iEditorReferenceArray;
        }
        iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            PHPStructuredEditor pHPStructuredEditor;
            IEditorReference iEditorReference = iEditorReferenceArray[n];
            IEditorPart iEditorPart2 = iEditorReference.getEditor(false);
            if (iEditorPart2 instanceof PHPStructuredEditor && (pHPStructuredEditor = (PHPStructuredEditor)iEditorPart2).getTextViewer().getDocument() == iTextViewer.getDocument()) {
                return pHPStructuredEditor;
            }
            ++n;
        }
        return null;
    }

    public static void openFilesInEditor(List list, IWorkbenchWindow iWorkbenchWindow) {
        PHPOpenExternalFileAction pHPOpenExternalFileAction = new PHPOpenExternalFileAction();
        pHPOpenExternalFileAction.init(iWorkbenchWindow);
        pHPOpenExternalFileAction.run(list);
    }

    public static void openFilesInEditor(List list) {
        EditorUtility.openFilesInEditor(list, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }
}

