/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.editor;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentDescriptionProvider;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager2;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObject;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IField;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddXSDComplexTypeDefinitionCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddXSDSimpleTypeDefinitionCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateTypeReferenceAndManageDirectivesCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateTypeReferenceCommand;
import org.eclipse.wst.xsd.ui.internal.dialogs.NewTypeDialog;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.search.XSDSearchListDialogDelegate;
import org.eclipse.wst.xsd.ui.internal.search.IXSDSearchConstants;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDSchemaBuildingTools;

public class XSDTypeReferenceEditManager
implements ComponentReferenceEditManager,
ComponentReferenceEditManager2 {
    protected IFile currentFile;
    protected XSDSchema[] schemas;
    private static ComponentSpecification[] result;
    private IADTObject referencer;

    public XSDTypeReferenceEditManager(IFile currentFile, XSDSchema[] schemas) {
        this.currentFile = currentFile;
        this.schemas = schemas;
    }

    public void addToHistory(ComponentSpecification component) {
    }

    public IADTObject getReferencer() {
        return this.referencer;
    }

    public void setReferencer(IADTObject referencer) {
        this.referencer = referencer;
    }

    public IComponentDialog getBrowseDialog() {
        XSDSearchListDialogDelegate dialogDelegate = new XSDSearchListDialogDelegate(XSDSearchListDialogDelegate.TYPE_META_NAME, this.currentFile, this.schemas);
        return dialogDelegate;
    }

    public IComponentDescriptionProvider getComponentDescriptionProvider() {
        return null;
    }

    public ComponentSpecification[] getHistory() {
        ArrayList list = new ArrayList();
        ComponentSpecification[] result = new ComponentSpecification[list.size()];
        list.toArray(result);
        return result;
    }

    public IComponentDialog getNewDialog() {
        NewTypeDialog result = null;
        result = this.schemas.length > 0 ? new NewTypeDialog(this.schemas[0]) : new NewTypeDialog();
        if (this.referencer instanceof IField) {
            String fieldName;
            IField field = (IField)this.referencer;
            if ("attribute".equals(field.getKind())) {
                result.allowComplexType(false);
            }
            if ((fieldName = field.getName()) != null && (fieldName = fieldName.trim()).length() > 0) {
                result.setDefaultName(NLS.bind((String)Messages._UI_VALUE_NEW_TYPE, (Object)fieldName));
            }
        }
        return result;
    }

    public ComponentSpecification[] getQuickPicks() {
        if (result != null) {
            return result;
        }
        ArrayList<ComponentSpecification> list = new ArrayList<ComponentSpecification>();
        list.add(new ComponentSpecification("http://www.w3.org/2001/XMLSchema", "boolean", null));
        list.add(new ComponentSpecification("http://www.w3.org/2001/XMLSchema", "date", null));
        list.add(new ComponentSpecification("http://www.w3.org/2001/XMLSchema", "dateTime", null));
        list.add(new ComponentSpecification("http://www.w3.org/2001/XMLSchema", "double", null));
        list.add(new ComponentSpecification("http://www.w3.org/2001/XMLSchema", "float", null));
        list.add(new ComponentSpecification("http://www.w3.org/2001/XMLSchema", "hexBinary", null));
        list.add(new ComponentSpecification("http://www.w3.org/2001/XMLSchema", "int", null));
        list.add(new ComponentSpecification("http://www.w3.org/2001/XMLSchema", "string", null));
        list.add(new ComponentSpecification("http://www.w3.org/2001/XMLSchema", "time", null));
        result = new ComponentSpecification[list.size()];
        list.toArray(result);
        return result;
    }

    public void modifyComponentReference(Object referencingObject, ComponentSpecification component) {
        XSDConcreteComponent concreteComponent = null;
        if (referencingObject instanceof Adapter) {
            Adapter adpater = (Adapter)referencingObject;
            if (adpater.getTarget() instanceof XSDConcreteComponent) {
                concreteComponent = (XSDConcreteComponent)adpater.getTarget();
            }
        } else if (referencingObject instanceof XSDConcreteComponent) {
            concreteComponent = (XSDConcreteComponent)referencingObject;
        }
        if (concreteComponent != null) {
            if (component.isNew()) {
                BaseCommand command;
                XSDComplexTypeDefinition td = null;
                if (component.getName() == null && concreteComponent instanceof XSDElementDeclaration) {
                    XSDFactory factory = XSDSchemaBuildingTools.getXSDFactory();
                    XSDElementDeclaration elementDeclaration = (XSDElementDeclaration)concreteComponent;
                    if (component.getMetaName() == IXSDSearchConstants.COMPLEX_TYPE_META_NAME) {
                        XSDComplexTypeDefinition complexType = factory.createXSDComplexTypeDefinition();
                        elementDeclaration.setAnonymousTypeDefinition((XSDTypeDefinition)complexType);
                    } else {
                        XSDSimpleTypeDefinition simpleType = factory.createXSDSimpleTypeDefinition();
                        simpleType.setBaseTypeDefinition(elementDeclaration.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", "string"));
                        elementDeclaration.setAnonymousTypeDefinition((XSDTypeDefinition)simpleType);
                    }
                    elementDeclaration.getElement().removeAttribute("type");
                } else if (component.getMetaName() == IXSDSearchConstants.COMPLEX_TYPE_META_NAME) {
                    command = new AddXSDComplexTypeDefinitionCommand(Messages._UI_ACTION_ADD_COMPLEX_TYPE, (XSDConcreteComponent)concreteComponent.getSchema());
                    ((AddXSDComplexTypeDefinitionCommand)command).setNameToAdd(component.getName());
                    ((AddXSDComplexTypeDefinitionCommand)command).execute();
                    td = ((AddXSDComplexTypeDefinitionCommand)command).getCreatedComplexType();
                } else {
                    command = new AddXSDSimpleTypeDefinitionCommand(Messages._UI_ACTION_ADD_SIMPLE_TYPE, (XSDConcreteComponent)concreteComponent.getSchema());
                    ((AddXSDSimpleTypeDefinitionCommand)command).setNameToAdd(component.getName());
                    ((AddXSDSimpleTypeDefinitionCommand)command).execute();
                    td = ((AddXSDSimpleTypeDefinitionCommand)command).getCreatedSimpleType();
                }
                if (td != null) {
                    command = new UpdateTypeReferenceCommand(concreteComponent, (XSDTypeDefinition)td);
                    command.setLabel(Messages._UI_ACTION_SET_TYPE);
                    command.execute();
                }
            } else {
                UpdateTypeReferenceAndManageDirectivesCommand command = new UpdateTypeReferenceAndManageDirectivesCommand(concreteComponent, component.getName(), component.getQualifier(), component.getFile());
                command.setLabel(Messages._UI_ACTION_SET_TYPE);
                command.execute();
            }
        }
    }
}

