/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;
import org.eclipse.datatools.connectivity.oda.flatfile.util.querytextutil.ColumnsInfoUtil;

public class ResultSetMetaDataHelper {
    String savedSelectedColumnsInfoString;
    String[] columnNames;
    String[] columnTypes;
    String[] originalColumnNames;
    String[] columnLabels;

    ResultSetMetaDataHelper(String[] colNames, String[] colTypes, String[] colLabels) throws OdaException {
        if (colNames == null) {
            throw new OdaException(Messages.getString("common_ARGUMENT_CANNOT_BE_NULL"));
        }
        this.columnNames = colNames;
        this.columnTypes = colTypes;
        this.columnLabels = colLabels;
        this.originalColumnNames = colNames;
    }

    ResultSetMetaDataHelper(String savedSelectedColumnsInfoString) {
        this.savedSelectedColumnsInfoString = savedSelectedColumnsInfoString;
        this.columnNames = ColumnsInfoUtil.getColumnNames(savedSelectedColumnsInfoString);
        this.columnTypes = ColumnsInfoUtil.getColumnTypeNames(savedSelectedColumnsInfoString);
        this.originalColumnNames = ColumnsInfoUtil.getOriginalColumnNames(savedSelectedColumnsInfoString);
        this.columnLabels = this.columnLabels == null ? this.columnNames : this.columnLabels;
    }

    String[] getColumnNames() {
        return this.columnNames;
    }

    String[] getColumnTypes() {
        return this.columnTypes;
    }

    String[] getColumnLabels() {
        return this.columnLabels;
    }

    public String[] getOriginalColumnNames() {
        return this.originalColumnNames;
    }

    public String getOriginalColumnName(String columnName) {
        String originName = null;
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (!columnName.equals(this.columnNames[i])) continue;
            originName = this.originalColumnNames[i];
        }
        return originName;
    }
}

