/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.orm;

import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.content.orm.OrmFactory;
import org.eclipse.jpt.core.internal.content.orm.OrmPackage;
import org.eclipse.jpt.core.internal.content.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.internal.content.orm.XmlTypeMapping;
import org.eclipse.jpt.core.internal.jdtutility.JDTTools;
import org.eclipse.jpt.core.internal.mappings.ICascade;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.IRelationshipMapping;
import org.eclipse.jpt.core.internal.mappings.RelationshipMappingTools;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlRelationshipMapping
extends XmlAttributeMapping
implements IRelationshipMapping {
    protected static final String TARGET_ENTITY_EDEFAULT = null;
    protected static final String SPECIFIED_TARGET_ENTITY_EDEFAULT = null;
    protected String specifiedTargetEntity = SPECIFIED_TARGET_ENTITY_EDEFAULT;
    protected static final String DEFAULT_TARGET_ENTITY_EDEFAULT = null;
    protected String defaultTargetEntity = DEFAULT_TARGET_ENTITY_EDEFAULT;
    protected IEntity resolvedTargetEntity;
    protected ICascade cascade;

    protected XmlRelationshipMapping() {
    }

    @Override
    protected EClass eStaticClass() {
        return OrmPackage.Literals.XML_RELATIONSHIP_MAPPING;
    }

    @Override
    public String getTargetEntity() {
        return this.getSpecifiedTargetEntity() == null ? this.getDefaultTargetEntity() : this.getSpecifiedTargetEntity();
    }

    @Override
    public String getSpecifiedTargetEntity() {
        return this.specifiedTargetEntity;
    }

    @Override
    public void setSpecifiedTargetEntity(String newSpecifiedTargetEntity) {
        String oldSpecifiedTargetEntity = this.specifiedTargetEntity;
        this.specifiedTargetEntity = newSpecifiedTargetEntity;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldSpecifiedTargetEntity, (Object)this.specifiedTargetEntity));
        }
    }

    @Override
    public String getDefaultTargetEntity() {
        return this.defaultTargetEntity;
    }

    @Override
    public IEntity getResolvedTargetEntity() {
        if (this.resolvedTargetEntity != null && this.resolvedTargetEntity.eIsProxy()) {
            InternalEObject oldResolvedTargetEntity = (InternalEObject)this.resolvedTargetEntity;
            this.resolvedTargetEntity = (IEntity)this.eResolveProxy(oldResolvedTargetEntity);
            if (this.resolvedTargetEntity != oldResolvedTargetEntity && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldResolvedTargetEntity, (Object)this.resolvedTargetEntity));
            }
        }
        return this.resolvedTargetEntity;
    }

    public IEntity basicGetResolvedTargetEntity() {
        return this.resolvedTargetEntity;
    }

    @Override
    public void setResolvedTargetEntity(IEntity newResolvedTargetEntity) {
        IEntity oldResolvedTargetEntity = this.resolvedTargetEntity;
        this.resolvedTargetEntity = newResolvedTargetEntity;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldResolvedTargetEntity, (Object)this.resolvedTargetEntity));
        }
    }

    @Override
    public ICascade getCascade() {
        return this.cascade;
    }

    @Override
    public ICascade createCascade() {
        return OrmFactory.eINSTANCE.createXmlCascade();
    }

    public NotificationChain basicSetCascade(ICascade newCascade, NotificationChain msgs) {
        ICascade oldCascade = this.cascade;
        this.cascade = newCascade;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldCascade, (Object)newCascade);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setCascade(ICascade newCascade) {
        if (newCascade != this.cascade) {
            NotificationChain msgs = null;
            if (this.cascade != null) {
                msgs = ((InternalEObject)this.cascade).eInverseRemove((InternalEObject)this, -6, null, msgs);
            }
            if (newCascade != null) {
                msgs = ((InternalEObject)newCascade).eInverseAdd((InternalEObject)this, -6, null, msgs);
            }
            if ((msgs = this.basicSetCascade(newCascade, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)newCascade, (Object)newCascade));
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return this.basicSetCascade(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    protected void setDefaultTargetEntity(String newDefaultTargetEntity) {
        String oldDefaultTargetEntity = this.defaultTargetEntity;
        this.defaultTargetEntity = newDefaultTargetEntity;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldDefaultTargetEntity, (Object)this.defaultTargetEntity));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getTargetEntity();
            }
            case 2: {
                return this.getSpecifiedTargetEntity();
            }
            case 3: {
                return this.getDefaultTargetEntity();
            }
            case 4: {
                if (resolve) {
                    return this.getResolvedTargetEntity();
                }
                return this.basicGetResolvedTargetEntity();
            }
            case 5: {
                return this.getCascade();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setSpecifiedTargetEntity((String)newValue);
                return;
            }
            case 4: {
                this.setResolvedTargetEntity((IEntity)newValue);
                return;
            }
            case 5: {
                this.setCascade((ICascade)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setSpecifiedTargetEntity(SPECIFIED_TARGET_ENTITY_EDEFAULT);
                return;
            }
            case 4: {
                this.setResolvedTargetEntity(null);
                return;
            }
            case 5: {
                this.setCascade(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return TARGET_ENTITY_EDEFAULT == null ? this.getTargetEntity() != null : !TARGET_ENTITY_EDEFAULT.equals(this.getTargetEntity());
            }
            case 2: {
                return SPECIFIED_TARGET_ENTITY_EDEFAULT == null ? this.specifiedTargetEntity != null : !SPECIFIED_TARGET_ENTITY_EDEFAULT.equals(this.specifiedTargetEntity);
            }
            case 3: {
                return DEFAULT_TARGET_ENTITY_EDEFAULT == null ? this.defaultTargetEntity != null : !DEFAULT_TARGET_ENTITY_EDEFAULT.equals(this.defaultTargetEntity);
            }
            case 4: {
                return this.resolvedTargetEntity != null;
            }
            case 5: {
                return this.cascade != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IRelationshipMapping.class) {
            switch (derivedFeatureID) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
                case 5: {
                    return 4;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IRelationshipMapping.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    return 4;
                }
                case 4: {
                    return 5;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (specifiedTargetEntity: ");
        result.append(this.specifiedTargetEntity);
        result.append(", defaultTargetEntity: ");
        result.append(this.defaultTargetEntity);
        result.append(')');
        return result.toString();
    }

    @Override
    public void initializeFromXmlRelationshipMapping(XmlRelationshipMapping oldMapping) {
        super.initializeFromXmlRelationshipMapping(oldMapping);
        this.setSpecifiedTargetEntity(oldMapping.getSpecifiedTargetEntity());
    }

    @Override
    public boolean targetEntityIsValid(String targetEntity) {
        return RelationshipMappingTools.targetEntityIsValid(targetEntity);
    }

    @Override
    public IEntity getEntity() {
        XmlTypeMapping typeMapping = this.getPersistentType().getMapping();
        if (typeMapping instanceof IEntity) {
            return (IEntity)((Object)typeMapping);
        }
        return null;
    }

    @Override
    public String fullyQualifiedTargetEntity() {
        if (this.getTargetEntity() == null) {
            return null;
        }
        if (this.targetEntityIncludesPackage()) {
            return this.getTargetEntity();
        }
        String package_ = this.getPersistentType().getMapping().getEntityMappings().getPackage();
        if (package_ != null) {
            return String.valueOf(package_) + '.' + this.getTargetEntity();
        }
        return this.getTargetEntity();
    }

    private boolean targetEntityIncludesPackage() {
        return this.getTargetEntity().lastIndexOf(46) != -1;
    }

    public Iterator<String> allTargetEntityAttributeNames() {
        IEntity targetEntity = this.getResolvedTargetEntity();
        return targetEntity == null ? EmptyIterator.instance() : targetEntity.getPersistentType().allAttributeNames();
    }

    public Iterator<String> candidateMappedByAttributeNames() {
        return this.allTargetEntityAttributeNames();
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        IPersistentType persistentType;
        super.refreshDefaults(defaultsContext);
        this.setDefaultTargetEntity((String)defaultsContext.getDefault("oneToMany.targetEntity"));
        String targetEntity = this.fullyQualifiedTargetEntity();
        if (targetEntity != null && (persistentType = defaultsContext.persistentType(targetEntity)) != null && persistentType.getMapping() instanceof IEntity) {
            this.setResolvedTargetEntity((IEntity)persistentType.getMapping());
            return;
        }
        this.setResolvedTargetEntity(null);
    }

    public String javaDefaultTargetEntity() {
        return this.javaDefaultTargetEntity(this.getPersistentAttribute().getAttribute().typeSignature());
    }

    protected String javaDefaultTargetEntity(String signature) {
        IType iType = this.getPersistentType().findJdtType();
        if (iType != null) {
            return XmlRelationshipMapping.buildReferenceEntityTypeName(signature, iType);
        }
        return null;
    }

    public static String buildReferenceEntityTypeName(String signature, IType jdtType) {
        if (Signature.getArrayCount((String)signature) > 0) {
            return null;
        }
        return JDTTools.resolve(Signature.toString((String)signature), jdtType);
    }
}

