/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.routineeditor.IRoutineEditorDocumentProvider;
import org.eclipse.datatools.sqltools.routineeditor.ProcEditorInput;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorImages;
import org.eclipse.datatools.sqltools.routineeditor.ui.actions.Messages;
import org.eclipse.datatools.sqltools.sqleditor.IPageUpdate;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class RefreshFromDatabaseAction
extends TextEditorAction
implements IPageUpdate {
    SQLEditor _sqlEditor;
    private boolean _isSourcePage = true;

    public RefreshFromDatabaseAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        this._sqlEditor = (SQLEditor)editor;
        this.setImageDescriptor(RoutineEditorImages.getImageDescriptor("refresh_from_database"));
        this.setActionDefinitionId("org.eclipse.datatools.sqltools.sqleditor.refreshFromDatabaseAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.datatools.sqltools.sqleditor.refresh_from_database_action");
    }

    public void run() {
        try {
            IRoutineEditorDocumentProvider sqlEditorDocumentProvider = null;
            if (this._sqlEditor.getParentEditor() != null) {
                sqlEditorDocumentProvider = (IRoutineEditorDocumentProvider)this._sqlEditor.getParentEditor().getAdapter(IRoutineEditorDocumentProvider.class);
            }
            if (sqlEditorDocumentProvider == null) {
                sqlEditorDocumentProvider = (IRoutineEditorDocumentProvider)this._sqlEditor.getDocumentProvider();
            }
            ProcIdentifier procIdentifier = ((ProcEditorInput)this._sqlEditor.getEditorInput()).getProcIdentifier();
            IControlConnection controlConnection = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(procIdentifier.getDatabaseIdentifier());
            sqlEditorDocumentProvider.refreshFromDatabase(this._sqlEditor.getEditorInput(), controlConnection, procIdentifier);
            ((WorkbenchWindow)SQLEditorPlugin.getActiveWorkbenchWindow()).getStatusLineManager().setMessage(Messages.RefreshFromDatabase_success);
        }
        catch (Exception e) {
            try {
                throw new CoreException((IStatus)new Status(4, RoutineEditorActivator.PLUGIN_ID, 0, NLS.bind((String)Messages.RefreshFromDatabase_fail, (Object[])new Object[]{e.toString()}), (Throwable)e));
            }
            catch (CoreException e1) {
                RoutineEditorActivator.getDefault().log(e1);
            }
        }
    }

    public void update() {
        this._sqlEditor = (SQLEditor)this.getTextEditor();
        if (this._sqlEditor.getEditorInput() instanceof ProcEditorInput) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void update(boolean isSQLEditorPage) {
        this._isSourcePage = isSQLEditorPage;
        this.update();
    }
}

