/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.base.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SQLScriptsProvider;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDatabase;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.impl.SybaseASABaseUniqueConstraintImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASACatalogBaseUniqueConstraint
extends SybaseASABaseUniqueConstraintImpl
implements ICatalogObject {
    private static final long serialVersionUID = 9022615295148300491L;
    protected Boolean UCInfoLoaded = Boolean.FALSE;

    public Database getCatalogDatabase() {
        return this.getBaseTable().getSchema().getDatabase();
    }

    public Connection getConnection() {
        return ((ICatalogObject)this.getCatalogDatabase()).getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.UCInfoLoaded;
        synchronized (bl) {
            if (this.UCInfoLoaded.booleanValue()) {
                this.UCInfoLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 11: {
                this.getMembers();
                break;
            }
            case 13: {
                this.isClustered();
            }
        }
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getMembers() {
        Boolean bl = this.UCInfoLoaded;
        synchronized (bl) {
            if (!this.UCInfoLoaded.booleanValue()) {
                this.loadUCInfo();
                this.UCInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getMembers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClustered() {
        Boolean bl = this.UCInfoLoaded;
        synchronized (bl) {
            if (!this.UCInfoLoaded.booleanValue()) {
                this.loadUCInfo();
                this.UCInfoLoaded = Boolean.TRUE;
            }
        }
        return super.isClustered();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadUCInfo() {
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        SybaseASABaseDatabase db = (SybaseASABaseDatabase)this.getCatalogDatabase();
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                BaseTable table = this.getBaseTable();
                String schemaName = table.getSchema().getName();
                String tableName = table.getName();
                stmt = conn.prepareStatement(SQLScriptsProvider.getQueryUnqiueConstraintInfo((Database)db));
                stmt.setString(1, schemaName);
                stmt.setString(2, tableName);
                stmt.setString(3, this.getName());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String colListStr = rs.getString(2);
                    boolean isClustered = rs.getString(3).equals("Y");
                    List columnList = SybaseASACatalogUtils.getSpecifiedColumns(colListStr, (Collection)table.getColumns());
                    super.getMembers().clear();
                    super.getMembers().addAll((Collection)columnList);
                    super.setClustered(isClustered);
                }
            }
            catch (SQLException e) {
                JDBCASAPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
            throw throwable;
        }
        {
            Object var12_15 = null;
        }
        SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        this.eSetDeliver(deliver);
    }
}

