/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.baseloaders;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.accesscontrol.SQLAccessControlFactory;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;

public class AuthorizationIdentifierASALoader {
    protected AuthorizationIdentifier authId;
    protected Connection conn;
    protected ICatalogObject catalogObj;

    public AuthorizationIdentifierASALoader(AuthorizationIdentifier catalogAuthId) {
        this.authId = catalogAuthId;
        this.catalogObj = (ICatalogObject)catalogAuthId;
        this.conn = this.catalogObj.getConnection();
    }

    public final void loadPrivilegs(EList privileges) {
        boolean deliver = this.authId.eDeliver();
        this.authId.eSetDeliver(false);
        privileges.clear();
        List tableIdsWithColumnPrivilege = this.loadTablePrivilegs((List)privileges);
        this.loadTableColumnPrivilege((List)privileges, tableIdsWithColumnPrivilege);
        this.loadRoutinePrivileges((List)privileges);
        this.authId.eSetDeliver(deliver);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void loadAuthInfo() {
        boolean deliver = this.authId.eDeliver();
        this.authId.eSetDeliver(false);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = this.conn.prepareStatement("select remarks from sysuserperm where user_name = ?");
                stmt.setString(1, this.authId.getName());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String remarks = rs.getString(1);
                    this.authId.setDescription(remarks);
                }
            }
            catch (SQLException e) {
                JDBCASAPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        this.authId.eSetDeliver(deliver);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadTableColumnPrivilege(List privileges, List tableIdsWithColumnPrivilege) {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int i = 0;
        while (i < tableIdsWithColumnPrivilege.size()) {
            Object var18_19;
            int tableId = (Integer)tableIdsWithColumnPrivilege.get(i);
            Table table = null;
            try {
                try {
                    stmt = this.conn.prepareStatement("SELECT TRIM(T.table_name) as table_name, TRIM(U.user_name) as Table_Owner, TRIM(C.column_name), P.privilege_type, P.is_grantable, G.user_name as Grantor FROM sys.systable T join sys.SYSUSERPERMS U on T.creator = U.user_id join sys.syscolperm P on P.table_id = T.table_id join sys.sysuserperms E on P.grantee = E.user_id and E.user_name = ? join sys.syscolumn C on  C.table_id = T.table_id and C.column_id = P.column_id join sysuserperms G on G.user_id = P.grantor where T.table_id = ?");
                    stmt.setString(1, this.authId.getName());
                    stmt.setInt(2, tableId);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String tableName = rs.getString(1);
                        String ownerName = rs.getString(2);
                        String columnName = rs.getString(3);
                        int privilegeType = rs.getInt(4);
                        boolean isGrantable = rs.getString(5).equals("Y");
                        String grantorName = rs.getString(6);
                        if (table == null) {
                            Schema schema = (Schema)SybaseASACatalogUtils.findElement((Collection)this.catalogObj.getCatalogDatabase().getSchemas(), ownerName);
                            table = (Table)SybaseASACatalogUtils.findElement((Collection)schema.getTables(), tableName);
                        }
                        Column col = (Column)SybaseASACatalogUtils.findElement((Collection)table.getColumns(), columnName);
                        Privilege p = SQLAccessControlFactory.eINSTANCE.createPrivilege();
                        AuthorizationIdentifier grantor = (AuthorizationIdentifier)SybaseASACatalogUtils.findElement((Collection)this.catalogObj.getCatalogDatabase().getAuthorizationIds(), grantorName);
                        String action = null;
                        switch (privilegeType) {
                            case 1: {
                                action = "select";
                                break;
                            }
                            case 8: {
                                action = "update";
                                break;
                            }
                            case 16: {
                                action = "reference";
                                break;
                            }
                        }
                        p.setAction(action);
                        p.setGrantable(isGrantable);
                        p.setObject((SQLObject)col);
                        p.setGrantor(grantor);
                        privileges.add(p);
                    }
                }
                catch (SQLException e) {
                    JDBCASAPlugin.getDefault().log(e);
                }
            }
            catch (Throwable throwable) {
                var18_19 = null;
                SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                throw throwable;
            }
            {
                var18_19 = null;
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
            ++i;
        }
        return;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadRoutinePrivileges(List privileges) {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = this.conn.prepareStatement("SELECT TRIM(F.proc_name) as proc_name, TRIM(U.user_name) as user_name, IFNULL( R.parm_id, 'N', 'Y' ) AS \"function\", IFNULL( P.grantee, 'N', 'Y' ) AS executeauth FROM SYS.SYSPROCEDURE F JOIN SYS.SYSUSERPERMS U ON U.user_id = F.creator LEFT OUTER JOIN SYS.SYSPROCPARM R ON R.proc_id = F.proc_id AND R.parm_type = 4 LEFT OUTER JOIN SYS.SYSUSERPERMS E ON E.user_name = ? LEFT OUTER JOIN SYS.SYSPROCPERM P ON P.proc_id = F.proc_id AND P.grantee = E.user_id ORDER BY F.proc_name, U.user_name");
                stmt.setString(1, this.authId.getName());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String routineName = rs.getString(1);
                    String ownerName = rs.getString(2);
                    boolean isExcutable = rs.getString(4).equals("Y");
                    if (!isExcutable) continue;
                    Privilege p = SQLAccessControlFactory.eINSTANCE.createPrivilege();
                    Schema schema = (Schema)SybaseASACatalogUtils.findElement((Collection)this.catalogObj.getCatalogDatabase().getSchemas(), ownerName);
                    Routine r = (Routine)SybaseASACatalogUtils.findElement((Collection)schema.getRoutines(), routineName);
                    p.setObject((SQLObject)r);
                    p.setAction("execute");
                    privileges.add(p);
                }
            }
            catch (SQLException e) {
                JDBCASAPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List loadTablePrivilegs(List privileges) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = this.conn.prepareStatement("SELECT TRIM(T.table_name) as table_name, TRIM(U.user_name) AS Table_Owner, P.selectauth, P.insertauth, P.deleteauth, P.updateauth, P.alterauth, P.referenceauth, G.user_name as Grantor, P.updatecols, P.stable_id FROM SYS.SYSTABLE T JOIN SYS.SYSUSERPERMS U ON U.user_id = T.creator LEFT OUTER JOIN SYS.SYSUSERPERMS E ON E.user_name = ? LEFT OUTER JOIN SYS.SYSTABLEPERM P ON P.stable_id = T.table_id AND P.grantee = E.user_id LEFT JOIN SYS.SYSUSERPERM G ON P.grantor = G.user_id where P.stable_id <> null ORDER BY T.table_name, U.user_name");
                stmt.setString(1, this.authId.getName());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    Privilege p;
                    String tableName = rs.getString(1);
                    String tableOwner = rs.getString(2);
                    char selectAuth = SybaseASACatalogUtils.getCharValue(rs.getString(3));
                    char insertAuth = SybaseASACatalogUtils.getCharValue(rs.getString(4));
                    char deleteAuth = SybaseASACatalogUtils.getCharValue(rs.getString(5));
                    char updateAuth = SybaseASACatalogUtils.getCharValue(rs.getString(6));
                    char alterAuth = SybaseASACatalogUtils.getCharValue(rs.getString(7));
                    char referenceAuth = SybaseASACatalogUtils.getCharValue(rs.getString(8));
                    String grantorName = rs.getString(9);
                    char updateColAuth = SybaseASACatalogUtils.getCharValue(rs.getString(10));
                    int tableId = rs.getInt(11);
                    SQLObject obj = null;
                    if (selectAuth == 'Y' || selectAuth == 'G') {
                        p = this.createTablePrivilege(selectAuth, "select", grantorName, tableOwner, tableName, obj);
                        privileges.add(p);
                    }
                    if (insertAuth == 'Y' || insertAuth == 'G') {
                        p = this.createTablePrivilege(insertAuth, "insert", grantorName, tableOwner, tableName, obj);
                        privileges.add(p);
                    }
                    if (deleteAuth == 'Y' || deleteAuth == 'G') {
                        p = this.createTablePrivilege(deleteAuth, "delete", grantorName, tableOwner, tableName, obj);
                        privileges.add(p);
                    }
                    if (updateAuth == 'Y' || updateAuth == 'G') {
                        p = this.createTablePrivilege(updateAuth, "update", grantorName, tableOwner, tableName, obj);
                        privileges.add(p);
                    }
                    if (alterAuth == 'Y' || alterAuth == 'G') {
                        p = this.createTablePrivilege(alterAuth, "alter", grantorName, tableOwner, tableName, obj);
                        privileges.add(p);
                    }
                    if (referenceAuth == 'Y' || referenceAuth == 'G') {
                        p = this.createTablePrivilege(referenceAuth, "reference", grantorName, tableOwner, tableName, obj);
                        privileges.add(p);
                    }
                    if (updateColAuth != 'Y' && updateColAuth != 'G') continue;
                    results.add(new Integer(tableId));
                }
            }
            catch (SQLException e) {
                JDBCASAPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
            throw throwable;
        }
        {
            Object var18_21 = null;
        }
        SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        return results;
    }

    private Privilege createTablePrivilege(char authChar, String action, String grantorName, String tableOwner, String tableName, SQLObject obj) {
        Privilege result = SQLAccessControlFactory.eINSTANCE.createPrivilege();
        result.setGrantable(authChar == 'G');
        result.setAction(action);
        AuthorizationIdentifier grantor = (AuthorizationIdentifier)SybaseASACatalogUtils.findElement((Collection)this.catalogObj.getCatalogDatabase().getAuthorizationIds(), grantorName);
        result.setGrantor(grantor);
        if (obj == null) {
            obj = this.findSQLObject(tableOwner, tableName, true);
        }
        result.setObject(obj);
        return result;
    }

    private SQLObject findSQLObject(String tableOwner, String tableName, boolean isTable) {
        Schema schema = (Schema)SybaseASACatalogUtils.findElement((Collection)this.catalogObj.getCatalogDatabase().getSchemas(), tableOwner);
        SQLObject result = null;
        result = isTable ? (SQLObject)SybaseASACatalogUtils.findElement((Collection)schema.getTables(), tableName) : (SQLObject)SybaseASACatalogUtils.findElement((Collection)schema.getRoutines(), tableName);
        return result;
    }
}

