/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.types;

import org.eclipse.jst.jsf.common.internal.types.LiteralType;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercionException;

public abstract class NumericTypeLiteral
extends LiteralType {
    protected NumericTypeLiteral(String signature) {
        super(signature);
    }

    protected abstract Number getBoxedValue();

    public Number coerceToNumber(Class T) throws TypeCoercionException {
        Number boxedLiteralValue = this.getBoxedValue();
        if (T == Double.class || T == Double.TYPE) {
            return new Double(boxedLiteralValue.doubleValue());
        }
        if (T == Float.class || T == Float.TYPE) {
            return new Float(boxedLiteralValue.floatValue());
        }
        if (T == Long.class || T == Long.TYPE) {
            return boxedLiteralValue;
        }
        if (T == Integer.class || T == Integer.TYPE) {
            return new Integer(boxedLiteralValue.intValue());
        }
        if (T == Short.class || T == Short.TYPE) {
            return new Short(boxedLiteralValue.shortValue());
        }
        if (T == Byte.class || T == Byte.TYPE) {
            return new Byte(boxedLiteralValue.byteValue());
        }
        return null;
    }

    public String getLiteralValue() {
        return this.getBoxedValue().toString();
    }

    public Object getLiteralValueRaw() {
        return this.getBoxedValue();
    }

    public Boolean coerceToBoolean() throws TypeCoercionException {
        throw new TypeCoercionException("Cannot coerce number to boolean");
    }
}

