/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel.dom;

import java.util.Vector;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.eclipse.wst.xml.core.internal.document.XMLModelNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PHPModelNotifier
implements XMLModelNotifier {
    private static final String ADDED_THEN_REMOVED = "Discard: Added then removed rule";
    private static final boolean fOptimizeDeferred = true;
    private static final boolean fOptimizeDeferredAccordingToParentAdded = true;
    private static final boolean fOptimizeDeferredAccordingToParentRemoved = true;
    private static final String PARENT_IS_ADDED = "Disarded: Parent has just been added";
    private static final String PARENT_IS_REMOVED_TOO = "Discard: Parent was removed too";
    private static final String PARENT_IS_REPARENTED = "Not Discard: Parent was removed so this implies reparenting";
    private Node changedRoot = null;
    private boolean changing = false;
    private boolean doingNewModel = false;
    private Vector events = null;
    private boolean flushing = false;

    public void attrReplaced(Element element, Attr attr, Attr attr2) {
        if (element == null) {
            return;
        }
        Attr attr3 = null;
        String string = null;
        String string2 = null;
        if (attr2 != null) {
            attr3 = attr2;
            string = attr2.getValue();
        }
        if (attr != null) {
            attr3 = attr;
            string2 = attr.getValue();
        }
        IDOMNode iDOMNode = (IDOMNode)element;
        int n = iDOMNode.getStartOffset();
        this.notify((INodeNotifier)iDOMNode, 1, attr3, string, string2, n);
        this.propertyChanged((Node)iDOMNode);
    }

    public void beginChanging() {
        this.changing = true;
    }

    public void beginChanging(boolean bl) {
        this.beginChanging();
        this.doingNewModel = bl;
    }

    public void cancelPending() {
        if (this.events != null) {
            for (NotifyEvent notifyEvent : this.events) {
                notifyEvent.discarded = true;
            }
        }
        this.changedRoot = null;
    }

    public void childReplaced(Node node, Node node2, Node node3) {
        if (node == null) {
            return;
        }
        IDOMNode iDOMNode = (IDOMNode)node;
        int n = 1;
        if (node2 == null) {
            n = 3;
        } else if (node3 == null) {
            n = 2;
        }
        int n2 = iDOMNode.getStartOffset();
        this.notify((INodeNotifier)iDOMNode, n, node3, node3, node2, n2);
        this.structureChanged((Node)iDOMNode);
    }

    public void editableChanged(Node node) {
        if (node == null) {
            return;
        }
        IDOMNode iDOMNode = (IDOMNode)node;
        int n = iDOMNode.getStartOffset();
        this.notify((INodeNotifier)iDOMNode, 1, null, null, null, n);
        this.propertyChanged((Node)iDOMNode);
    }

    public void endChanging() {
        this.doingNewModel = false;
        if (!this.changing) {
            return;
        }
        this.notifyDeferred();
        if (this.changedRoot != null) {
            this.notifyStructureChanged(this.changedRoot);
            this.changedRoot = null;
        }
        this.changing = false;
    }

    public void endTagChanged(Element element) {
        if (element == null) {
            return;
        }
        IDOMNode iDOMNode = (IDOMNode)element;
        int n = iDOMNode.getStartOffset();
        this.notify((INodeNotifier)iDOMNode, 1, null, null, null, n);
        this.propertyChanged(element);
    }

    public boolean hasChanged() {
        return this.events != null;
    }

    public boolean isChanging() {
        return this.changing;
    }

    private void notify(INodeNotifier iNodeNotifier, int n, Object object, Object object2, Object object3, int n2) {
        if (iNodeNotifier == null) {
            return;
        }
        if (this.changing && !this.flushing) {
            if (this.events == null) {
                this.events = new Vector();
            }
            if (!this.doingNewModel || ((Node)iNodeNotifier).getNodeType() == 9) {
                this.events.addElement(new NotifyEvent(iNodeNotifier, n, object, object2, object3, n2));
            }
            return;
        }
        try {
            iNodeNotifier.notify(n, object, object2, object3, n2);
        }
        catch (Exception exception) {
            Logger.logException((String)("A structured model client threw following exception during adapter notification (" + INodeNotifier.EVENT_TYPE_STRINGS[n] + " )"), (Throwable)exception);
        }
    }

    private void notifyDeferred() {
        if (this.events == null) {
            return;
        }
        if (this.flushing) {
            return;
        }
        this.flushing = true;
        int n = this.events.size();
        int n2 = 0;
        while (n2 < n) {
            block14: {
                NotifyEvent notifyEvent;
                block15: {
                    NotifyEvent notifyEvent2;
                    int n3;
                    block16: {
                        notifyEvent = (NotifyEvent)this.events.elementAt(n2);
                        if (notifyEvent == null || notifyEvent.discarded) break block14;
                        if (this.doingNewModel) break block15;
                        if (notifyEvent.type != 2) break block16;
                        n3 = n2 + 1;
                        while (n3 < n) {
                            notifyEvent2 = (NotifyEvent)this.events.elementAt(n3);
                            if (notifyEvent2 != null && notifyEvent2.type == 3 && notifyEvent2.oldValue == notifyEvent.newValue) {
                                notifyEvent.discarded = true;
                                notifyEvent2.discarded = true;
                                break;
                            }
                            ++n3;
                        }
                        if (notifyEvent.discarded) break block14;
                        n3 = 0;
                        while (n3 < n2) {
                            notifyEvent2 = (NotifyEvent)this.events.elementAt(n3);
                            if (notifyEvent2 != null) {
                                if (notifyEvent2.type == 3 && notifyEvent2.oldValue == notifyEvent.notifier) break;
                                if (notifyEvent2.type == 2 && notifyEvent2.newValue == notifyEvent.notifier) {
                                    notifyEvent.discarded = true;
                                    break;
                                }
                            }
                            ++n3;
                        }
                        if (!notifyEvent.discarded) break block15;
                        break block14;
                    }
                    if (notifyEvent.type != 3) break block15;
                    n3 = n2 + 1;
                    while (n3 < n) {
                        notifyEvent2 = (NotifyEvent)this.events.elementAt(n3);
                        if (notifyEvent2 != null && notifyEvent2.type == 3 && notifyEvent2.oldValue == notifyEvent.notifier) {
                            notifyEvent.discarded = true;
                            break;
                        }
                        ++n3;
                    }
                    if (notifyEvent.discarded) break block14;
                }
                this.notify(notifyEvent.notifier, notifyEvent.type, notifyEvent.changedFeature, notifyEvent.oldValue, notifyEvent.newValue, notifyEvent.pos);
            }
            ++n2;
        }
        this.flushing = false;
        this.events = null;
    }

    private void notifyStructureChanged(Node node) {
        if (node == null) {
            return;
        }
        INodeNotifier iNodeNotifier = (INodeNotifier)node;
        try {
            iNodeNotifier.notify(4, null, null, null, -1);
        }
        catch (Exception exception) {
            Logger.logException((String)("A structured model client threw following exception during adapter notification (" + INodeNotifier.EVENT_TYPE_STRINGS[4] + " )"), (Throwable)exception);
        }
    }

    public void propertyChanged(Node node) {
    }

    private void setCommonRootIfNeeded(Node node) {
        if (this.changedRoot == null) {
            this.changedRoot = node;
        } else if (this.changedRoot.getNodeType() != 9 && this.changedRoot != node) {
            Node node2 = ((NodeImpl)this.changedRoot).getCommonAncestor(node);
            this.changedRoot = node2 != null ? node2 : node;
        }
    }

    public void startTagChanged(Element element) {
        if (element == null) {
            return;
        }
        IDOMNode iDOMNode = (IDOMNode)element;
        int n = iDOMNode.getStartOffset();
        this.notify((INodeNotifier)iDOMNode, 1, null, null, null, n);
        this.propertyChanged(element);
    }

    public void structureChanged(Node node) {
        if (node == null) {
            return;
        }
        if (this.isChanging()) {
            this.setCommonRootIfNeeded(node);
            return;
        }
        this.notifyStructureChanged(node);
    }

    public void valueChanged(Node node) {
        if (node == null) {
            return;
        }
        IDOMNode iDOMNode = null;
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            iDOMNode = (IDOMNode)attr.getOwnerElement();
            if (iDOMNode == null) {
                return;
            }
            String string = attr.getValue();
            int n = iDOMNode.getStartOffset();
            this.notify((INodeNotifier)iDOMNode, 1, attr, null, string, n);
        } else {
            IDOMNode iDOMNode2;
            iDOMNode = (IDOMNode)node;
            boolean bl = node.getNodeType() == 3 && ((TextImpl)node).getFirstStructuredDocumentRegion().getType() == "PHP_CONTENT";
            String string = bl ? null : node.getNodeValue();
            int n = iDOMNode.getStartOffset();
            this.notify((INodeNotifier)iDOMNode, 1, null, null, string, n);
            if (node.getNodeType() != 1 && (iDOMNode2 = (IDOMNode)node.getParentNode()) != null) {
                this.notify((INodeNotifier)iDOMNode2, 5, node, null, string, n);
            }
        }
        this.propertyChanged((Node)iDOMNode);
    }

    private class NotifyEvent {
        Object changedFeature;
        boolean discarded;
        Object newValue;
        INodeNotifier notifier;
        Object oldValue;
        int pos;
        String reason;
        int type;

        NotifyEvent(INodeNotifier iNodeNotifier, int n, Object object, Object object2, Object object3, int n2) {
            this.notifier = iNodeNotifier;
            this.type = n;
            this.changedFeature = object;
            this.oldValue = object2;
            this.newValue = object3;
            this.pos = n2;
            this.reason = "";
        }
    }
}

