/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.console;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.resources.ExternalFileDecorator;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.debug.core.IPHPConsoleEventListener;
import org.eclipse.php.internal.debug.core.debugger.DebugError;
import org.eclipse.php.internal.debug.core.launching.DebugConsoleMonitor;
import org.eclipse.php.internal.debug.core.launching.PHPHyperLink;
import org.eclipse.php.internal.debug.core.launching.PHPProcess;
import org.eclipse.php.internal.debug.core.launching.PHPStreamsProxy;
import org.eclipse.php.internal.debug.core.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.sourcelookup.PHPSourceSearchEngine;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.debug.ui.console.PHPFileLink;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.IHyperlink;

public class PHPConsoleColorProvider
extends ConsoleColorProvider {
    private PHPProcess fProcess;
    private IConsole fConsole;
    private ILaunch fLaunch;
    private PHPHyperLink fPHPHyperLink;
    private static final String PHP_DEBUG_STREAM = String.valueOf(PHPDebugUIPlugin.getID()) + ".PHP_CONSOLE_STREAM";

    public void connect(IProcess iProcess, IConsole iConsole) {
        this.fConsole = iConsole;
        PHPStreamsProxy pHPStreamsProxy = (PHPStreamsProxy)iProcess.getStreamsProxy();
        if (!(iProcess instanceof PHPProcess)) {
            return;
        }
        this.fProcess = (PHPProcess)iProcess;
        this.fProcess.setConsole(this.fConsole);
        this.fPHPHyperLink = new PHPHyperLink();
        this.fProcess.setPHPHyperLink(this.fPHPHyperLink);
        DebugConsoleMonitor debugConsoleMonitor = (DebugConsoleMonitor)pHPStreamsProxy.getConsoleStreamMonitor();
        if (pHPStreamsProxy != null) {
            this.fConsole.connect((IStreamMonitor)debugConsoleMonitor, PHP_DEBUG_STREAM);
        }
        this.fLaunch = iProcess.getLaunch();
        PHPDebugTarget pHPDebugTarget = null;
        if (this.fLaunch.getDebugTarget() instanceof PHPDebugTarget) {
            pHPDebugTarget = (PHPDebugTarget)this.fLaunch.getDebugTarget();
        }
        if (pHPDebugTarget != null) {
            pHPDebugTarget.addConsoleEventListener((IPHPConsoleEventListener)new PHPConsoleListener(debugConsoleMonitor, this.fConsole, this.fLaunch, this.fPHPHyperLink));
        }
        super.connect(iProcess, this.fConsole);
    }

    public void disconnect() {
        this.fConsole = null;
        this.fProcess = null;
    }

    public boolean isReadOnly() {
        return true;
    }

    public Color getColor(String string) {
        if (PHP_DEBUG_STREAM.equals(string)) {
            return DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.errorColor");
        }
        return null;
    }

    protected IProcess getProcess() {
        return this.fProcess;
    }

    protected IConsole getConsole() {
        return this.fConsole;
    }

    public class PHPConsoleListener
    implements IPHPConsoleEventListener {
        private DebugConsoleMonitor fConsoleMonitor;
        private IConsole fConsole;
        private ILaunch fLaunch;
        private PHPHyperLink fPHPHyperLink;
        private String EditorID = "org.eclipse.php.editor";

        public PHPConsoleListener(DebugConsoleMonitor debugConsoleMonitor, IConsole iConsole, ILaunch iLaunch, PHPHyperLink pHPHyperLink) {
            this.fConsoleMonitor = debugConsoleMonitor;
            this.fConsole = iConsole;
            this.fLaunch = iLaunch;
            this.fPHPHyperLink = pHPHyperLink;
        }

        public void handleEvent(DebugError debugError) {
            IHyperlink iHyperlink = this.createLink(debugError);
            String string = debugError.toString().trim();
            this.fPHPHyperLink.addLink(iHyperlink, string, string.length() - debugError.getErrorTextLength());
            this.fConsoleMonitor.append(String.valueOf(debugError.toString()) + '\n');
        }

        private IHyperlink createLink(DebugError debugError) {
            PHPFileLink pHPFileLink;
            block10: {
                pHPFileLink = null;
                try {
                    String string = debugError.getFileName();
                    int n = debugError.getLineNumber();
                    IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(string));
                    if (iFile == null) {
                        Object object = null;
                        if (ExternalFilesRegistry.getInstance().isEntryExist(string)) {
                            object = ExternalFilesRegistry.getInstance().getFileEntry(string);
                        } else {
                            ILaunchConfiguration iLaunchConfiguration = this.fLaunch.getLaunchConfiguration();
                            String string2 = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.PHP_Project", null);
                            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string2);
                            iFile = PHPSourceSearchEngine.getResource((String)string, (IProject)iProject);
                            if (iFile.exists()) {
                                object = iFile;
                            } else {
                                File file;
                                PHPFileData pHPFileData = null;
                                try {
                                    pHPFileData = PHPWorkspaceModelManager.getInstance().getModelForFile(string);
                                }
                                catch (Exception exception) {}
                                object = pHPFileData != null ? pHPFileData : ((file = new File(string)).exists() ? file : ExternalFileDecorator.createFile((String)string));
                            }
                        }
                        if (object != null) {
                            pHPFileLink = new PHPFileLink(object, -1, -1, n);
                        }
                        break block10;
                    }
                    pHPFileLink = new PHPFileLink(iFile, -1, -1, n);
                }
                catch (CoreException coreException) {
                    Logger.logException("PHPConsoleListener unexpected error", coreException);
                }
            }
            return pHPFileLink;
        }
    }
}

