/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.compare;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.internal.MergeViewerAction;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class MergeSourceViewer
extends StructuredTextViewer
implements ISelectionChangedListener,
ITextListener,
IMenuListener,
IOperationHistoryListener {
    public static final String UNDO_ID = "undo";
    public static final String REDO_ID = "redo";
    public static final String CUT_ID = "cut";
    public static final String COPY_ID = "copy";
    public static final String PASTE_ID = "paste";
    public static final String DELETE_ID = "delete";
    public static final String SELECT_ALL_ID = "selectAll";
    public static final String SAVE_ID = "save";
    public static final String FIND_ID = "find";
    private ResourceBundle fResourceBundle;
    private Position fRegion;
    private boolean fEnabled = true;
    private HashMap fActions = new HashMap();
    private IDocument fRememberedDocument;
    private boolean fAddSaveAction = true;
    private boolean isConfigured = false;
    private IPropertyChangeListener fPreferenceChangeListener;
    private boolean fShowLineNumber = false;
    private LineNumberRulerColumn fLineNumberColumn;
    private List textActions = new ArrayList();

    public MergeSourceViewer(Composite composite, int n, ResourceBundle resourceBundle, ICompareContainer iCompareContainer) {
        super(composite, (IVerticalRuler)new CompositeRuler(), null, false, n | 0x100 | 0x200);
        IOperationHistory iOperationHistory;
        this.fResourceBundle = resourceBundle;
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        StyledText styledText = this.getTextWidget();
        styledText.setMenu(menuManager.createContextMenu((Control)styledText));
        iCompareContainer.registerContextMenu(menuManager, (ISelectionProvider)this);
        this.fPreferenceChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MergeSourceViewer.this.handlePropertyChangeEvent(propertyChangeEvent);
            }
        };
        EditorsUI.getPreferenceStore().addPropertyChangeListener(this.fPreferenceChangeListener);
        this.fShowLineNumber = EditorsUI.getPreferenceStore().getBoolean("lineNumberRuler");
        if (this.fShowLineNumber) {
            this.updateLineNumberRuler();
        }
        if ((iOperationHistory = this.getHistory()) != null) {
            iOperationHistory.addOperationHistoryListener((IOperationHistoryListener)this);
        }
    }

    public void rememberDocument(IDocument iDocument) {
        this.fRememberedDocument = iDocument;
    }

    public IDocument getRememberedDocument() {
        return this.fRememberedDocument;
    }

    public void hideSaveAction() {
        this.fAddSaveAction = false;
    }

    public void setFont(Font font) {
        StyledText styledText = this.getTextWidget();
        if (styledText != null) {
            styledText.setFont(font);
        }
        if (this.fLineNumberColumn != null) {
            this.fLineNumberColumn.setFont(font);
            this.layoutViewer();
        }
    }

    public void setBackgroundColor(Color color) {
        StyledText styledText = this.getTextWidget();
        if (styledText != null) {
            styledText.setBackground(color);
        }
        if (this.fLineNumberColumn != null) {
            this.fLineNumberColumn.setBackground(color);
        }
    }

    public void setEnabled(boolean bl) {
        if (bl != this.fEnabled) {
            this.fEnabled = bl;
            StyledText styledText = this.getTextWidget();
            if (styledText != null) {
                styledText.setEnabled(bl);
                Display display = styledText.getDisplay();
                styledText.setBackground(bl ? display.getSystemColor(25) : null);
            }
        }
    }

    public boolean getEnabled() {
        return this.fEnabled;
    }

    public void setRegion(Position position) {
        this.fRegion = position;
    }

    public Position getRegion() {
        return this.fRegion;
    }

    public boolean isControlOkToUse() {
        StyledText styledText = this.getTextWidget();
        return styledText != null && !styledText.isDisposed();
    }

    public void setSelection(Position position) {
        if (position != null) {
            this.setSelectedRange(position.getOffset(), position.getLength());
        }
    }

    public void setLineBackground(Position position, Color color) {
        StyledText styledText = this.getTextWidget();
        if (styledText != null && !styledText.isDisposed()) {
            Point point = new Point(0, 0);
            this.getLineRange(position, point);
            point.x -= this.getDocumentRegionOffset();
            try {
                styledText.setLineBackground(point.x, point.y, color);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void resetLineBackground() {
        StyledText styledText = this.getTextWidget();
        if (styledText != null && !styledText.isDisposed()) {
            int n = this.getLineCount();
            styledText.setLineBackground(0, n, null);
        }
    }

    public int getLineCount() {
        IRegion iRegion = this.getVisibleRegion();
        int n = iRegion.getLength();
        if (n == 0) {
            return 0;
        }
        IDocument iDocument = this.getDocument();
        int n2 = 0;
        int n3 = 0;
        int n4 = iRegion.getOffset();
        try {
            n2 = iDocument.getLineOfOffset(n4);
        }
        catch (BadLocationException badLocationException) {}
        try {
            n3 = iDocument.getLineOfOffset(n4 + n);
        }
        catch (BadLocationException badLocationException) {}
        return n3 - n2 + 1;
    }

    public int getViewportLines() {
        StyledText styledText = this.getTextWidget();
        Rectangle rectangle = styledText.getClientArea();
        if (!rectangle.isEmpty()) {
            return rectangle.height / styledText.getLineHeight();
        }
        return 0;
    }

    public int getViewportHeight() {
        StyledText styledText = this.getTextWidget();
        Rectangle rectangle = styledText.getClientArea();
        if (!rectangle.isEmpty()) {
            return rectangle.height;
        }
        return 0;
    }

    public int getDocumentRegionOffset() {
        int n = this.getVisibleRegion().getOffset();
        IDocument iDocument = this.getDocument();
        if (iDocument != null) {
            try {
                return iDocument.getLineOfOffset(n);
            }
            catch (BadLocationException badLocationException) {}
        }
        return 0;
    }

    public int getVerticalScrollOffset() {
        StyledText styledText = this.getTextWidget();
        int n = styledText.getLineHeight();
        return this.getTopInset() - (this.getDocumentRegionOffset() * n + styledText.getTopPixel());
    }

    public Point getLineRange(Position position, Point point) {
        IDocument iDocument = this.getDocument();
        if (position == null || iDocument == null) {
            point.x = 0;
            point.y = 0;
            return point;
        }
        int n = position.getOffset();
        int n2 = position.getLength();
        int n3 = 0;
        try {
            n3 = iDocument.getLineOfOffset(n);
        }
        catch (BadLocationException badLocationException) {}
        int n4 = 0;
        if (n2 != 0) {
            int n5 = 0;
            try {
                n5 = iDocument.getLineOfOffset(n + n2 - 1);
            }
            catch (BadLocationException badLocationException) {}
            n4 = n5 - n3 + 1;
        }
        point.x = n3;
        point.y = n4;
        return point;
    }

    public void vscroll(int n) {
        int n2;
        int n3 = this.getLineCount();
        if (n3 > (n2 = this.getViewportLines())) {
            int n4;
            if (n < 0) {
                n = 0;
            }
            if ((n4 = this.getTopIndex()) != n) {
                this.setTopIndex(n + this.getDocumentRegionOffset());
            }
        }
    }

    public void addAction(String string, MergeViewerAction mergeViewerAction) {
        this.fActions.put(string, mergeViewerAction);
    }

    public IAction getAction(String string) {
        MergeViewerAction mergeViewerAction;
        IAction iAction = (IAction)this.fActions.get(string);
        if (iAction == null) {
            iAction = this.createAction(string);
            if (iAction == null) {
                return null;
            }
            if (iAction instanceof MergeViewerAction) {
                mergeViewerAction = (MergeViewerAction)iAction;
                if (mergeViewerAction.isContentDependent()) {
                    this.addTextListener(this);
                }
                if (mergeViewerAction.isSelectionDependent()) {
                    this.addSelectionChangedListener(this);
                }
                Utilities.initAction((IAction)iAction, (ResourceBundle)this.fResourceBundle, (String)("action." + string + "."));
            }
            this.addAction(string, iAction);
        }
        if (iAction instanceof MergeViewerAction && (mergeViewerAction = (MergeViewerAction)iAction).isEditableDependent() && !this.isEditable()) {
            return null;
        }
        return iAction;
    }

    protected IAction createAction(String string) {
        if (UNDO_ID.equals(string)) {
            return new TextOperationAction(1, "org.eclipse.ui.edit.undo", true, false, true);
        }
        if (REDO_ID.equals(string)) {
            return new TextOperationAction(2, "org.eclipse.ui.edit.redo", true, false, true);
        }
        if (CUT_ID.equals(string)) {
            return new TextOperationAction(3, "org.eclipse.ui.edit.cut", true, true, false);
        }
        if (COPY_ID.equals(string)) {
            return new TextOperationAction(4, "org.eclipse.ui.edit.copy", false, true, false);
        }
        if (PASTE_ID.equals(string)) {
            return new TextOperationAction(5, "org.eclipse.ui.edit.paste", true, false, false);
        }
        if (DELETE_ID.equals(string)) {
            return new TextOperationAction(6, "org.eclipse.ui.edit.delete", true, false, false);
        }
        if (SELECT_ALL_ID.equals(string)) {
            return new TextOperationAction(7, "org.eclipse.ui.edit.selectAll", false, false, false);
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        for (Object v : this.fActions.values()) {
            MergeViewerAction mergeViewerAction;
            if (!(v instanceof MergeViewerAction) || !(mergeViewerAction = (MergeViewerAction)v).isSelectionDependent()) continue;
            mergeViewerAction.update();
        }
    }

    public void textChanged(TextEvent textEvent) {
        this.updateContentDependantActions();
    }

    void updateContentDependantActions() {
        for (Object v : this.fActions.values()) {
            MergeViewerAction mergeViewerAction;
            if (!(v instanceof MergeViewerAction) || !(mergeViewerAction = (MergeViewerAction)v).isContentDependent()) continue;
            mergeViewerAction.update();
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator(UNDO_ID));
        this.addMenu(iMenuManager, UNDO_ID);
        this.addMenu(iMenuManager, REDO_ID);
        iMenuManager.add((IContributionItem)new GroupMarker(SAVE_ID));
        if (this.fAddSaveAction) {
            this.addMenu(iMenuManager, SAVE_ID);
        }
        iMenuManager.add((IContributionItem)new Separator("file"));
        iMenuManager.add((IContributionItem)new Separator("ccp"));
        this.addMenu(iMenuManager, CUT_ID);
        this.addMenu(iMenuManager, COPY_ID);
        this.addMenu(iMenuManager, PASTE_ID);
        this.addMenu(iMenuManager, DELETE_ID);
        this.addMenu(iMenuManager, SELECT_ALL_ID);
        iMenuManager.add((IContributionItem)new Separator("edit"));
        iMenuManager.add((IContributionItem)new Separator(FIND_ID));
        this.addMenu(iMenuManager, FIND_ID);
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IContributionItem)new Separator("text"));
        for (IAction iAction : this.textActions) {
            iMenuManager.add(iAction);
        }
        iMenuManager.add((IContributionItem)new Separator("rest"));
        this.updateActions();
    }

    private void addMenu(IMenuManager iMenuManager, String string) {
        IAction iAction = this.getAction(string);
        if (iAction != null) {
            iMenuManager.add(iAction);
        }
    }

    protected void handleDispose() {
        this.removeTextListener(this);
        this.removeSelectionChangedListener(this);
        EditorsUI.getPreferenceStore().removePropertyChangeListener(this.fPreferenceChangeListener);
        IOperationHistory iOperationHistory = this.getHistory();
        if (iOperationHistory != null) {
            iOperationHistory.removeOperationHistoryListener((IOperationHistoryListener)this);
        }
        super.handleDispose();
    }

    public void updateActions() {
        for (Object v : this.fActions.values()) {
            MergeViewerAction mergeViewerAction;
            if (v instanceof MergeViewerAction) {
                mergeViewerAction = (MergeViewerAction)v;
                mergeViewerAction.update();
            }
            if (!(v instanceof FindReplaceAction)) continue;
            mergeViewerAction = (FindReplaceAction)v;
            mergeViewerAction.update();
        }
    }

    public void configure(SourceViewerConfiguration sourceViewerConfiguration) {
        if (this.isConfigured) {
            this.unconfigure();
        }
        this.isConfigured = true;
        super.configure(sourceViewerConfiguration);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.getControl() instanceof Composite) {
            ((Composite)this.getControl()).setBounds(n, n2, n3, n4);
        } else {
            this.getTextWidget().setBounds(n, n2, n3, n4);
        }
    }

    protected void handlePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (string.equals("lineNumberRuler")) {
            boolean bl = EditorsUI.getPreferenceStore().getBoolean("lineNumberRuler");
            if (bl != this.fShowLineNumber) {
                this.toggleLineNumberRuler();
            }
        } else if (string.equals("lineNumberColor")) {
            this.updateLineNumberColumnPresentation(true);
        }
    }

    private void updateLineNumberRuler() {
        IVerticalRuler iVerticalRuler = this.getVerticalRuler();
        if (iVerticalRuler != null && iVerticalRuler instanceof CompositeRuler) {
            CompositeRuler compositeRuler = (CompositeRuler)iVerticalRuler;
            if (!this.fShowLineNumber) {
                if (this.fLineNumberColumn != null) {
                    compositeRuler.removeDecorator((IVerticalRulerColumn)this.fLineNumberColumn);
                }
            } else {
                if (this.fLineNumberColumn == null) {
                    this.fLineNumberColumn = new LineNumberRulerColumn();
                    this.updateLineNumberColumnPresentation(false);
                }
                compositeRuler.addDecorator(0, (IVerticalRulerColumn)this.fLineNumberColumn);
            }
        }
    }

    private void updateLineNumberColumnPresentation(boolean bl) {
        if (this.fLineNumberColumn == null) {
            return;
        }
        RGB rGB = this.getColorFromStore(EditorsUI.getPreferenceStore(), "lineNumberColor");
        if (rGB == null) {
            rGB = new RGB(0, 0, 0);
        }
        ISharedTextColors iSharedTextColors = this.getSharedColors();
        this.fLineNumberColumn.setForeground(iSharedTextColors.getColor(rGB));
        if (bl) {
            this.fLineNumberColumn.redraw();
        }
    }

    private void layoutViewer() {
        Control control = this.getControl();
        if (control instanceof Composite && !control.isDisposed()) {
            ((Composite)control).layout(true);
        }
    }

    private ISharedTextColors getSharedColors() {
        return EditorsUI.getSharedTextColors();
    }

    private RGB getColorFromStore(IPreferenceStore iPreferenceStore, String string) {
        RGB rGB = null;
        if (iPreferenceStore.contains(string)) {
            rGB = iPreferenceStore.isDefault(string) ? PreferenceConverter.getDefaultColor((IPreferenceStore)iPreferenceStore, (String)string) : PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)string);
        }
        return rGB;
    }

    private void toggleLineNumberRuler() {
        this.fShowLineNumber = !this.fShowLineNumber;
        this.updateLineNumberRuler();
    }

    public void addTextAction(IAction iAction) {
        this.textActions.add(iAction);
    }

    public void addAction(String string, IAction iAction) {
        this.fActions.put(string, iAction);
    }

    private IOperationHistory getHistory() {
        if (PlatformUI.getWorkbench() == null) {
            return null;
        }
        return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
    }

    public void historyNotification(OperationHistoryEvent operationHistoryEvent) {
        IUndoContext iUndoContext = this.getUndoContext();
        if (iUndoContext != null && operationHistoryEvent.getOperation().hasContext(iUndoContext)) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MergeSourceViewer.this.updateContentDependantActions();
                }
            });
        }
    }

    private IUndoContext getUndoContext() {
        IUndoManager iUndoManager = this.getUndoManager();
        if (iUndoManager instanceof IUndoManagerExtension) {
            return ((IUndoManagerExtension)iUndoManager).getUndoContext();
        }
        return null;
    }

    class TextOperationAction
    extends MergeViewerAction {
        private int fOperationCode;

        TextOperationAction(int n, boolean bl, boolean bl2, boolean bl3) {
            this(n, null, bl, bl2, bl3);
        }

        public TextOperationAction(int n, String string, boolean bl, boolean bl2, boolean bl3) {
            super(bl, bl2, bl3);
            if (string != null) {
                this.setActionDefinitionId(string);
            }
            this.fOperationCode = n;
            this.update();
        }

        public void run() {
            if (this.isEnabled()) {
                MergeSourceViewer.this.doOperation(this.fOperationCode);
            }
        }

        public boolean isEnabled() {
            return this.fOperationCode != -1 && MergeSourceViewer.this.canDoOperation(this.fOperationCode);
        }

        public void update() {
            this.setEnabled(this.isEnabled());
        }
    }
}

