/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.jdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.TempAssignmentFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempDeclarationFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class InlineTempRefactoring
extends ScriptableRefactoring {
    private int fSelectionStart;
    private int fSelectionLength;
    private ICompilationUnit fCu;
    private VariableDeclaration fVariableDeclaration;
    private SimpleName[] fReferences;
    private CompilationUnit fASTRoot;

    public InlineTempRefactoring(ICompilationUnit unit, CompilationUnit node, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = unit;
        this.fASTRoot = node;
        this.fVariableDeclaration = null;
    }

    public InlineTempRefactoring(ICompilationUnit unit, int selectionStart, int selectionLength) {
        this(unit, null, selectionStart, selectionLength);
    }

    public InlineTempRefactoring(VariableDeclaration decl) {
        this.fVariableDeclaration = decl;
        ASTNode astRoot = decl.getRoot();
        Assert.isTrue((boolean)(astRoot instanceof CompilationUnit));
        this.fASTRoot = (CompilationUnit)astRoot;
        Assert.isTrue((boolean)(this.fASTRoot.getJavaElement() instanceof ICompilationUnit));
        this.fSelectionStart = decl.getStartPosition();
        this.fSelectionLength = decl.getLength();
        this.fCu = (ICompilationUnit)this.fASTRoot.getJavaElement();
    }

    public RefactoringStatus checkIfTempSelected() {
        VariableDeclaration decl = this.getVariableDeclaration();
        if (decl == null) {
            return CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.getASTRoot(), RefactoringCoreMessages.InlineTempRefactoring_select_temp);
        }
        if (decl.getParent() instanceof FieldDeclaration) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTemRefactoring_error_message_fieldsCannotBeInlined);
        }
        return new RefactoringStatus();
    }

    private CompilationUnit getASTRoot() {
        if (this.fASTRoot == null) {
            this.fASTRoot = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCu, true, null);
        }
        return this.fASTRoot;
    }

    public VariableDeclaration getVariableDeclaration() {
        if (this.fVariableDeclaration == null) {
            this.fVariableDeclaration = TempDeclarationFinder.findTempDeclaration(this.getASTRoot(), this.fSelectionStart, this.fSelectionLength);
        }
        return this.fVariableDeclaration;
    }

    public String getName() {
        return RefactoringCoreMessages.InlineTempRefactoring_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 1);
            RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            VariableDeclaration declaration = this.getVariableDeclaration();
            result.merge(this.checkSelection(declaration));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.checkInitializer(declaration));
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkInitializer(VariableDeclaration decl) {
        if (decl.getInitializer().getNodeType() == 33) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTemRefactoring_error_message_nulLiteralsCannotBeInlined);
        }
        return null;
    }

    private RefactoringStatus checkSelection(VariableDeclaration decl) {
        ASTNode parent = decl.getParent();
        if (parent instanceof MethodDeclaration) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_method_parameter);
        }
        if (parent instanceof CatchClause) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_exceptions_declared);
        }
        if (parent instanceof VariableDeclarationExpression && parent.getLocationInParent() == ForStatement.INITIALIZERS_PROPERTY) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_for_initializers);
        }
        if (decl.getInitializer() == null) {
            String message = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_not_initialized, decl.getName().getIdentifier());
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        return this.checkAssignments(decl);
    }

    private RefactoringStatus checkAssignments(VariableDeclaration decl) {
        TempAssignmentFinder assignmentFinder = new TempAssignmentFinder(decl);
        this.getASTRoot().accept((ASTVisitor)assignmentFinder);
        if (!assignmentFinder.hasAssignments()) {
            return new RefactoringStatus();
        }
        ASTNode firstAssignment = assignmentFinder.getFirstAssignment();
        int start = firstAssignment.getStartPosition();
        int length = firstAssignment.getLength();
        SourceRange range = new SourceRange(start, length);
        RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)this.fCu, range);
        String message = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_assigned_more_once, decl.getName().getIdentifier());
        return RefactoringStatus.createFatalErrorStatus((String)message, (RefactoringStatusContext)context);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 1);
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.InlineTempRefactoring_preview, 2);
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IJavaProject javaProject = this.fCu.getJavaProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            IVariableBinding binding = this.getVariableDeclaration().resolveBinding();
            String text = null;
            IMethodBinding method = binding.getDeclaringMethod();
            text = method != null ? BindingLabelProvider.getBindingLabel((IBinding)method, JavaElementLabels.ALL_FULLY_QUALIFIED) : "{...}";
            String description = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_descriptor_description_short, binding.getName());
            String header = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_descriptor_description, new String[]{BindingLabelProvider.getBindingLabel((IBinding)binding, JavaElementLabels.ALL_FULLY_QUALIFIED), text});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            comment.addSetting(Messages.format(RefactoringCoreMessages.InlineTempRefactoring_original_pattern, BindingLabelProvider.getBindingLabel((IBinding)binding, JavaElementLabels.ALL_FULLY_QUALIFIED)));
            JDTRefactoringDescriptor descriptor = new JDTRefactoringDescriptor("org.eclipse.jdt.ui.inline.temp", project, description, comment.asString(), arguments, 0);
            arguments.put("input", descriptor.elementToHandle((IJavaElement)this.fCu));
            arguments.put("selection", String.valueOf(String.valueOf(this.fSelectionStart)) + ' ' + String.valueOf(this.fSelectionLength));
            CompilationUnitRewrite cuRewrite = new CompilationUnitRewrite(this.fCu, this.fASTRoot);
            this.inlineTemp(cuRewrite);
            this.removeTemp(cuRewrite);
            CompilationUnitChange result = cuRewrite.createChange(RefactoringCoreMessages.InlineTempRefactoring_inline, false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            result.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor));
            CompilationUnitChange compilationUnitChange = result;
            return compilationUnitChange;
        }
        finally {
            pm.done();
        }
    }

    private void inlineTemp(CompilationUnitRewrite cuRewrite) throws JavaModelException {
        SimpleName[] references = this.getReferences();
        TextEditGroup groupDesc = cuRewrite.createGroupDescription(RefactoringCoreMessages.InlineTempRefactoring_inline_edit_name);
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        int i = 0;
        while (i < references.length) {
            SimpleName curr = references[i];
            Expression initializerCopy = this.getInitializerSource(cuRewrite, curr);
            rewrite.replace((ASTNode)curr, (ASTNode)initializerCopy, groupDesc);
            ++i;
        }
    }

    private boolean needsBrackets(SimpleName name, VariableDeclaration variableDeclaration) {
        Expression initializer = variableDeclaration.getInitializer();
        if (initializer instanceof Assignment) {
            return true;
        }
        return ASTNodes.substituteMustBeParenthesized(initializer, (Expression)name);
    }

    private void removeTemp(CompilationUnitRewrite cuRewrite) throws JavaModelException {
        VariableDeclaration variableDeclaration = this.getVariableDeclaration();
        TextEditGroup groupDesc = cuRewrite.createGroupDescription(RefactoringCoreMessages.InlineTempRefactoring_remove_edit_name);
        ASTNode parent = variableDeclaration.getParent();
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        if (parent instanceof VariableDeclarationStatement && ((VariableDeclarationStatement)parent).fragments().size() == 1) {
            rewrite.remove(parent, groupDesc);
        } else {
            rewrite.remove((ASTNode)variableDeclaration, groupDesc);
        }
    }

    private Expression getInitializerSource(CompilationUnitRewrite rewrite, SimpleName reference) throws JavaModelException {
        Expression copy = this.getModifiedInitializerSource(rewrite, reference);
        boolean brackets = this.needsBrackets(reference, this.getVariableDeclaration());
        if (brackets) {
            ParenthesizedExpression parentExpr = rewrite.getAST().newParenthesizedExpression();
            parentExpr.setExpression(copy);
            return parentExpr;
        }
        return copy;
    }

    private Expression getModifiedInitializerSource(CompilationUnitRewrite rewrite, SimpleName reference) throws JavaModelException {
        VariableDeclaration varDecl = this.getVariableDeclaration();
        Expression initializer = varDecl.getInitializer();
        ASTNode referenceContext = reference.getParent();
        if (InlineTempRefactoring.isInvocation(initializer) && Invocations.isResolvedTypeInferredFromExpectedType(initializer) && !(referenceContext instanceof VariableDeclarationFragment) && !(referenceContext instanceof SingleVariableDeclaration) && !(referenceContext instanceof Assignment)) {
            IMethodBinding methodBinding = Invocations.resolveBinding((ASTNode)initializer);
            ITypeBinding[] typeArguments = methodBinding.getTypeArguments();
            Type[] typeArgumentNodes = new Type[typeArguments.length];
            int i = 0;
            while (i < typeArguments.length) {
                typeArgumentNodes[i] = rewrite.getImportRewrite().addImport(typeArguments[i], rewrite.getAST());
                ++i;
            }
            String newSource = this.createParameterizedInvocation(initializer, typeArgumentNodes);
            return (Expression)rewrite.getASTRewrite().createStringPlaceholder(newSource, initializer.getNodeType());
        }
        Expression copy = (Expression)rewrite.getASTRewrite().createCopyTarget((ASTNode)initializer);
        if (initializer instanceof ArrayInitializer && ASTNodes.getDimensions(varDecl) > 0) {
            ArrayType newType = (ArrayType)ASTNodeFactory.newType(rewrite.getAST(), varDecl);
            ArrayCreation newArrayCreation = rewrite.getAST().newArrayCreation();
            newArrayCreation.setType(newType);
            newArrayCreation.setInitializer((ArrayInitializer)copy);
            return newArrayCreation;
        }
        return copy;
    }

    private String createParameterizedInvocation(Expression invocation, Type[] typeArgumentNodes) throws JavaModelException {
        ASTRewrite rewrite = ASTRewrite.create((AST)invocation.getAST());
        ListRewrite typeArgsRewrite = rewrite.getListRewrite((ASTNode)invocation, Invocations.getTypeArgumentsProperty(invocation));
        int i = 0;
        while (i < typeArgumentNodes.length) {
            typeArgsRewrite.insertLast((ASTNode)typeArgumentNodes[i], null);
            ++i;
        }
        Document document = new Document(this.fCu.getBuffer().getContents());
        RangeMarker marker = new RangeMarker(invocation.getStartPosition(), invocation.getLength());
        IJavaProject project = this.fCu.getJavaProject();
        TextEdit[] rewriteEdits = rewrite.rewriteAST((IDocument)document, project.getOptions(true)).removeChildren();
        marker.addChildren(rewriteEdits);
        try {
            marker.apply((IDocument)document, 2);
            String rewrittenInitializer = document.get(marker.getOffset(), marker.getLength());
            IRegion region = document.getLineInformation(document.getLineOfOffset(marker.getOffset()));
            int oldIndent = Strings.computeIndentUnits(document.get(region.getOffset(), region.getLength()), project);
            return Strings.changeIndent(rewrittenInitializer, oldIndent, project, "", TextUtilities.getDefaultLineDelimiter((IDocument)document));
        }
        catch (MalformedTreeException e) {
            JavaPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
        return this.fCu.getBuffer().getText(invocation.getStartPosition(), invocation.getLength());
    }

    private static boolean isInvocation(Expression node) {
        return node instanceof MethodInvocation || node instanceof SuperMethodInvocation;
    }

    public SimpleName[] getReferences() {
        if (this.fReferences != null) {
            return this.fReferences;
        }
        TempOccurrenceAnalyzer analyzer = new TempOccurrenceAnalyzer(this.getVariableDeclaration(), false);
        analyzer.perform();
        this.fReferences = analyzer.getReferenceNodes();
        return this.fReferences;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        if (!(arguments instanceof JavaRefactoringArguments)) return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
        String selection = extended.getAttribute("selection");
        if (selection == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
        int offset = -1;
        int length = -1;
        StringTokenizer tokenizer = new StringTokenizer(selection);
        if (tokenizer.hasMoreTokens()) {
            offset = Integer.valueOf(tokenizer.nextToken());
        }
        if (tokenizer.hasMoreTokens()) {
            length = Integer.valueOf(tokenizer.nextToken());
        }
        if (offset < 0 || length < 0) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
        }
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
        String handle = extended.getAttribute("input");
        if (handle == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        IJavaElement element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
        if (element == null || !element.exists() || element.getElementType() != 5) {
            return this.createInputFatalStatus(element, "org.eclipse.jdt.ui.inline.temp");
        }
        this.fCu = (ICompilationUnit)element;
        if (!this.checkIfTempSelected().hasFatalError()) return new RefactoringStatus();
        return this.createInputFatalStatus(element, "org.eclipse.jdt.ui.inline.temp");
    }
}

