/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.actions.NewServerWizardAction;
import org.eclipse.wst.server.ui.internal.view.servers.DeleteAction;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.eclipse.wst.server.ui.internal.view.servers.OpenAction;
import org.eclipse.wst.server.ui.internal.view.servers.PublishAction;
import org.eclipse.wst.server.ui.internal.view.servers.PublishCleanAction;
import org.eclipse.wst.server.ui.internal.view.servers.RemoveModuleAction;
import org.eclipse.wst.server.ui.internal.view.servers.ServerAction;
import org.eclipse.wst.server.ui.internal.view.servers.StartAction;

public class ServerActionHelper {
    public static final byte ACTION_OPEN = 0;
    public static final byte ACTION_DELETE = 1;
    public static final byte ACTION_BOOKMARK = 2;

    private ServerActionHelper() {
    }

    public static void fillContextMenu(Shell shell, ISelection selection, IMenuManager menu) {
        MenuManager newMenu = new MenuManager(Messages.actionNew);
        ServerActionHelper.fillNewContextMenu(shell, selection, (IMenuManager)newMenu);
        menu.add((IContributionItem)newMenu);
        ServerActionHelper.fillOtherContextMenu(shell, selection, menu);
    }

    public static void fillNewContextMenu(Shell shell, ISelection selection, IMenuManager menu) {
        NewServerWizardAction newServerAction = new NewServerWizardAction();
        newServerAction.setText(Messages.actionNewServer);
        menu.add((IAction)newServerAction);
    }

    public static void fillOtherContextMenu(Shell shell, ISelection selection, IMenuManager menu) {
        if (selection == null) {
            return;
        }
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
    }

    protected static void addServerActions(Shell shell, IMenuManager menu, IServer server) {
        StructuredSelection selection = new StructuredSelection((Object)server);
        ISelectionProvider provider = new ISelectionProvider((ISelection)selection){
            private final /* synthetic */ ISelection val$selection;
            {
                this.val$selection = iSelection;
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return this.val$selection;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection sel) {
            }
        };
        menu.add((IAction)new StartAction(shell, provider, "debug"));
        menu.add((IAction)new StartAction(shell, provider, "run"));
        menu.add((IAction)new StartAction(shell, provider, "profile"));
        menu.add((IAction)new PublishAction(shell, provider));
        menu.add((IAction)new PublishCleanAction(shell, provider));
    }

    public static boolean isActionEnabled(ISelection selection, byte action) {
        if (selection == null || action < 0) {
            return false;
        }
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (action == 0) {
            return false;
        }
        if (action == 1) {
            IModule[] module = null;
            if (!sel.isEmpty()) {
                Iterator iterator = sel.iterator();
                Object obj = iterator.next();
                if (obj instanceof ModuleServer) {
                    ModuleServer ms = (ModuleServer)obj;
                    module = ms.module;
                }
                if (iterator.hasNext()) {
                    module = null;
                }
            }
            return module == null || module.length == 1;
        }
        return false;
    }

    public static boolean performAction(Shell shell, ISelection selection, byte action) {
        if (selection == null || action < 0) {
            return false;
        }
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (action == 0) {
            if (sel.size() != 1) {
                return false;
            }
            Object obj = sel.getFirstElement();
            if (obj instanceof IServer) {
                OpenAction open = new OpenAction((IServer)obj);
                open.run();
                return true;
            }
            return false;
        }
        if (action == 1) {
            IServer server = null;
            IModule[] module = null;
            if (!sel.isEmpty()) {
                Iterator iterator = sel.iterator();
                Object obj = iterator.next();
                if (obj instanceof IServer) {
                    server = (IServer)obj;
                }
                if (obj instanceof ModuleServer) {
                    ModuleServer ms = (ModuleServer)obj;
                    server = ms.server;
                    module = ms.module;
                }
                if (iterator.hasNext()) {
                    server = null;
                    module = null;
                }
            }
            if (module == null) {
                new DeleteAction(shell, server).run();
            } else if (module.length == 1) {
                new RemoveModuleAction(shell, server, module[0]).run();
            }
            return true;
        }
        return false;
    }

    public static IAction getAction(Shell shell, ISelectionProvider provider, byte action) {
        if (action == 1) {
            return new ServerAction(shell, provider, Messages.actionDelete, 1);
        }
        return null;
    }
}

