/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IStreamMonitor;

public class DebugConsoleMonitor
implements IFlushableStreamMonitor {
    private StringBuffer fContents = new StringBuffer();
    private Vector fListeners = new Vector(1);
    private boolean fBuffered = true;

    public void addListener(IStreamListener iStreamListener) {
        this.fListeners.add(iStreamListener);
    }

    public String getContents() {
        return this.fContents.toString();
    }

    public void removeListener(IStreamListener iStreamListener) {
        this.fListeners.remove(iStreamListener);
    }

    public void append(String string) {
        if (this.isBuffered()) {
            this.fContents.append(string);
        }
        Enumeration enumeration = this.fListeners.elements();
        while (enumeration.hasMoreElements()) {
            IStreamListener iStreamListener = (IStreamListener)enumeration.nextElement();
            iStreamListener.streamAppended(string, (IStreamMonitor)this);
        }
    }

    public void flushContents() {
        this.fContents.setLength(0);
    }

    public boolean isBuffered() {
        return this.fBuffered;
    }

    public void setBuffered(boolean bl) {
        this.fBuffered = bl;
    }
}

