/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jdtutility;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jpt.core.internal.jdtutility.AbstractExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.ExpressionConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CharacterStringExpressionConverter
extends AbstractExpressionConverter<String, CharacterLiteral> {
    private static ExpressionConverter<String, CharacterLiteral> INSTANCE;

    public static ExpressionConverter<String, CharacterLiteral> instance() {
        if (INSTANCE == null) {
            INSTANCE = new CharacterStringExpressionConverter();
        }
        return INSTANCE;
    }

    private CharacterStringExpressionConverter() {
    }

    @Override
    protected CharacterLiteral convert_(String string, AST ast) {
        CharacterLiteral characterLiteral = ast.newCharacterLiteral();
        characterLiteral.setCharValue(string.charAt(0));
        return characterLiteral;
    }

    @Override
    protected String convert_(CharacterLiteral characterLiteral) {
        return characterLiteral.getNodeType() == 13 ? Character.toString(characterLiteral.charValue()) : null;
    }
}

