/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.hsqldb.ui.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.internal.ui.DelimitedStringList;
import org.eclipse.datatools.connectivity.internal.ui.DriverListCombo;
import org.eclipse.datatools.connectivity.ui.wizards.ConnectionProfileDetailsPage;
import org.eclipse.datatools.enablement.hsqldb.ui.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class HSQLDBProfileDetailsWizardPage
extends ConnectionProfileDetailsPage {
    private Text mDatabaseNameText;
    private Text mURLText;
    private Text mDBUIDText;
    private Text mDBPWDText;
    private Button mSaveDBPWDCheckbox;
    private DelimitedStringList mDBConnProps;
    final DriverListCombo combo = new DriverListCombo();
    private Text mDBFilePathText;
    private Button mBrowseFilePathButton;
    private DriverInstance mDriverInstance;
    private String mDriverCategory;

    public HSQLDBProfileDetailsWizardPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString("HSQLDBProfileDetailsWizardPage.title"));
        this.setDescription(Messages.getString("HSQLDBProfileDetailsWizardPage.msg"));
        this.setDriverCategory("org.eclipse.datatools.enablement.hsqldb.driver.category");
    }

    public void createCustomControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        content.setLayout((Layout)layout);
        this.combo.setLabelText(Messages.getString("HSQLDBProfileDetailsWizardPage.driverCombo.label"));
        this.combo.setCategory(this.getDriverCategory());
        this.combo.setNullDriverIsValid(false);
        this.combo.createContents(content);
        if (this.combo.getErrorMessage() != null) {
            this.setErrorMessage(this.combo.getErrorMessage());
        }
        this.mDatabaseNameText = (Text)this.createLabelTextPair(content, Messages.getString("HSQLDBProfileDetailsWizardPage.databaseName.label"), (Control)this.mURLText, 2048, 768);
        Label label = new Label(content, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(Messages.getString("HSQLDBProfileDetailsWizardPage.0"));
        Composite textAndBrowseComposite = new Composite(content, 0);
        GridLayout subCompositeLayout = new GridLayout(2, false);
        subCompositeLayout.marginLeft = -5;
        subCompositeLayout.marginRight = -5;
        subCompositeLayout.marginTop = -5;
        subCompositeLayout.marginBottom = -5;
        textAndBrowseComposite.setLayout((Layout)subCompositeLayout);
        textAndBrowseComposite.setLayoutData((Object)new GridData(768));
        this.mDBFilePathText = new Text(textAndBrowseComposite, 2048);
        this.mDBFilePathText.setLayoutData((Object)new GridData(768));
        this.mBrowseFilePathButton = new Button(textAndBrowseComposite, 8);
        this.mBrowseFilePathButton.setText(Messages.getString("HSQLDBProfileDetailsWizardPage.1"));
        this.mBrowseFilePathButton.setLayoutData((Object)new GridData(128));
        this.mDBUIDText = (Text)this.createLabelTextPair(content, Messages.getString("HSQLDBProfileDetailsWizardPage.userName.label"), (Control)this.mDBUIDText, 2048, 768);
        this.mDBPWDText = (Text)this.createLabelTextPair(content, Messages.getString("HSQLDBProfileDetailsWizardPage.password.label"), (Control)this.mDBPWDText, 0x400800, 768);
        this.mURLText = (Text)this.createLabelTextPair(content, Messages.getString("HSQLDBProfileDetailsWizardPage.url.label"), (Control)this.mURLText, 2048, 768);
        this.mSaveDBPWDCheckbox = new Button(content, 32);
        this.mSaveDBPWDCheckbox.setText(Messages.getString("HSQLDBProfileDetailsWizardPage.persistpassword.label"));
        this.mSaveDBPWDCheckbox.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        Composite spacer = new Composite(content, 0);
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        gdata.heightHint = 20;
        spacer.setLayoutData((Object)gdata);
        label = new Label(content, 0);
        gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        label.setLayoutData((Object)gdata);
        label.setText(Messages.getString("HSQLDBProfileDetailsWizardPage.optionalProps.label"));
        this.mDBConnProps = new DelimitedStringList(content, 0);
        gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        this.mDBConnProps.setLayoutData((Object)gdata);
        this.mDBConnProps.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                HSQLDBProfileDetailsWizardPage.this.setErrorMessage(null);
                if (HSQLDBProfileDetailsWizardPage.this.mDBConnProps.getWarning() != null) {
                    HSQLDBProfileDetailsWizardPage.this.setErrorMessage(HSQLDBProfileDetailsWizardPage.this.mDBConnProps.getWarning());
                }
            }
        });
        this.combo.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                HSQLDBProfileDetailsWizardPage.this.mDriverInstance = HSQLDBProfileDetailsWizardPage.this.combo.getSelectedDriverInstance();
                HSQLDBProfileDetailsWizardPage.this.setErrorMessage(null);
                if (HSQLDBProfileDetailsWizardPage.this.combo.getErrorMessage() != null) {
                    HSQLDBProfileDetailsWizardPage.this.setErrorMessage(HSQLDBProfileDetailsWizardPage.this.combo.getErrorMessage());
                }
                HSQLDBProfileDetailsWizardPage.this.mDatabaseNameText.setText(HSQLDBProfileDetailsWizardPage.this.getDriverDatabaseName());
                HSQLDBProfileDetailsWizardPage.this.mURLText.setText(HSQLDBProfileDetailsWizardPage.this.getDriverURL());
                HSQLDBProfileDetailsWizardPage.this.updatePropsFromURL();
                String username = HSQLDBProfileDetailsWizardPage.this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.username");
                if (username == null || username.trim().length() == 0) {
                    username = new String();
                }
                HSQLDBProfileDetailsWizardPage.this.mDBUIDText.setText(username);
                String password = HSQLDBProfileDetailsWizardPage.this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.password");
                if (password == null || password.trim().length() == 0) {
                    password = new String();
                }
                HSQLDBProfileDetailsWizardPage.this.mDBPWDText.setText(password);
                HSQLDBProfileDetailsWizardPage.this.setPageComplete(HSQLDBProfileDetailsWizardPage.this.isValid());
            }
        });
        this.mDBFilePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HSQLDBProfileDetailsWizardPage.this.updateURLFromProps();
            }
        });
        this.mBrowseFilePathButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                HSQLDBProfileDetailsWizardPage.this.browseForDBFolder();
            }

            public void widgetSelected(SelectionEvent e) {
                HSQLDBProfileDetailsWizardPage.this.browseForDBFolder();
            }
        });
        this.combo.selectFirstItem();
        if (this.mDriverInstance == null) {
            this.mDriverInstance = this.combo.getSelectedDriverInstance();
        }
        if (this.mDriverInstance != null) {
            this.mURLText.setText(this.getDriverURL());
        }
        this.mURLText.setEnabled(false);
    }

    private void browseForDBFolder() {
        String selectedDirectory;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText(Messages.getString("HSQLDBProfileDetailsWizardPage.FileDialog.title.filebrowse"));
        dialog.setMessage(Messages.getString("HSQLDBProfileDetailsWizardPage.FileDialog.msg.filebrowse"));
        String dirName = this.mDBFilePathText.getText();
        File path = new File(dirName);
        if (path.exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.mDBFilePathText.setText(selectedDirectory);
        }
    }

    private void updatePropsFromURL() {
        String[] chunks2;
        String url;
        String[] chunks;
        if (this.mDBFilePathText != null && this.mURLText != null && (chunks = this.parseString(url = this.mURLText.getText(), ";")).length > 0 && (chunks2 = this.parseString(chunks[0], ":")).length > 2) {
            String filepath = chunks2[2];
            if (chunks2.length > 3) {
                filepath = String.valueOf(filepath) + ":" + chunks2[3];
            }
            this.mDBFilePathText.setText(filepath);
        }
    }

    private void updateURLFromProps() {
        if (this.mDBFilePathText != null && this.mURLText != null) {
            String[] chunks2;
            String url = this.mURLText.getText();
            String filePath = this.mDBFilePathText.getText();
            String[] chunks = this.parseString(url, ";");
            if (chunks.length > 0 && (chunks2 = this.parseString(chunks[0], ":")).length > 2) {
                url = String.valueOf(chunks2[0]) + ":" + chunks2[1] + ":" + filePath;
                this.mURLText.setText(url);
            }
        }
    }

    private String[] parseString(String str_list, String token) {
        StringTokenizer tk = new StringTokenizer(str_list, token);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }

    private String getPropertyFromDriverInstance(String propertyID) {
        String returnStr = new String();
        if (this.mDriverInstance != null && this.mDriverInstance.getProperty(propertyID) != null) {
            returnStr = this.mDriverInstance.getProperty(propertyID);
        }
        return returnStr;
    }

    public String getDriverURL() {
        if (this.mDriverInstance != null && this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.URL") != null) {
            return this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.URL");
        }
        return new String();
    }

    public String getDriverDatabaseName() {
        if (this.mDriverInstance != null && this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.databaseName") != null) {
            return this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.databaseName");
        }
        return new String();
    }

    public String getVendor() {
        String vendor = "";
        if (this.mDriverInstance != null) {
            vendor = this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.vendor");
        }
        return vendor;
    }

    public String getVersion() {
        String version = "";
        if (this.mDriverInstance != null) {
            version = this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.version");
        }
        return version;
    }

    public String getDriverClass() {
        String driverClass = "";
        if (this.mDriverInstance != null) {
            driverClass = this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.driverClass");
        }
        return driverClass;
    }

    public String getDBUID() {
        return this.mDBUIDText.getText();
    }

    public String getDBPWD() {
        return this.mDBPWDText.getText();
    }

    public boolean getSaveDBPWD() {
        return this.mSaveDBPWDCheckbox.getSelection();
    }

    public String getDBConnProps() {
        return this.mDBConnProps.getSelection();
    }

    public String getDatabaseName() {
        return this.mDatabaseNameText.getText();
    }

    public String getURL() {
        return this.mURLText.getText();
    }

    public String getDriverID() {
        return this.mDriverInstance.getId();
    }

    private Control createLabelTextPair(Composite parent, String labelText, Control ctl, int style, int gData) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(labelText);
        ctl = new Text(parent, style);
        ctl.setLayoutData((Object)new GridData(gData));
        return ctl;
    }

    public List getSummaryData() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        data.add(new String[]{Messages.getString("HSQLDBProfileDetailsWizardPage.summary.driverName.label"), this.mDriverInstance.getName()});
        data.add(new String[]{Messages.getString("HSQLDBProfileDetailsWizardPage.summary.connProps.label"), this.getDBConnProps()});
        data.add(new String[]{Messages.getString("HSQLDBProfileDetailsWizardPage.summary.userName.label"), this.getDBUID()});
        StringBuffer pwdMask = new StringBuffer();
        if (this.getDBPWD() != null && this.getDBPWD().length() > 0) {
            int i = 0;
            int count = this.getDBPWD().length();
            while (i < count) {
                pwdMask = pwdMask.append('*');
                ++i;
            }
        }
        data.add(new String[]{Messages.getString("HSQLDBProfileDetailsWizardPage.summary.password.label"), pwdMask.toString()});
        data.add(new String[]{Messages.getString("HSQLDBProfileDetailsWizardPage.summary.url.label"), this.getURL()});
        return data;
    }

    private boolean isValid() {
        if (this.getErrorMessage() != null) {
            this.setPageComplete(false);
            return false;
        }
        return true;
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        this.isValid();
    }

    public String getDriverCategory() {
        return this.mDriverCategory;
    }

    public void setDriverCategory(String driverCategory) {
        this.mDriverCategory = driverCategory;
        if (this.combo != null) {
            this.combo.setCategory(this.mDriverCategory);
        }
    }
}

