/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ColumnAlignedResultItem;
import org.eclipse.datatools.sqltools.result.internal.utils.ILogger;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.datatools.sqltools.result.internal.utils.StatusTextProvider;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.IUpdate;

public class SaveResultInstanceAction
extends Action
implements IUpdate {
    private static ILogger _log = ResultsViewPlugin.getLogger(null);
    Shell _shell;
    ISelectionProvider _provider;

    public SaveResultInstanceAction(Shell shell, ISelectionProvider selectionProvider) {
        super(Messages.SaveResultInstanceAction_save_history);
        this._shell = shell;
        this._provider = selectionProvider;
    }

    public void update() {
        IStructuredSelection selection = (IStructuredSelection)this._provider.getSelection();
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        Object[] obj = selection.toArray();
        if (obj == null || obj.length == 0 || obj.length > 1) {
            this.setEnabled(false);
            return;
        }
        if (!(obj[0] instanceof IResultInstance)) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this._provider.getSelection();
        Object[] obj = selection.toArray();
        if (obj == null || obj.length == 0 || obj.length > 1) {
            return;
        }
        IResultInstance instance = (IResultInstance)obj[0];
        FileDialog dialog = new FileDialog(this._shell, 8192);
        dialog.setText(Messages.SaveResultInstanceAction_save_hisotry_title);
        String filename = "";
        boolean selectAgain = false;
        do {
            if ((filename = dialog.open()) == null) {
                return;
            }
            File file = new File(filename);
            if (!file.exists()) continue;
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            String question = NLS.bind((String)Messages.ResultExportWizard_overwrite, (Object[])new Object[]{filename});
            MessageDialog d = new MessageDialog(this._shell, Messages.ResultExportWizard_question, null, question, 3, buttons, 0);
            int overwrite = d.open();
            switch (overwrite) {
                case 0: {
                    selectAgain = false;
                    break;
                }
                case 1: {
                    selectAgain = true;
                    break;
                }
                default: {
                    return;
                }
            }
        } while (selectAgain);
        try {
            FileOutputStream fos = new FileOutputStream(new File(filename));
            PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8")));
            w.print(StatusTextProvider.getHistoryHeader(instance));
            w.println("---------------------------------------------------------------------------------------");
            w.println("");
            String dispStr = ColumnAlignedResultItem.getResultInstanceDispString(instance, ResultsViewPlugin.getDefault().getPreferenceStore().getString("org.eclipse.datatools.sqltools.result.preferences.display.nulldisplaystr"));
            w.print(dispStr);
            w.close();
        }
        catch (IOException ex) {
            _log.error("SaveResultInstanceAction_cant_export_result_log", (Throwable)ex);
            ErrorDialog.openError((Shell)this._shell, (String)Messages.SaveResultInstanceAction_save_error, (String)Messages.SaveResultInstanceAction_can_not_save, (IStatus)new Status(4, ResultsViewPlugin.getPluginId(), 0, ex.getMessage(), (Throwable)ex));
        }
    }
}

