/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.earcreation;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.earcreation.IEarFacetInstallDataModelProperties;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.project.facet.J2EEFacetInstallDataModelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class EarFacetInstallDataModelProvider
extends J2EEFacetInstallDataModelProvider
implements IEarFacetInstallDataModelProperties {
    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("IEarFacetInstallDataModelProperties.CONTENT_DIR");
        names.add("IEarFacetInstallDataModelProperties.J2EE_PROJECTS_LIST");
        names.add("IEarFacetInstallDataModelProperties.JAVA_PROJECT_LIST");
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IFacetDataModelProperties.FACET_ID")) {
            return "jst.ear";
        }
        if (propertyName.equals("IEarFacetInstallDataModelProperties.CONTENT_DIR")) {
            return J2EEPlugin.getDefault().getJ2EEPreferences().getString("earContent");
        }
        if (propertyName.equals("IEarFacetInstallDataModelProperties.J2EE_PROJECTS_LIST") || propertyName.equals("IEarFacetInstallDataModelProperties.JAVA_PROJECT_LIST")) {
            return Collections.EMPTY_LIST;
        }
        if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.GENERATE_DD")) {
            return J2EEPlugin.getDefault().getJ2EEPreferences().getBoolean("application_generate_dd");
        }
        return super.getDefaultProperty(propertyName);
    }

    public IStatus validate(String name) {
        if (name.equals("IEarFacetInstallDataModelProperties.J2EE_PROJECTS_LIST")) {
            return this.validateTargetComponentVersion((List)this.model.getProperty("IEarFacetInstallDataModelProperties.J2EE_PROJECTS_LIST"));
        }
        if (name.equals("IEarFacetInstallDataModelProperties.CONTENT_DIR")) {
            return this.validateFolderName(this.getStringProperty("IEarFacetInstallDataModelProperties.CONTENT_DIR"));
        }
        return super.validate(name);
    }

    private IStatus validateTargetComponentVersion(List list) {
        int earVersion = this.getJ2EEVersion();
        for (IProject handle : list) {
            IVirtualComponent comp = ComponentCore.createComponent((IProject)handle.getProject());
            if (comp == null) {
                return OK_STATUS;
            }
            int compVersion = J2EEVersionUtil.convertVersionStringToInt(comp);
            if (earVersion >= compVersion) continue;
            String errorStatus = "The Module specification level of " + handle.getName() + ", is incompatible with the containing EAR version";
            return J2EEPlugin.newErrorStatus(errorStatus, null);
        }
        return OK_STATUS;
    }

    protected int convertFacetVersionToJ2EEVersion(IProjectFacetVersion version) {
        return J2EEVersionUtil.convertVersionStringToInt(version.getVersionString());
    }
}

